/*
 * Decompiled with CFR 0.152.
 */
package smallsql.database;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.sql.SQLException;
import smallsql.database.Expression;
import smallsql.database.ExpressionValue;
import smallsql.database.Identity;
import smallsql.database.SSConnection;
import smallsql.database.SSResultSetMetaData;
import smallsql.database.SmallSQLException;

class Column
implements Cloneable {
    private Expression defaultValue = Expression.NULL;
    private String defaultDefinition;
    private String name;
    private boolean identity;
    private boolean caseSensitive;
    private boolean nullable = true;
    private int scale;
    private int precision;
    private int dataType;
    private Identity counter;

    Column() {
    }

    void setName(String string) {
        this.name = string;
    }

    void setDefaultValue(Expression expression, String string) {
        this.defaultValue = expression;
        this.defaultDefinition = string;
    }

    Expression getDefaultValue(SSConnection sSConnection) throws SQLException {
        if (this.identity) {
            this.counter.createNextValue(sSConnection);
        }
        return this.defaultValue;
    }

    String getDefaultDefinition() {
        return this.defaultDefinition;
    }

    String getName() {
        return this.name;
    }

    boolean isAutoIncrement() {
        return this.identity;
    }

    void setAutoIncrement(boolean bl) {
        this.identity = bl;
    }

    int initAutoIncrement(FileChannel fileChannel, long l) throws IOException {
        if (this.identity) {
            this.counter = new Identity(fileChannel, l);
            this.defaultValue = new ExpressionValue(this.counter, 325);
        }
        return 8;
    }

    void setNewAutoIncrementValue(Expression expression) throws Exception {
        if (this.identity) {
            this.counter.setNextValue(expression);
        }
    }

    boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    void setNullable(boolean bl) {
        this.nullable = bl;
    }

    boolean isNullable() {
        return this.nullable;
    }

    void setDataType(int n) {
        this.dataType = n;
    }

    int getDataType() {
        return this.dataType;
    }

    int getDisplaySize() {
        return SSResultSetMetaData.getDisplaySize(this.dataType, this.precision, this.scale);
    }

    void setScale(int n) {
        this.scale = n;
    }

    int getScale() {
        switch (this.dataType) {
            case 332: 
            case 333: {
                return this.scale;
            }
        }
        return Expression.getScale(this.dataType);
    }

    void setPrecision(int n) throws SQLException {
        if (n < 0) {
            throw SmallSQLException.create("SS-0403", new Object[]{new Integer(n), this.name});
        }
        this.precision = n;
    }

    int getPrecision() {
        return SSResultSetMetaData.getDataTypePrecision(this.dataType, this.precision);
    }

    int getColumnSize() {
        if (SSResultSetMetaData.isNumberDataType(this.dataType)) {
            return this.getPrecision();
        }
        return this.getDisplaySize();
    }

    int getFlag() {
        return (this.identity ? 1 : 0) | (this.caseSensitive ? 2 : 0) | (this.nullable ? 4 : 0);
    }

    void setFlag(int n) {
        this.identity = (n & 1) > 0;
        this.caseSensitive = (n & 2) > 0;
        this.nullable = (n & 4) > 0;
    }

    Column copy() {
        try {
            return (Column)this.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

