/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.exportwebui;

import com.inet.http.ClientMessageException;
import com.inet.http.servlet.ClientLocale;
import com.inet.http.servlet.ClientTimezone;
import com.inet.report.Engine;
import com.inet.report.RDC;
import com.inet.report.ReportException;
import com.inet.report.ReportKeyFactory;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;
import com.inet.report.exportwebui.api.ExportReportHandlerBase;
import com.inet.report.exportwebui.api.data.ExportReportResponse;
import com.inet.report.exportwebui.data.ExportReportHandlerRequest;
import com.inet.report.renderer.api.RendererFactory;
import com.inet.report.renderer.api.RendererFactoryManager;
import com.inet.report.util.ReportKeyUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public class b
extends ExportReportHandlerBase<ExportReportHandlerRequest> {
    public ExportReportResponse a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, ExportReportHandlerRequest exportReportHandlerRequest) throws IOException {
        if (exportReportHandlerRequest == null) {
            throw new ClientMessageException("Only async formats are currently supported by the export handler.");
        }
        String string = exportReportHandlerRequest.getFormat();
        Properties properties = exportReportHandlerRequest.getReportData();
        properties.put("export_fmt", string);
        properties.put("locale", ClientLocale.getThreadLocale().toString());
        properties.put("timezone", ClientTimezone.getTimeZone().getID());
        RendererFactory rendererFactory = RendererFactoryManager.getInstance().getDocumentRenderer(string);
        try {
            Object object;
            ReportKeyFactory.decodeProps(properties);
            Cache cache = Cache.getCache();
            Objects.requireNonNull(cache);
            ReportCacheKey reportCacheKey = cache.createKey(properties, Cache.getPropertiesChecker(), httpServletRequest);
            if (!cache.exists(reportCacheKey)) {
                object = RDC.loadEngine(properties);
                cache.addEngine((Engine)object, reportCacheKey);
            } else {
                cache.resetCacheTimeout(reportCacheKey);
            }
            object = rendererFactory.getEngineExportFormat(string);
            String string2 = properties.getProperty("report");
            String string3 = ReportKeyUtils.getRelevantParams(properties, false, false);
            return new ExportReportResponse(string2, (String)object, string3);
        }
        catch (ReportException reportException) {
            throw new ClientMessageException(reportException.getMessage());
        }
    }

    public String getMethodName() {
        return "reportexportaction";
    }

    public /* synthetic */ Object invoke(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, Object object) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (ExportReportHandlerRequest)object);
    }
}

