/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.Database;
import com.inet.report.Datasource;
import com.inet.report.Field;
import com.inet.report.Fields;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReportDataHandler;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.database.DataFactory;
import com.inet.report.i18n.ReportErrorCode;
import java.io.PrintWriter;
import java.util.StringTokenizer;

@PublicApi
public class DatabaseField
extends Field {
    int kS;
    Field kT;
    TableSource kU = null;
    private String kV = "";
    String kW;

    DatabaseField(ba ren) {
        this.type = 14;
        this.bB = ren;
    }

    @Override
    public void setName(String fullname) throws ReportException {
        Object object;
        Object object2;
        if (fullname == null || fullname.length() == 0) {
            throw new IllegalArgumentException("The name of a database field cannot be empty.");
        }
        try {
            String string;
            StringTokenizer stringTokenizer = new StringTokenizer(fullname, "\".", true);
            object2 = stringTokenizer.nextToken();
            if (((String)object2).equals("\"")) {
                do {
                    string = stringTokenizer.nextToken();
                    object2 = (String)object2 + string;
                } while (!string.equals("\""));
            }
            stringTokenizer.nextToken();
            object = stringTokenizer.nextToken();
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                object = (String)object + string;
            }
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.missingAliasOrTableName, fullname);
        }
        this.kU = this.bB.jc().getTablesource((String)object2);
        int n2 = this.kU.ar((String)object);
        if (n2 == -1) {
            return;
        }
        this.name = fullname;
        this.kW = object;
        this.valueType = n2;
        Fields.a(this.bB, this, 2);
    }

    public void setColumnLabel(String columnLabel) {
        if (columnLabel == null) {
            columnLabel = "";
        }
        this.kV = columnLabel;
        Fields.a(this.bB, this, 2);
    }

    public String getColumnLabel() {
        return this.hasColumnLabel() ? this.kV : this.getShortName();
    }

    public boolean hasColumnLabel() {
        return !this.kV.isBlank();
    }

    public String getShortName() {
        return this.kW;
    }

    @Override
    public void rename(String newName) throws ReportException {
        if (this.bB.jd().contains(newName)) {
            DatabaseField databaseField = this.bB.jd().get(newName);
            this.bB.jd().removeElement(databaseField);
            DatabaseField databaseField2 = this;
            TableSource tableSource = databaseField.kU;
            databaseField2.getTableSource().e(databaseField2);
            tableSource.a(databaseField2);
            tableSource.e(databaseField);
            ReferenceHolder[] referenceHolderArray = databaseField.getReferenceHolders();
            int n2 = referenceHolderArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                ReferenceHolder referenceHolder;
                ReferenceHolder referenceHolder2 = referenceHolder = referenceHolderArray[i2];
                databaseField2.addReferenceHolder(referenceHolder2);
            }
        }
        int n3 = newName.indexOf(".");
        this.kW = newName.substring(n3 + 1);
        super.rename(newName);
    }

    @Override
    Field[] D(int n2) {
        return new DatabaseField[n2];
    }

    @Override
    protected void p(PrintWriter printWriter, int n2) {
    }

    @Override
    void a(int n2, String string, at at2) {
        switch (n2) {
            case 174: {
                this.kW = string;
                break;
            }
            default: {
                super.a(n2, string, at2);
            }
        }
    }

    public TableSource getTableSource() {
        return this.kU;
    }

    @Override
    Object getValue() throws ReportException {
        ReportDataHandler reportDataHandler = this.bB.gN();
        if (reportDataHandler.getRowSource() == null) {
            Datasource datasource = this.kU != null ? this.kU.getDatasource() : this.bB.jc().getDatasource(0);
            DataFactory dataFactory = datasource.getDataFactory();
            if (dataFactory instanceof Database) {
                return ((Database)dataFactory).convertIdentifier(datasource, this.name);
            }
            return this.name;
        }
        int n2 = this.da();
        if (n2 < 0) {
            this.U(reportDataHandler.getColumnIdx(this));
            n2 = this.da();
        }
        return reportDataHandler.getObject(n2);
    }

    public String toString() {
        return super.toString() + "_" + this.kV + "_" + this.kW + "_" + this.kS;
    }
}

