/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.webapi.reporting;

import com.inet.http.ClientMessageException;
import com.inet.logging.LogManager;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.plugin.webapi.api.handler.RequestHandlerBase;
import com.inet.report.Engine;
import com.inet.report.ReportException;
import com.inet.report.SummaryInfo;
import com.inet.report.webapi.ReportingWebAPIExtension;
import com.inet.report.webapi.reporting.b;
import com.inet.report.webapi.reporting.c;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Reporting", description="Report information operations")
public class a
extends RequestHandler<Void, Map<String, Object>> {
    public a() {
        super(new String[]{"report"});
        this.registerRequestHandler((RequestHandlerBase)new b());
        this.registerRequestHandler((RequestHandlerBase)new c());
    }

    public String getHelpPageKey() {
        return "webapi.reporting.report";
    }

    @Operation(summary="Get report information", description="Retrieves metadata information about a report file", responses={@ApiResponse(responseCode="200", description="Report information retrieved successfully", content={@Content(examples={@ExampleObject(name="3D Chart Sample", value="{\"comments\":\"This report shows the usage of 3D Pyramid and Cone Charts.\",\"keywords\":\"chart,cross tab\",\"author\":\"i-net software\",\"created\":1165850609000,\"subject\":\"3D chart\",\"reportTitle\":\"3D Charts\",\"lastSaved\":1601391061000}")})}), @ApiResponse(responseCode="400", description="Report parameter not defined or invalid"), @ApiResponse(responseCode="500", description="Error reading report file")})
    @Parameter(description="The report that should be rendered", in=ParameterIn.QUERY, name="report", required=true)
    public Map<String, Object> a(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Void void_, boolean bl2) throws IOException {
        String string = httpServletRequest.getParameter("report");
        if (string == null || string.length() == 0) {
            throw new ClientMessageException(ReportingWebAPIExtension.LANG.getMsg("webapi.reporting.parameterNotDefined", new Object[]{"report"}));
        }
        try {
            Engine engine = new Engine("java");
            engine.setReportFile(string);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            SummaryInfo summaryInfo = engine.getSummaryInfo();
            this.a(hashMap, "author", summaryInfo.getAuthor());
            this.a(hashMap, "comments", summaryInfo.getComments());
            this.a(hashMap, "created", summaryInfo.getCreated());
            this.a(hashMap, "keywords", summaryInfo.getKeywords());
            this.a(hashMap, "lastSaved", summaryInfo.getLastSaved());
            this.a(hashMap, "reportTitle", summaryInfo.getReportTitle());
            this.a(hashMap, "subject", summaryInfo.getSubject());
            this.a(hashMap, "template", summaryInfo.getTemplate());
            return hashMap;
        }
        catch (ReportException reportException) {
            LogManager.getApplicationLogger().error((Throwable)reportException);
            throw new ClientMessageException(ReportingWebAPIExtension.LANG.getMsg("webapi.reporting.reportFileError", new Object[]{string, reportException.getMessage()}));
        }
    }

    private void a(Map<String, Object> map, String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String && ((String)object).length() == 0) {
            return;
        }
        map.put(string, object);
    }

    @Operation(summary="Get report information", description="Retrieves metadata information about a report file", responses={@ApiResponse(responseCode="200", description="Report information retrieved successfully", content={@Content(examples={@ExampleObject(name="3D Chart Sample", value="{\"comments\":\"This report shows the usage of 3D Pyramid and Cone Charts.\",\"keywords\":\"chart,cross tab\",\"author\":\"i-net software\",\"created\":1165850609000,\"subject\":\"3D chart\",\"reportTitle\":\"3D Charts\",\"lastSaved\":1601391061000}")})}), @ApiResponse(responseCode="400", description="Report parameter not defined or invalid"), @ApiResponse(responseCode="500", description="Error reading report file")})
    @Parameter(description="The report that should be rendered", in=ParameterIn.QUERY, name="report", required=true)
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl2) throws IOException {
        return this.a(httpServletRequest, httpServletResponse, (Void)object, bl2);
    }
}

