/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.html;

import com.inet.annotations.InternalApi;
import com.inet.report.renderer.doc.Adornment;
import com.inet.report.renderer.doc.CellAdornment;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class HtmlUtils {
    public static final int MIN_SECTION_HEIGHT_TWIPS = 15;
    public static final int NOT_DEFINED = -1;
    public static final int SINGLE_BORDER_WIDTH = 1;
    public static final int DOUBLE_BORDER_WIDTH = 3;
    static final byte[] aMM = "px".getBytes();
    public static final int HAIR_LINE_WIDTH_TWIPS = 15;
    public static final float HAIR_LINE_ALPHA = 0.3f;

    @Nonnull
    public static void correctLineStyles(boolean horizontal, @Nonnull Adornment adornment) {
        if (horizontal) {
            if (adornment.getTopStyle() == 0) {
                adornment.setTopStyle(adornment.getBottomStyle());
            }
            adornment.setLeftStyle(0);
        } else {
            if (adornment.getLeftStyle() == 0) {
                adornment.setLeftStyle(adornment.getRightStyle());
            }
            adornment.setTopStyle(0);
        }
        adornment.setRightStyle(0);
        adornment.setBottomStyle(0);
    }

    @Nonnull
    public static Adornment correctBoxRoundingIfNecessary(int width, int height, boolean mso, @Nonnull Adornment adornment) {
        if (!mso) {
            boolean bl2 = false;
            int n2 = adornment.getRoundingWidth();
            int n3 = adornment.getRoundingHeight();
            if (n2 != 0 && n2 > width) {
                n2 = width;
                bl2 = true;
            }
            if (n3 != 0 && n3 > height) {
                n3 = height;
                bl2 = true;
            }
            if (bl2) {
                return adornment.createAdornmentwithModifiedRounding(n2, n3);
            }
        }
        return adornment;
    }

    public static int getBorderWidth(int lineWidth, int lineStyle) {
        switch (lineStyle) {
            case 1: 
            case 3: 
            case 4: {
                return lineWidth < 15 ? 15 : lineWidth;
            }
            case 2: {
                lineWidth = lineWidth < 15 ? 15 : lineWidth;
                return lineWidth * 3;
            }
        }
        return 0;
    }

    public static int round(int valueInTwips) {
        return Math.round((float)valueInTwips / 15.0f) * 15;
    }

    public static int twipsToPixel(int valueInTwips) {
        return Math.round((float)valueInTwips / 15.0f);
    }

    public static int[] twipsToPixel(int[] twips) {
        int n2 = twips.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = HtmlUtils.twipsToPixel(twips[i2]);
        }
        return nArray;
    }

    @Nonnull
    public static CellAdornment adjustCellBorders(@Nonnull CellAdornment cellAdornment, boolean lastCol, boolean lastRow, boolean roundCellBorders) {
        boolean bl2 = false;
        int n2 = cellAdornment.getRightStyle();
        int n3 = cellAdornment.getBottomStyle();
        int n4 = cellAdornment.getLeftLineWidth();
        int n5 = cellAdornment.getRightLineWidth();
        int n6 = cellAdornment.getTopLineWidth();
        int n7 = cellAdornment.getBottomLineWidth();
        if (roundCellBorders) {
            if (cellAdornment.getLeftStyle() != 0) {
                n4 = HtmlUtils.round(n4);
                bl2 = true;
            }
            if (cellAdornment.getTopStyle() != 0) {
                n6 = HtmlUtils.round(n6);
                bl2 = true;
            }
        }
        if (n3 != 0) {
            if (!lastRow) {
                n3 = 0;
                bl2 = true;
            } else if (roundCellBorders) {
                n7 = HtmlUtils.round(n7);
                bl2 = true;
            }
        }
        if (n2 != 0) {
            if (!lastCol) {
                n2 = 0;
                bl2 = true;
            } else if (roundCellBorders) {
                n5 = HtmlUtils.round(n5);
                bl2 = true;
            }
        }
        if (bl2) {
            cellAdornment = new CellAdornment(cellAdornment.getTopStyle(), cellAdornment.getLeftStyle(), n3, n2, n6, n4, n7, n5, cellAdornment.getTopBorderColor(), cellAdornment.getLeftBorderColor(), cellAdornment.getBottomBorderColor(), cellAdornment.getRightBorderColor(), cellAdornment.getBackColor());
        }
        return cellAdornment;
    }

    @Nonnull
    public static Rectangle calcPositionAndSizeOfTextBoxInsideCell(int cellWidth, int cellHeight, @Nullable Insets insets, @Nullable CellAdornment cellAdornment, boolean lastCol, boolean lastRow, boolean roundInsets) {
        int n2;
        int n3 = insets != null ? insets.left : 0;
        int n4 = insets != null ? insets.top : 0;
        int n5 = insets != null ? insets.bottom : 0;
        int n6 = n2 = insets != null ? insets.right : 0;
        if (insets != null && roundInsets) {
            n3 = HtmlUtils.round(n3);
            n4 = HtmlUtils.round(n4);
            n5 = HtmlUtils.round(n5);
            n2 = HtmlUtils.round(n2);
        }
        int n7 = 0;
        int n8 = 0;
        if (cellAdornment != null) {
            n7 = HtmlUtils.aT(cellAdornment.getTopStyle(), cellAdornment.getTopLineWidth());
            n8 = HtmlUtils.aT(cellAdornment.getLeftStyle(), cellAdornment.getLeftLineWidth());
        }
        int n9 = cellHeight - n4 - n5;
        int n10 = cellWidth - n3 - n2;
        int n11 = n3 - n8;
        int n12 = n4 - n7;
        if (cellAdornment != null) {
            if (lastCol) {
                n10 -= HtmlUtils.aT(cellAdornment.getRightStyle(), cellAdornment.getRightLineWidth());
            }
            if (lastRow) {
                n9 -= HtmlUtils.aT(cellAdornment.getBottomStyle(), cellAdornment.getBottomLineWidth());
            }
        }
        if (n10 < 0) {
            n10 = 0;
        }
        if (n9 < 0) {
            n9 = 0;
        }
        return new Rectangle(n11, n12, n10, n9);
    }

    static int aT(int n2, int n3) {
        switch (n2) {
            case 2: {
                n3 *= 3;
                break;
            }
            case 0: {
                n3 = 0;
            }
        }
        return n3;
    }

    public static void setPaddingIfNotZero(@Nonnull Adornment adornment, int paddingLeft, int paddingTop, int paddingRight, int paddingBottom) {
        if (paddingLeft != 0) {
            adornment.setLeftPadding(paddingLeft);
        }
        if (paddingTop != 0) {
            adornment.setTopPadding(paddingTop);
        }
        if (paddingRight != 0) {
            adornment.setRightPadding(paddingRight);
        }
        if (paddingBottom != 0) {
            adornment.setBottomPadding(paddingBottom);
        }
    }
}

