/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.pool;

import com.inet.annotations.InternalApi;
import com.inet.classloader.LoaderUtils;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.util.StringFunctions;
import com.inet.logging.LogManager;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.pool.ConnectionPool;
import com.inet.report.pool.PoolConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;

@InternalApi
public class InternalConnectionPool
implements ConnectionPool {
    private static Vector<Thread> awZ = new Vector();
    private ConcurrentHashMap<DataSource, CopyOnWriteArrayList<PoolEntry>> axa = new ConcurrentHashMap();
    private Hashtable<String, Driver> axb = new Hashtable();
    private long axc = 600000L;
    private int axd = 0;
    private long axe = 10000L;
    private final Object axf = new Object();
    private a axg = new a();

    public InternalConnectionPool() {
        ConfigValue<Integer> configValue = new ConfigValue<Integer>(ConfigKey.MAX_CONNECTIONS){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                int n2 = (Integer)this.get();
                if (n2 < 0) {
                    LogManager.getConfigLogger().error((Throwable)new IllegalArgumentException("[Pool Manager] Negative maximum connection count value"));
                }
                InternalConnectionPool.this.axd = n2;
            }
        };
        ConfigValue<Double> configValue2 = new ConfigValue<Double>(ConfigKey.CONNECTION_POOL_TIMEOUT){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                long l2 = (long)((Double)this.get() * 60000.0);
                if (l2 < 0L) {
                    LogManager.getConfigLogger().error((Throwable)new IllegalArgumentException("[Pool Manager] Negative timeout value"));
                    return;
                }
                long l3 = InternalConnectionPool.this.axc;
                InternalConnectionPool.this.axc = l2;
                if (l3 == 0L && InternalConnectionPool.this.axc != 0L) {
                    InternalConnectionPool.this.axg = new a();
                }
            }
        };
        ConfigValue<Integer> configValue3 = new ConfigValue<Integer>(ConfigKey.LOGIN_TIMEOUT){

            protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
                super.setValue(strValue);
                long l2 = (Integer)this.get() * 1000;
                if (l2 < 0L) {
                    LogManager.getConfigLogger().error((Throwable)new IllegalArgumentException("[Pool Manager] Negative login timeout value"));
                    return;
                }
                InternalConnectionPool.this.axe = l2;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PoolConnection getConnection(String driverClassName, String connectionUrl, Properties properties) throws SQLException, ReportException {
        Object object;
        Driver driver;
        CopyOnWriteArrayList<PoolEntry> copyOnWriteArrayList;
        block31: {
            copyOnWriteArrayList = null;
            try {
                if (StringFunctions.isEmpty((String)driverClassName)) {
                    driver = DriverManager.getDriver(connectionUrl);
                    driverClassName = driver.getClass().getName();
                    break block31;
                }
                object = this;
                synchronized (object) {
                    driver = this.axb.get(driverClassName);
                    if (driver == null) {
                        try {
                            driver = (Driver)LoaderUtils.classForName((String)driverClassName, (Object)this).newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            if (driverClassName.equals("sun.jdbc.odbc.JdbcOdbcDriver")) {
                                if (BaseUtils.isDebug()) {
                                    BaseUtils.debug(classNotFoundException);
                                }
                                driver = (Driver)LoaderUtils.classForName((String)"com.inet.odbc.OdbcDriver", (Object)this).newInstance();
                            }
                            throw classNotFoundException;
                        }
                        this.axb.put(driverClassName, driver);
                    }
                }
            }
            catch (Exception exception) {
                Object[] objectArray = new Object[]{driverClassName};
                throw ReportExceptionFactory.createReportExceptionWithCause(exception, ReportErrorCode.PM_CannotLoadDriver, objectArray);
            }
        }
        DataSource dataSource = new DataSource(driverClassName, connectionUrl, properties);
        object = this;
        synchronized (object) {
            copyOnWriteArrayList = this.axa.get(dataSource);
            if (copyOnWriteArrayList == null) {
                copyOnWriteArrayList = new CopyOnWriteArrayList();
                this.axa.put(dataSource, copyOnWriteArrayList);
            }
        }
        PoolConnection poolConnection = this.a(copyOnWriteArrayList);
        if (poolConnection != null) {
            return poolConnection;
        }
        object = new PoolEntry();
        if (this.axd != 0) {
            int n2;
            CopyOnWriteArrayList<PoolEntry> copyOnWriteArrayList2 = copyOnWriteArrayList;
            synchronized (copyOnWriteArrayList2) {
                n2 = copyOnWriteArrayList.size();
            }
            if (this.axd <= n2) {
                long l2 = System.currentTimeMillis();
                long l3 = 0L;
                Object object2 = this.axf;
                synchronized (object2) {
                    while ((l3 < this.axe || this.axe == 0L) && this.axd != 0 && this.axd <= copyOnWriteArrayList.size()) {
                        try {
                            this.axf.wait(this.axe == 0L ? 0L : this.axe - l3);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        poolConnection = this.a(copyOnWriteArrayList);
                        if (poolConnection != null) {
                            return poolConnection;
                        }
                        l3 = System.currentTimeMillis() - l2;
                    }
                }
            }
            if (this.axd != 0 && this.axd <= copyOnWriteArrayList.size()) {
                Object[] objectArray = new Object[]{this.axe / 1000L + " s.", new Integer(this.axd)};
                throw ReportExceptionFactory.createReportException(ReportErrorCode.PM_LoginTimeout, objectArray);
            }
        }
        try {
            copyOnWriteArrayList.add((PoolEntry)object);
            return ((PoolEntry)object).a(dataSource, driver);
        }
        catch (SQLException sQLException) {
            ((PoolEntry)object).a(sQLException);
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PoolConnection a(CopyOnWriteArrayList<PoolEntry> copyOnWriteArrayList) throws SQLException {
        Connection connection = null;
        for (int i2 = 0; i2 < copyOnWriteArrayList.size(); ++i2) {
            boolean bl2;
            PoolEntry poolEntry = copyOnWriteArrayList.get(i2);
            if (poolEntry.axk) continue;
            InternalConnectionPool internalConnectionPool = this;
            synchronized (internalConnectionPool) {
                if (poolEntry.axk) {
                    continue;
                }
                if (poolEntry.axm != null && poolEntry.axl + 30000L > System.currentTimeMillis()) {
                    throw poolEntry.axm;
                }
                poolEntry.axk = true;
                poolEntry.axl = System.currentTimeMillis();
            }
            if (poolEntry.axj == null) {
                copyOnWriteArrayList.remove(poolEntry);
                continue;
            }
            connection = poolEntry.axj;
            try {
                bl2 = poolEntry.axi.booleanValue() ? !connection.isValid(5) : connection.isClosed();
            }
            catch (Throwable throwable) {
                bl2 = true;
            }
            if (bl2) {
                try {
                    poolEntry.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                copyOnWriteArrayList.remove(poolEntry);
                connection = null;
                continue;
            }
            return new PoolConnection(connection, poolEntry);
        }
        return null;
    }

    public synchronized HashMap<DataSource, List<PoolEntry>> getPoolDS() {
        return new HashMap<DataSource, List<PoolEntry>>(this.axa);
    }

    @Override
    public synchronized void shutdown() {
        for (Thread thread : awZ) {
            if (thread == null) continue;
            thread.interrupt();
        }
    }

    private class a
    implements Runnable {
        private a() {
            Thread thread = new Thread((Runnable)this, "PoolManager");
            try {
                thread.setPriority(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                thread.setDaemon(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            thread.start();
            awZ.add(thread);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PoolEntry poolEntry;
            int n2;
            while (InternalConnectionPool.this.axc > 0L) {
                Iterator<CopyOnWriteArrayList<PoolEntry>> iterator = InternalConnectionPool.this.axa.values().iterator();
                while (iterator.hasNext()) {
                    CopyOnWriteArrayList<PoolEntry> copyOnWriteArrayList = iterator.next();
                    for (n2 = 0; n2 < copyOnWriteArrayList.size(); ++n2) {
                        poolEntry = copyOnWriteArrayList.get(n2);
                        if (poolEntry.axk || InternalConnectionPool.this.axc <= 0L || poolEntry.axl + InternalConnectionPool.this.axc >= System.currentTimeMillis()) continue;
                        boolean bl2 = false;
                        InternalConnectionPool internalConnectionPool = InternalConnectionPool.this;
                        synchronized (internalConnectionPool) {
                            if (!poolEntry.axk && InternalConnectionPool.this.axc > 0L && poolEntry.axl + InternalConnectionPool.this.axc < System.currentTimeMillis()) {
                                bl2 = copyOnWriteArrayList.remove(poolEntry);
                            }
                            if (copyOnWriteArrayList.size() == 0) {
                                iterator.remove();
                            }
                        }
                        if (!bl2) continue;
                        poolEntry.close();
                    }
                }
                try {
                    long l2 = InternalConnectionPool.this.axc / 10L;
                    Thread.sleep(l2);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            if (InternalConnectionPool.this.axc > 0L) {
                for (CopyOnWriteArrayList<PoolEntry> copyOnWriteArrayList : InternalConnectionPool.this.axa.values()) {
                    for (n2 = 0; n2 < copyOnWriteArrayList.size(); ++n2) {
                        poolEntry = copyOnWriteArrayList.get(n2);
                        poolEntry.close();
                    }
                }
            }
        }
    }

    @InternalApi
    public class DataSource {
        private String aab;
        private String url;
        private Properties UP;
        private Boolean axi;

        DataSource(String driver, String url, Properties props) throws ReportException {
            if (driver == null) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.PM_PropertyError, "\"driver\"");
            }
            if (url == null) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.PM_PropertyError, "\"url\"");
            }
            this.aab = driver;
            this.url = url;
            this.UP = props;
        }

        public boolean equals(Object ds) {
            return ((DataSource)ds).aab.equals(this.aab) && ((DataSource)ds).url.equals(this.url) && ((DataSource)ds).UP.equals(this.UP);
        }

        public int hashCode() {
            return this.aab.hashCode() ^ this.url.hashCode();
        }

        public String getDriver() {
            return this.aab;
        }

        public String getUrl() {
            return this.url;
        }

        public Properties getProperties() {
            return this.UP;
        }
    }

    public class PoolEntry {
        private Connection axj;
        private boolean axk = true;
        private long axl = System.currentTimeMillis();
        private SQLException axm;
        private Boolean axi;

        PoolConnection a(DataSource dataSource, Driver driver) throws SQLException, ReportException {
            this.axj = driver.connect(dataSource.url, (Properties)dataSource.UP.clone());
            if (this.axj == null) {
                this.axk = false;
                throw ReportExceptionFactory.createReportException(ReportErrorCode.PM_InvalidDrvUrl, dataSource.url, driver.toString());
            }
            this.axi = dataSource.axi;
            if (this.axi == null) {
                try {
                    this.axj.isValid(5);
                    this.axi = true;
                }
                catch (Throwable throwable) {
                    this.axi = false;
                }
                dataSource.axi = this.axi;
            }
            return new PoolConnection(this.axj, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            try {
                this.axj.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.axj = null;
            this.axk = false;
            Object object = InternalConnectionPool.this.axf;
            synchronized (object) {
                InternalConnectionPool.this.axf.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void connectionClosed() {
            this.axk = false;
            this.axl = System.currentTimeMillis();
            Object object = InternalConnectionPool.this.axf;
            synchronized (object) {
                InternalConnectionPool.this.axf.notify();
            }
        }

        public boolean isUsing() {
            return this.axk;
        }

        void a(SQLException sQLException) {
            this.axm = sQLException;
            this.axk = false;
            this.axl = System.currentTimeMillis();
        }
    }
}

