/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.Engine;
import com.inet.report.EngineStatistics;
import com.inet.report.Fields;
import com.inet.report.PromptField;
import com.inet.report.PromptRequestWarning;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.ReportGenerator;
import com.inet.report.ReportProperties;
import com.inet.report.af;
import com.inet.report.bi;
import com.inet.report.formula.o;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.output.DocumentOutput;
import com.inet.report.prompt.Prompt;
import com.inet.report.renderer.base.j;
import com.inet.report.renderer.doc.controller.au;
import com.inet.report.renderer.doc.controller.k;
import com.inet.report.util.EngineUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;

@PublicApi
public class EngineBundle
implements ReportGenerator {
    private final ArrayList<Engine> oE = new ArrayList();
    private final String format;
    private k oF;
    private o oG;
    private DocumentOutput oH;
    private static String[] oI = new String[]{"java", "htm", "html", "htm.zip", "pdf", "ps", "txt", "rtf", "png", "jpeg", "jpg", "gif", "bmp", "xlsx", "ods"};

    public EngineBundle(String format) throws ReportException {
        if (format == null) {
            format = "java";
        }
        this.format = format;
        if (!Arrays.asList(oI).contains(format)) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidOutFmt, format);
        }
    }

    public Engine addReportFile(String reportUrl) throws ReportException {
        Serializable serializable;
        Engine engine;
        if (this.oF == null) {
            engine = new Engine(this.format);
            if (!(engine.bB instanceof au)) {
                throw ReportExceptionFactory.createReportException(ReportErrorCode.InvalidOutFmt, this.format);
            }
            serializable = (au)engine.bB;
            this.oF = ((au)serializable).zQ();
            this.oG = ((bi)serializable).oG;
        } else {
            engine = new Engine(this.oF, this.oG);
        }
        engine.setReportFile(reportUrl);
        if (this.oE.size() == 0) {
            serializable = engine.getReportProperties();
            String[] stringArray = ((ReportProperties)serializable).getEnabledFormats();
            if (stringArray == null) {
                ((ReportProperties)serializable).setEnabledFormats(oI);
            } else {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.addAll(Arrays.asList(stringArray));
                arrayList.retainAll(Arrays.asList(oI));
                ((ReportProperties)serializable).setEnabledFormats(arrayList.toArray(new String[arrayList.size()]));
            }
        }
        this.oE.add(engine);
        return engine;
    }

    @Override
    public void setDocumentOutput(DocumentOutput documentOutput) {
        this.oH = documentOutput;
    }

    private void cF() throws PromptRequestWarning, ReportException {
        try {
            for (Engine engine : this.oE) {
                EngineUtils.checkPrompts(engine, false);
            }
        }
        catch (PromptRequestWarning promptRequestWarning) {
            throw new PromptRequestWarning("NeedPrompts", -601, this.cG());
        }
    }

    @Nonnull
    Prompt[] cG() {
        LinkedHashMap<String, Prompt> linkedHashMap = new LinkedHashMap<String, Prompt>();
        for (Engine engine : this.oE) {
            Prompt[] promptArray;
            for (Prompt prompt : promptArray = af.createSerializablePrompts(engine)) {
                linkedHashMap.put(prompt.getName(), prompt);
            }
        }
        return linkedHashMap.values().toArray(new Prompt[linkedHashMap.size()]);
    }

    @Override
    public void execute() throws ReportException {
        this.cF();
        int n2 = 0;
        for (int i2 = 0; i2 < this.oE.size(); ++i2) {
            Engine engine = this.oE.get(i2);
            engine.nQ = this.oH;
            au au2 = (au)engine.bB;
            au2.j(i2 == 0, i2 == this.oE.size() - 1);
            au2.IY = -n2;
            engine.execute();
            n2 += engine.getDocumentPageCount();
            this.oH = engine.nQ;
        }
    }

    public Engine getEngine0() throws ReportException {
        if (this.oE.size() == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.NoRptFile, new Object[0]);
        }
        return this.oE.get(0);
    }

    public List<Engine> getEngines() {
        return Collections.unmodifiableList(this.oE);
    }

    @Override
    public int getPageCount() throws ReportException {
        return this.getEngine0().getPageCount();
    }

    @Override
    public byte[] getPageData(int page) throws ReportException {
        return this.getEngine0().getPageData(page);
    }

    @Override
    public void stop(String message) {
        for (Engine engine : this.oE) {
            engine.stop(message);
        }
    }

    @Override
    @Nonnull
    public EngineStatistics getStatistics() {
        if (this.oE.size() == 0) {
            return new j();
        }
        return this.oE.get(0).getStatistics();
    }

    @Override
    public void setUserProperties(Properties props) throws ReportException {
        for (Engine engine : this.oE) {
            engine.setUserProperties(props);
        }
    }

    @Override
    public void setClientLocale(@Nonnull Locale locale) throws ReportException {
        for (Engine engine : this.oE) {
            engine.setClientLocale(locale);
        }
    }

    @Override
    public void stopAfterPage(int maxPageNo) {
        for (Engine engine : this.oE) {
            engine.stopAfterPage(maxPageNo);
        }
    }

    @Override
    public void setPrompt(String name, String prompt) throws ReportException {
        for (Engine engine : this.oE) {
            engine.setPrompt(name, prompt);
        }
    }

    @Override
    public PromptField getPromptField(String name) throws ReportException {
        for (Engine engine : this.oE) {
            PromptField promptField = engine.getPromptField(name);
            if (promptField == null) continue;
            return promptField;
        }
        return null;
    }

    @Override
    public void setPrompt(String prompt, int i2) throws ReportException {
        int n2 = 0;
        for (Engine engine : this.oE) {
            Fields fields = engine.getFields();
            int n3 = i2 - n2;
            if (fields.getPromptFieldsCount() > n3) {
                engine.setPrompt(prompt, n3);
                return;
            }
            n2 += fields.getPromptFieldsCount();
        }
    }
}

