/**
 * RemoteGUI directive to insert an export format list
 * including a popup dialog to make settings and have an export progress
 * 
 * 
 * Usage:
 * 
 *    clearreportsApp.run([ '$ocLazyLoad', function ( $ocLazyLoad ) {
 *        
 *        var loadingRunFunction = function() {
 *            console.log( "loadingRunFunction" );
 *            // add the template to your page
 *            // <report-export-dropdown report="model.report" export-options="model.exportOptionsResolver(format)"></report-export-dropdown>
 *        };
 *        
 *        $ocLazyLoad.load( {
 *            files: [ 'weblib/report.export.js' ]
 *         } ).then(loadingRunFunction);
 *        
 *    }]); 
 */
//*
(function(){
    
    angular.module(clearreportsApp.name).directive('reportExportDropdown', ['dataservice', 'reportExportDialog', function(dataservice, reportExportDialog) {
        
        var html = '<div class="dropdown">' +
            '<button type="button" class="btn btn-plain btn-withcaret" dropdown><i class="icon-none export"></i></button>' +
            '<ul class="dropdown-menu dropdown-menu-right">' +
            '<li ng-repeat="format in availableExportFormats | filter:filterForAsync track by $index" ng-class="{\'dropdown-header\':format.key==\'\'}">' +
            '<a ng-if="format.key.length" href="" ng-click="export(format)" ng-attr-title="{{format.label}}">' +
            '<i ng-class="\'svgicon-\'+format.key.replace(\'.\',\'-\')+\'_16\'"></i>' +
            '<span>{{format.label}}</span>' + 
            '<span class="small text-muted ng-binding">{{format.key}}</span>' + 
            '</a>' +
            '<label ng-if="!format.key.length">{{format.label}}</label>' +
            '</li></ul>'+
            '</div>'
            
        var linking = function(scope, _element) {

            scope.availableExportFormats = [];
            
            scope.filterForAsync = function( format ) {
                if ( scope.allowsAsyncOnly !== false ) {
                    return format.asyncWithProgress;
                }
                
                return true;
            };

            scope.export = function( format ) {
                let options = {
                    format: format.key,
                    formatDisplayName: format.label,
                    asyncWithProgress: format.asyncWithProgress,
                    exportHandlerKey: 'reportexportaction',
                    availableFileChooserProtocols: scope.fileChooserProtocols,
                    reportDataProvider: function() {
                        return Object.assign({
                            report: scope.report
                        }, scope.reportDataProvider( { format: format } ) );
                    }
                };

                reportExportDialog.showExportDialog( Object.assign( options, scope.exportOptions || {} ) );
            };
            
            scope.$watch( 'report', function( report ) {
                dataservice.execute('reportexportformats', {
                    data: angular.toJson({
                        report: report,
                    }),
                    handleSuccess: function(response) {
                        scope.availableExportFormats = response.enabledFormats;
/*  
                        // Test-value for async                      
                        scope.availableExportFormats.push({
                            key: "bla",
                            label: "blubs",
                            asyncWithProgress: false
                        });
//*/
                    }, 
                });
            } );
        };

        return {
            restrict: 'E',
            replace: true,
            link: linking,
            template: html,
            scope: {
                "report": "=",
                "fileChooserProtocols": "=?",
                "reportDataProvider": "&",
                "exportOptions": "=",
                "allowsAsyncOnly": "=?",
            }
        };
    }]);
})();
//*/