/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.JsonData;
import com.inet.annotations.PublicApi;
import com.inet.viewer.PromptValue;
import com.inet.viewer.Range;
import com.inet.viewer.SinglePromptValue;

@JsonData
@PublicApi
public class RangePromptValue
extends PromptValue {
    private static final long serialVersionUID = 92387615822531L;
    private Range range;

    RangePromptValue(int type) {
        super(type);
        this.range = new Range(null, null, false, false);
        this.initValue();
    }

    RangePromptValue(SinglePromptValue startValue, SinglePromptValue endValue, boolean includeLow, boolean includeHigh, int type) {
        super("", type);
        this.range = new Range(startValue, endValue, includeLow, includeHigh);
    }

    public RangePromptValue(Range range, int type) {
        super("", type);
        this.range = range;
    }

    public final boolean isIncludeHigh() {
        return this.range.isIncludeUpper();
    }

    public final void setIncludeHigh(boolean includeHigh) {
        this.range.setIncludeUpper(includeHigh);
    }

    public final boolean isIncludeLow() {
        return this.range.isIncludeLower();
    }

    public final void setIncludeLow(boolean includeLow) {
        this.range.setIncludeLower(includeLow);
    }

    public SinglePromptValue getEndValue() {
        return (SinglePromptValue)this.range.getUpperValue();
    }

    public void setEndValue(SinglePromptValue endValue) {
        this.range.setUpperValue(endValue);
    }

    public SinglePromptValue getStartValue() {
        return (SinglePromptValue)this.range.getLowerValue();
    }

    public void setStartValue(SinglePromptValue startValue) {
        this.range.setLowerValue(startValue);
    }

    @Override
    void initValue() {
        if (this.range != null) {
            this.range.setLowerValue(new SinglePromptValue(this.getType()));
            this.range.setUpperValue(new SinglePromptValue(this.getType()));
        }
    }

    @Override
    public Object getValue() {
        return this;
    }

    @Override
    String getValueString() {
        Object object = this.range.getLowerValue().toString();
        object = (String)object + " ";
        if (!this.isIncludeLow()) {
            object = (String)object + "_";
        }
        object = (String)object + "to";
        if (!this.isIncludeHigh()) {
            object = (String)object + "_";
        }
        object = (String)object + " ";
        object = (String)object + this.range.getUpperValue().toString();
        return object;
    }

    @Override
    public String getStringRepresentation() {
        if (this.getStartValue().getValue() == null && this.getEndValue().getValue() == null) {
            return "null";
        }
        return this.getStartValue().getStringRepresentation() + " " + (this.isIncludeLow() ? "" : "_") + "to" + (this.isIncludeHigh() ? "" : "_") + " " + this.getEndValue().getStringRepresentation();
    }

    @Override
    public Object getSQLTypedValue() {
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RangePromptValue) {
            RangePromptValue rangePromptValue = (RangePromptValue)obj;
            return rangePromptValue.isIncludeHigh() == this.isIncludeHigh() && rangePromptValue.isIncludeLow() == this.isIncludeLow() && rangePromptValue.getEndValue().equals(this.getEndValue()) && rangePromptValue.getStartValue().equals(this.getStartValue()) && rangePromptValue.getDescription().equals(this.getDescription()) && rangePromptValue.isOnlyDescription() == this.isOnlyDescription();
        }
        return false;
    }

    public int hashCode() {
        String string = this.getDescription() + this.isOnlyDescription() + String.valueOf(this.getStartValue()) + String.valueOf(this.getEndValue()) + this.isIncludeLow() + this.isIncludeHigh();
        return string.hashCode();
    }
}

