/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ReportView;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

@PublicApi
public abstract class Progress
implements Runnable {
    public static final int TYPE_PAGELOADER = 0;
    public static final int TYPE_PRINT = 1;
    public static final int TYPE_EXPORT = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int TYPE_INVISIBLE = 4;
    public static final int STATUS_NOT_INITIALIZED = -1;
    public static final int STATUS_INITIALIZED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_COMPLETED = 2;
    public static final int STATUS_CANCELED = 3;
    public static final int STATUS_ERROR = 4;
    public static final int STATUS_IDLE = 5;
    public static final String PROP_PROGRESS_STATUS = "ProgressStatus";
    public static final String PROP_PROGRESS_TOTAL = "ProgressTotal";
    public static final String PROP_PROGRESS_STEP = "ProgressStep";
    public static final String PROP_PROGRESS_INDETERMINATE = "ProgressIndeterminate";
    private int bxj = -1;
    protected final PropertyChangeSupport bCq = new PropertyChangeSupport(this);
    private int type;
    private int bCr;
    private int progress;
    private boolean bCs = false;
    private String afO;
    private ReportView bCt;
    private ViewerContext byJ;
    private Component bAK;
    Thread bCu;

    public Progress(ReportView reportView, int type) {
        this.type = type;
        this.bCt = reportView;
        if (reportView != null) {
            reportView.getReportViewer().getProgressPool().a(this);
            this.bAK = reportView.getComponent();
            this.byJ = reportView.getReportViewer().getViewerContext();
        }
        this.setStatus(0);
    }

    public Progress(Component parent, ViewerContext viewerContext, int type) {
        this.type = type;
        this.byJ = viewerContext;
        this.bAK = parent;
        this.setStatus(0);
    }

    public final void startProgress() {
        if (this.bCu != null && this.bCu.isAlive()) {
            throw new ViewerException("Progress '" + this.getName() + "' is already running");
        }
        this.bCu = new Thread((Runnable)this, this.getName());
        this.bCu.setPriority(5);
        this.setStatus(1);
        this.setErrorMessage(null);
        if (this.bCs) {
            this.bCu.setDaemon(true);
            this.setTotalProgress(1);
        }
        this.bCu.start();
    }

    public abstract String getName();

    public abstract void cancel();

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        try {
            Progress progress = this;
            synchronized (progress) {
                while (!this.isFinished()) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean isIndeterminate() {
        return this.bCs;
    }

    public void setIndeterminate(boolean indeterminate) {
        boolean bl2 = this.bCs;
        this.bCs = indeterminate;
        this.bCq.firePropertyChange(PROP_PROGRESS_INDETERMINATE, bl2, indeterminate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        int n2 = this.bxj;
        this.bxj = status;
        this.bCq.firePropertyChange(PROP_PROGRESS_STATUS, n2, this.bxj);
        Progress progress = this;
        synchronized (progress) {
            this.notifyAll();
        }
    }

    public boolean isFinished() {
        boolean bl2 = this.bxj == 3 || this.bxj == 2 || this.bxj == 4;
        return bl2;
    }

    public boolean isCanceled() {
        return this.bxj == 3;
    }

    public boolean isErrored() {
        return this.bxj == 4;
    }

    public void setTotalProgress(int total) {
        int n2 = this.bCr;
        this.bCr = total;
        if (total == 0) {
            this.setStatus(5);
        } else if (this.getStatus() == 5) {
            this.setStatus(1);
        }
        this.bCq.firePropertyChange(PROP_PROGRESS_TOTAL, n2, total);
    }

    public int getTotalProgress() {
        return this.bCr;
    }

    public void setProgress(int step) {
        int n2 = this.progress;
        this.progress = step;
        this.bCq.firePropertyChange(PROP_PROGRESS_STEP, n2, this.progress);
    }

    public int getProgress() {
        return this.progress;
    }

    public ReportView getReportView() {
        return this.bCt;
    }

    public int getStatus() {
        return this.bxj;
    }

    public String getErrorMessage() {
        return this.afO;
    }

    public void setErrorMessage(String msg) {
        this.afO = msg;
    }

    public void showError(Throwable th) {
        this.setErrorMessage(th.getMessage());
        this.setStatus(4);
        if (this.byJ == null) {
            ViewerUtils.printStackTrace(th);
        } else {
            this.byJ.showError(th, this.bAK);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l2) {
        this.bCq.addPropertyChangeListener(l2);
    }

    public void removePropertyChangeListener(PropertyChangeListener l2) {
        this.bCq.removePropertyChangeListener(l2);
    }

    protected void Pj() {
        PropertyChangeListener[] propertyChangeListenerArray = this.bCq.getPropertyChangeListeners();
        for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
            this.bCq.removePropertyChangeListener(propertyChangeListenerArray[i2]);
        }
    }
}

