/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.util;

import com.inet.classloader.I18nMessages;
import com.inet.file.CombinedFileDescription;
import com.inet.file.FileCombiner;
import com.inet.lib.util.IOFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import com.inet.report.PropertiesChecker;
import com.inet.report.ReportException;
import com.inet.report.cache.Cache;
import com.inet.report.renderer.html.HtmlDocumentWriter;
import com.inet.report.renderer.html.viewer.HTMLViewer;
import com.inet.report.renderer.html.viewer.HTMLViewerScriptResource;
import com.inet.report.util.WebUtils;
import com.inet.report.util.theme.a;
import com.inet.report.util.theme.b;
import com.inet.shared.servlet.ServletUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Properties;

public class RenderDataUtils {
    private static String bxQ;
    private static long bxR;
    private static final I18nMessages bxS;
    private static final URL[] bxT;
    private static FileCombiner bxU;
    private static FileCombiner bxV;

    public static synchronized FileCombiner getFileCombinerTheme() {
        if (bxU == null) {
            bxU = new FileCombiner("htmlviewer.styles.css");
        }
        return bxU;
    }

    public static synchronized FileCombiner getFileCombinerScripts() {
        if (bxV == null) {
            bxV = new FileCombiner("htmlviewer.js", ServerPluginManager.getInstance().get(HTMLViewerScriptResource.class));
        }
        return bxV;
    }

    public static void writeFileData(OutputStream out, String name, byte[] data) throws IOException {
        byte[] byArray = BaseUtils.getBytesUTF8(name);
        out.write(RenderDataUtils.intToByteArray(byArray.length));
        out.write(byArray);
        out.write(RenderDataUtils.intToByteArray(data.length));
        out.write(data);
    }

    public static byte[] getHtmlViewerData() throws IOException {
        return RenderDataUtils.getHtmlViewerData(null, null);
    }

    public static void registerViewerScriptExtensions(ServerPluginManager spm) {
        HTMLViewerScriptResource hTMLViewerScriptResource = HTMLViewerScriptResource.fileDescription(0, bxT);
        hTMLViewerScriptResource.getCombinedFile().addMessages(bxS);
        spm.register(HTMLViewerScriptResource.class, (Object)hTMLViewerScriptResource);
        spm.register(CombinedFileDescription.class, (Object)new CombinedFileDescription("htmlviewer.styles.css", 100, "htmlviewerdefaulttheme.css", new FileCombiner.CombinedFile("text/css", new URL[]{HtmlDocumentWriter.class.getResource("viewer/css/corporatedesign.css")})));
    }

    public static byte[] getHtmlViewerData(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean bl2;
        String string;
        if (bxQ == null) {
            string = RenderDataUtils.getViewerResource("htmlviewer.js");
            String string2 = RenderDataUtils.getViewerResource("viewer/viewer.html");
            bxQ = string2 = string2.replace("$SCRIPT", string);
        }
        string = bxQ.replace("$CSS", RenderDataUtils.getViewerCSS(request, response));
        if (response != null && ServletUtils.checkLastModified((HttpServletRequest)request, (HttpServletResponse)response, (long)Math.max(bxR, (bl2 = ServerPluginManager.getInstance().isPluginLoaded("theme")) ? b.getLastModified() : 0L))) {
            return null;
        }
        return BaseUtils.getBytesUTF8(string.replace("$PROMPT", RenderDataUtils.getViewerPrompt(request)));
    }

    public static String getViewerPrompt(HttpServletRequest request) {
        Properties properties;
        Properties properties2 = properties = request != null ? WebUtils.b(request) : null;
        if (properties != null) {
            PropertiesChecker propertiesChecker = Cache.getPropertiesChecker();
            if (propertiesChecker != null) {
                try {
                    propertiesChecker.checkProperties(properties, request);
                }
                catch (ReportException reportException) {
                    BaseUtils.error(reportException);
                }
            }
            properties.remove("init");
            return "var PROMPT = " + WebUtils.o(properties);
        }
        return "var PROMPT = new Array();";
    }

    public static String getViewerCSS(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean bl2 = ServerPluginManager.getInstance().isPluginLoaded("theme");
        if (response != null && bl2) {
            return b.b(request, response);
        }
        return a.Oc();
    }

    public static String getViewerResource(String path) throws IOException, FileNotFoundException {
        FileCombiner.CombinedFile combinedFile = RenderDataUtils.getFileCombinerTheme().getCombinedFile(path);
        if (combinedFile != null) {
            bxR = Math.max(bxR, combinedFile.getLastModified());
            return BaseUtils.getStringUTF8(combinedFile.getData());
        }
        combinedFile = RenderDataUtils.getFileCombinerScripts().getCombinedFile(path);
        if (combinedFile != null) {
            bxR = Math.max(bxR, combinedFile.getLastModified());
            return BaseUtils.getStringUTF8(combinedFile.getData());
        }
        URL uRL = HtmlDocumentWriter.class.getResource(path);
        if (uRL == null) {
            throw new FileNotFoundException(path);
        }
        bxR = Math.max(bxR, uRL.openConnection().getLastModified());
        byte[] byArray = IOFunctions.getFileBuffer((URL)uRL);
        return BaseUtils.getStringUTF8(byArray);
    }

    public static long getLastModified() {
        return bxR;
    }

    public static byte[] intToByteArray(int i2) {
        byte[] byArray = new byte[4];
        byArray[3] = (byte)(i2 >> 24);
        byArray[2] = (byte)(i2 >> 16);
        byArray[1] = (byte)(i2 >> 8);
        byArray[0] = (byte)i2;
        return byArray;
    }

    static {
        bxS = new I18nMessages("com.inet.report.renderer.html.i18n.LanguageResources", RenderDataUtils.class);
        bxT = new URL[]{HTMLViewer.class.getResource("helper/events.js"), HTMLViewer.class.getResource("helper/prototype.array.js"), HTMLViewer.class.getResource("helper/prototype.element.js"), HTMLViewer.class.getResource("helper/prototype.string.js"), HTMLViewer.class.getResource("helper/functions.js"), HTMLViewer.class.getResource("helper/generator.js"), HTMLViewer.class.getResource("helper/jstorage.js"), HTMLViewer.class.getResource("modules/keylistener.js"), HTMLViewer.class.getResource("modules/print.js"), HTMLViewer.class.getResource("modules/search.js"), HTMLViewer.class.getResource("modules/export.js"), HTMLViewer.class.getResource("modules/grouptree.js"), HTMLViewer.class.getResource("modules/tabbar.js"), HTMLViewer.class.getResource("modules/menubar.js"), HTMLViewer.class.getResource("modules/popup.js"), HTMLViewer.class.getResource("modules/prompts.js"), HTMLViewer.class.getResource("modules/pagecount.js"), HTMLViewer.class.getResource("modules/serverping.js"), HTMLViewer.class.getResource("script.js")};
    }
}

