/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.i18n;

import com.inet.annotations.InternalApi;
import com.inet.classloader.I18nMessages;
import com.inet.report.ReportProperties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class PageFormat {
    private static final I18nMessages aqH = new I18nMessages("com.inet.report.i18n.paper.i18n.Papers", PageFormat.class);
    public static final PageFormat[] FORMATS = new PageFormat[]{new PageFormat(1, "Paper.Letter_8_1_2_x_11_in", 2, 1, Unit.UNIT_INCH), new PageFormat(2, "Paper.Letter_Small_8_1_2_x", 2, 2, Unit.UNIT_INCH), new PageFormat(3, "Paper.Tabloid_11_x_17_in", 2, 3, Unit.UNIT_INCH), new PageFormat(4, "Paper.Ledger_17_x_11_in", 2, 4, Unit.UNIT_INCH), new PageFormat(5, "Paper.Legal_8_1_2_x_14_in", 2, 5, Unit.UNIT_INCH), new PageFormat(6, "Paper.Statement_5_1_2_x_8_1", 2, 6, Unit.UNIT_INCH), new PageFormat(7, "Paper.Executive_7_1_4_x_10", 2, 7, Unit.UNIT_INCH), new PageFormat(8, "Paper.A3_297_x_420_mm", 1, 1, Unit.UNIT_MM), new PageFormat(9, "Paper.A4_210_x_297_mm", 1, 2, Unit.UNIT_MM), new PageFormat(10, "Paper.A4_Small_210_x_297_mm", 1, 3, Unit.UNIT_MM), new PageFormat(11, "Paper.A5_148_x_210_mm", 1, 4, Unit.UNIT_MM), new PageFormat(12, "Paper.B4_JIS_257_x_364_mm", 3, 1, Unit.UNIT_MM), new PageFormat(13, "Paper.B5_JIS_182_x_257_mm", 3, 2, Unit.UNIT_MM), new PageFormat(14, "Paper.Folio_8_1_2_x_13_in", 2, 9, Unit.UNIT_INCH), new PageFormat(15, "Paper.Quarto_215_x_275_mm", 2, 9, Unit.UNIT_MM), new PageFormat(16, "Paper.10_x_14_in", 6, 1, Unit.UNIT_INCH), new PageFormat(17, "Paper.11_x_17_in", 6, 2, Unit.UNIT_INCH), new PageFormat(18, "Paper.Note_8_1_2_x_11_in", 6, 3, Unit.UNIT_INCH), new PageFormat(19, "Paper.Envelope_9_3_7_8_x_8", 6, 4, Unit.UNIT_INCH), new PageFormat(20, "Paper.Envelope_10_4_1_8_x_9", 6, 5, Unit.UNIT_INCH), new PageFormat(21, "Paper.Envelope_11_4_1_2_x", 6, 6, Unit.UNIT_INCH), new PageFormat(22, "Paper.Envelope_12_4_3_4_x", 6, 7, Unit.UNIT_INCH), new PageFormat(23, "Paper.Envelope_14_5_x_11_1", 6, 8, Unit.UNIT_INCH), new PageFormat(24, "Paper.Csize_sheet_431_7_x", 6, 9, Unit.UNIT_POINT), new PageFormat(25, "Paper.Dsize_sheet_558_7_x", 6, 10, Unit.UNIT_POINT), new PageFormat(26, "Paper.Esize_sheet_863_4_x", 6, 11, Unit.UNIT_POINT), new PageFormat(27, "Paper.Envelope_DL_110_x_220", 6, 12, Unit.UNIT_MM), new PageFormat(28, "Paper.Envelope_C5_162_x_229", 1, 8, Unit.UNIT_MM), new PageFormat(29, "Paper.Envelope_C3_324_x_458", 1, 6, Unit.UNIT_MM), new PageFormat(30, "Paper.Envelope_C4_229_x_324", 1, 7, Unit.UNIT_MM), new PageFormat(31, "Paper.Envelope_C6_114_x_162", 1, 9, Unit.UNIT_MM), new PageFormat(32, "Paper.Envelope_C65_114_x", 1, 10, Unit.UNIT_MM), new PageFormat(33, "Paper.Envelope_B4_250_x_353", 1, 11, Unit.UNIT_MM), new PageFormat(34, "Paper.Envelope_B5_176_x_250", 1, 12, Unit.UNIT_MM), new PageFormat(35, "Paper.Envelope_B6_176_x_125", 1, 13, Unit.UNIT_MM), new PageFormat(36, "Paper.Envelope_110_x_230_mm", 6, 13, Unit.UNIT_MM), new PageFormat(37, "Paper.Envelope_Monarch_3_7", 2, 10, Unit.UNIT_INCH), new PageFormat(38, "Paper.63_4_Envelope_3_5_8_x", 6, 14, Unit.UNIT_INCH), new PageFormat(39, "Paper.US_Standard_Fanfold", 2, 11, Unit.UNIT_INCH), new PageFormat(40, "Paper.German_Standard", 4, 1, Unit.UNIT_INCH), new PageFormat(41, "Paper.German_Legal_Fanfold", 4, 2, Unit.UNIT_INCH), new PageFormat(42, "Paper.A2_420_x_594_mm", 1, 1, Unit.UNIT_MM), new PageFormat(119, "Paper.QVGA", 5, 1, Unit.UNIT_PIXEL), new PageFormat(120, "Paper.WQVGA400", 5, 2, Unit.UNIT_PIXEL), new PageFormat(121, "Paper.WQVGA432", 5, 3, Unit.UNIT_PIXEL), new PageFormat(122, "Paper.HVGA", 5, 4, Unit.UNIT_PIXEL), new PageFormat(123, "Paper.WVGA800", 5, 5, Unit.UNIT_PIXEL), new PageFormat(124, "Paper.WVGA854", 5, 6, Unit.UNIT_PIXEL), new PageFormat(125, "Paper.Retina", 5, 7, Unit.UNIT_PIXEL), new PageFormat(126, "Paper.XGA", 5, 8, Unit.UNIT_PIXEL), new PageFormat(127, "Paper.HDTV(720)", 5, 9, Unit.UNIT_PIXEL), new PageFormat(128, "Paper.HDTV(1080)", 5, 10, Unit.UNIT_PIXEL), new PageFormat(129, "Paper.photoPaper_100_x_150mm", 6, 15, Unit.UNIT_MM), new PageFormat(130, "Paper.photoPaper_101,6_x_152,4mm", 6, 16, Unit.UNIT_MM), new PageFormat(131, "Paper.A6", 1, 5, Unit.UNIT_MM), new PageFormat(132, "Paper.photoPaper_140_x_150mm", 6, 17, Unit.UNIT_MM), new PageFormat(256, "Paper.userdefined", 6, 9999, null)};
    public static final PageFormat LETTER = FORMATS[0];
    public static final PageFormat A4 = FORMATS[8];
    public static final PageFormat A5 = FORMATS[10];
    public static final PageFormat PHOTO_100X150 = FORMATS[52];
    public static final PageFormat PHOTO_101X152 = FORMATS[53];
    public static final PageFormat A6 = FORMATS[54];
    public static final PageFormat PHOTO_140X150 = FORMATS[55];
    public static final PageFormat A3 = FORMATS[7];
    private final int gz;
    private final String name;
    private final int aqI;
    private final int tc;
    private final Unit aqJ;

    private PageFormat(int id, String name, int groupNumber, int sortOrder, Unit unit) {
        this.gz = id;
        this.aqJ = unit;
        this.name = name;
        this.tc = groupNumber;
        this.aqI = sortOrder;
    }

    public int getWidth() {
        return ReportProperties.pageSizes[2 * (this.gz - 1)];
    }

    public int getHeight() {
        return ReportProperties.pageSizes[2 * (this.gz - 1) + 1];
    }

    public int getId() {
        return this.gz;
    }

    @Nonnull
    public String getName() {
        return aqH.getMsg(this.name, new Object[0]);
    }

    public int getSortOrder() {
        return this.aqI;
    }

    public int getGroupNumber() {
        return this.tc;
    }

    public String getGroupName() {
        return aqH.getMsg("Paper.Group." + this.tc, new Object[0]);
    }

    public Unit getUnit() {
        return this.aqJ;
    }

    @Nonnull
    public String toString() {
        return this.getName();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageFormat pageFormat = (PageFormat)obj;
        return this.gz == pageFormat.gz;
    }

    @InternalApi
    public static final class Unit
    extends Enum<Unit> {
        public static final /* enum */ Unit UNIT_INCH = new Unit();
        public static final /* enum */ Unit UNIT_MM = new Unit();
        public static final /* enum */ Unit UNIT_POINT = new Unit();
        public static final /* enum */ Unit UNIT_PIXEL = new Unit();
        private static final /* synthetic */ Unit[] aqK;

        public static Unit[] values() {
            return (Unit[])aqK.clone();
        }

        public static Unit valueOf(String name) {
            return Enum.valueOf(Unit.class, name);
        }

        private static /* synthetic */ Unit[] tx() {
            return new Unit[]{UNIT_INCH, UNIT_MM, UNIT_POINT, UNIT_PIXEL};
        }

        static {
            aqK = Unit.tx();
        }
    }
}

