/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula;

import com.inet.report.FormulaField;
import com.inet.report.ReportException;
import com.inet.report.formula.IFormulaData;
import com.inet.report.formula.j;
import com.inet.report.formula.m;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;

public class FormulaException
extends ReportException {
    private m aio;
    private String aip;
    private int aiq;

    protected FormulaException(String msg, int messageId) {
        super(msg, messageId);
    }

    public FormulaException(String msg, int messageId, m position) {
        super(msg, messageId);
        this.aio = position;
    }

    public FormulaException(ReportException e2, m position) {
        super(e2.getMessage(), e2.getErrorCode());
        super.initCause(e2);
        this.aio = position;
    }

    public static FormulaException create(ReportErrorCode idAsString, m position, Object ... msgParameter) {
        String string = idAsString.name();
        int n2 = idAsString.getErrorCodeNumber();
        string = Msg.getMsg(string, msgParameter);
        FormulaException formulaException = new FormulaException(string, n2);
        formulaException.aio = position;
        return formulaException;
    }

    public int getRow() {
        if (this.aio != null) {
            return this.aio.getLine();
        }
        return -1;
    }

    public int getColumn() {
        if (this.aio != null) {
            return this.aio.getColumn();
        }
        return -1;
    }

    public int getEndRow() {
        if (this.aio != null) {
            return this.aio.rj();
        }
        return -1;
    }

    public int getEndColumn() {
        if (this.aio != null) {
            return this.aio.getEndColumn();
        }
        return -1;
    }

    public int getStartIndex() {
        if (this.aio != null) {
            return this.aio.getStartIndex();
        }
        return -1;
    }

    public int getLength() {
        if (this.aio != null) {
            return this.aio.getLength();
        }
        return -1;
    }

    @Override
    public String getMessage() {
        if (this.aip != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(Msg.getMsg(this.aiq == 0 ? "InFormula" : "InFunction", super.getMessage(), this.aip));
            if (this.aio != null) {
                stringBuilder.append(", ");
                stringBuilder.append(Msg.getMsg("FormulaError.Position", this.aio.getLine() + 1, this.aio.getColumn() + 1));
            }
            return stringBuilder.toString();
        }
        return super.getMessage();
    }

    public void setFormulaField(j formula) {
        if (formula != null) {
            this.setFormulaField(formula.qj());
        }
    }

    public void setFormulaField(IFormulaData formulaField) {
        if (formulaField != null && formulaField.getName() != null) {
            this.aip = formulaField.getName();
            this.aiq = formulaField instanceof FormulaField ? 0 : 1;
        }
    }

    public void setFormulaName(String name) {
        if (this.aip == null) {
            this.aip = name;
        }
    }

    public void setPosition(m position) {
        this.qY();
        this.aio = position;
    }

    public m getPosition() {
        return this.aio;
    }

    protected void qY() {
    }

    public String getCausingFormulaName() {
        return this.aip;
    }
}

