/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.f;
import com.inet.report.i;
import com.inet.report.j;
import com.inet.report.util.k;
import java.awt.Font;
import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class ChartTitle
implements Serializable {
    public static final String TOKEN_HEADER = "Header";
    public static final String TOKEN_SUBTITLE = "Subtitle";
    public static final String TOKEN_FOOTNOTE = "Footnote";
    public static final String TOKEN_AXIS = "AxisTitle";
    private boolean Wg = true;
    private String hn;
    private String Wh;
    private Font Wi;
    private int color;
    private FormulaField Wj;

    public ChartTitle(Font titleFont, int color) {
        this.setFont(titleFont);
        this.setColor(color);
        this.setTitle("");
        this.aH("");
    }

    public boolean isShowAutoTitle() {
        return this.Wg;
    }

    public void setShowAutoTitle(boolean showAutoTitle) {
        this.Wg = showAutoTitle;
    }

    void aH(String string) {
        if (string == null) {
            throw i.d("autoTitle");
        }
        this.Wh = string;
    }

    String ms() {
        return this.Wh;
    }

    public String getTitle() {
        return this.hn;
    }

    public void setTitle(String title) {
        if (title == null) {
            throw i.d("title");
        }
        this.hn = title;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int titleColor) {
        if (titleColor == -1) {
            throw i.e("titleColor");
        }
        this.color = titleColor;
    }

    public Font getFont() {
        return this.Wi;
    }

    public void setFont(Font titleFont) {
        if (titleFont == null) {
            throw i.d("titleFont");
        }
        this.Wi = titleFont;
    }

    public boolean isEqualToDefault(ChartTitle defaultTitle) {
        if (!this.getFont().equals(defaultTitle.getFont())) {
            return false;
        }
        if (this.getColor() != defaultTitle.getColor()) {
            return false;
        }
        return this.isShowAutoTitle() && defaultTitle.isShowAutoTitle();
    }

    public void saveProperties(StringBuilder buffer, String type, int depth) {
        buffer.append(BaseUtils.getIndent(depth));
        buffer.append("<");
        buffer.append(type);
        buffer.append(' ');
        f.b(buffer, "showAutoTitle", String.valueOf(this.isShowAutoTitle()));
        f.b(buffer, "title", k.dW(this.getTitle()));
        buffer.append(">\n");
        f.a(buffer, depth, this.getFont(), this.getColor());
        if (this.Wj != null) {
            j.a(buffer, depth, this.Wj, "chartTitle");
        }
        buffer.append(BaseUtils.getIndent(depth));
        buffer.append("<");
        buffer.append("/");
        buffer.append(type);
        buffer.append(">\n");
    }

    public void readProperties(Element element, Chart2 chart) {
        Object object;
        String string;
        if (element.getAttribute("showAutoTitle").length() > 0) {
            this.setShowAutoTitle(Boolean.parseBoolean(element.getAttribute("showAutoTitle")));
        }
        if ((string = element.getAttribute("title")) == null) {
            string = "";
        }
        this.setTitle(string);
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() > 0) {
            this.setColor(j.b(nodeList.item(0).getChildNodes()));
            this.setFont(j.a(nodeList.item(0).getChildNodes()));
        } else {
            int n2;
            object = f.aI(element.getAttribute("font"));
            if (object != null) {
                this.setFont((Font)object);
            }
            if (element.getAttribute("color").length() > 0 && (n2 = Integer.parseInt(element.getAttribute("color"))) != -1) {
                this.setColor(n2);
            }
        }
        object = element.getChildNodes();
        FormulaField formulaField = j.a((NodeList)object, chart, "chartTitle");
        if (formulaField != null) {
            this.setTitleFormula(formulaField);
            chart.updateReferences();
        }
    }

    public ChartTitle clone() {
        ChartTitle chartTitle = new ChartTitle(this.Wi, this.color);
        chartTitle.Wh = this.Wh;
        chartTitle.Wg = this.Wg;
        chartTitle.hn = this.hn;
        return chartTitle;
    }

    public void setTitleFormula(FormulaField titleFormula) {
        this.Wj = titleFormula;
        if (this.Wj != null) {
            this.Wj.resetReferences();
        }
    }

    public FormulaField getTitleFormula() {
        return this.Wj;
    }
}

