/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.category;

import com.inet.jfree.chart.renderer.GradientPainter;
import com.inet.jfree.chart.renderer.category.BarPainter;
import com.inet.jfree.chart.renderer.category.BarRenderer;
import com.inet.jfree.chart.renderer.category.CategoryItemRendererState;
import com.inet.jfree.chart.renderer.category.Face;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import org.jfree.ui.RectangleEdge;

public class GradientBarPainter3D
implements BarPainter,
Serializable {
    private boolean horizontal;
    private GradientPainter painter;

    public GradientBarPainter3D(boolean horizontal) {
        this.horizontal = horizontal;
        this.painter = new GradientPainter();
    }

    @Override
    public void paintBar(Graphics2D g2, BarRenderer renderer, int row, int column, Shape bar, RectangleEdge base, CategoryItemRendererState state, Face face) {
        Paint itemPaint = renderer.getItemPaint(row, column);
        Rectangle2D bounds2d = bar.getBounds2D();
        Point2D.Float start = null;
        Point2D.Float end = null;
        GradientPainter.ColorOfGradient faceColor = GradientPainter.ColorOfGradient.gradient;
        if (!this.horizontal) {
            if (base == RectangleEdge.BOTTOM) {
                if (face.equals((Object)Face.Top)) {
                    faceColor = GradientPainter.ColorOfGradient.secondColor;
                } else if (face.equals((Object)Face.Bottom)) {
                    faceColor = GradientPainter.ColorOfGradient.firstColor;
                } else {
                    start = new Point2D.Float((float)bounds2d.getMinX(), (float)bounds2d.getMaxY());
                    end = new Point2D.Float((float)bounds2d.getMinX(), (float)bounds2d.getMinY());
                }
            } else if (base == RectangleEdge.TOP) {
                if (face.equals((Object)Face.Top)) {
                    faceColor = GradientPainter.ColorOfGradient.firstColor;
                } else if (face.equals((Object)Face.Bottom)) {
                    faceColor = GradientPainter.ColorOfGradient.secondColor;
                } else {
                    start = new Point2D.Float((float)bounds2d.getMinX(), (float)bounds2d.getMinY());
                    end = new Point2D.Float((float)bounds2d.getMinX(), (float)bounds2d.getMaxY());
                }
            } else if (base == RectangleEdge.LEFT) {
                if (face.equals((Object)Face.Right)) {
                    faceColor = GradientPainter.ColorOfGradient.secondColor;
                } else if (face.equals((Object)Face.Left)) {
                    faceColor = GradientPainter.ColorOfGradient.firstColor;
                } else {
                    start = new Point2D.Float((float)bounds2d.getMinX(), (float)bounds2d.getMinY());
                    end = new Point2D.Float((float)bounds2d.getMaxX(), (float)bounds2d.getMinY());
                }
            } else if (base == RectangleEdge.RIGHT) {
                if (face.equals((Object)Face.Right)) {
                    faceColor = GradientPainter.ColorOfGradient.firstColor;
                } else if (face.equals((Object)Face.Left)) {
                    faceColor = GradientPainter.ColorOfGradient.secondColor;
                } else {
                    start = new Point2D.Float((float)bounds2d.getMaxX(), (float)bounds2d.getMinY());
                    end = new Point2D.Float((float)bounds2d.getMinX(), (float)bounds2d.getMinY());
                }
            }
        } else if (base == RectangleEdge.TOP || base == RectangleEdge.BOTTOM) {
            if (face.equals((Object)Face.Left)) {
                faceColor = GradientPainter.ColorOfGradient.secondColor;
            } else if (face.equals((Object)Face.Right)) {
                faceColor = GradientPainter.ColorOfGradient.firstColor;
            } else {
                start = new Point2D.Float((float)bounds2d.getMaxX(), (float)bounds2d.getMinY());
                end = new Point2D.Float((float)bounds2d.getMinX(), (float)bounds2d.getMinY());
            }
        } else if (base == RectangleEdge.LEFT || base == RectangleEdge.RIGHT) {
            if (face.equals((Object)Face.Top)) {
                faceColor = GradientPainter.ColorOfGradient.secondColor;
            } else if (face.equals((Object)Face.Bottom)) {
                faceColor = GradientPainter.ColorOfGradient.firstColor;
            } else {
                start = new Point2D.Float((float)bounds2d.getMinX(), (float)bounds2d.getMaxY());
                end = new Point2D.Float((float)bounds2d.getMinX(), (float)bounds2d.getMinY());
            }
        }
        boolean success = this.painter.paintGradient(g2, itemPaint, bar, start, end, faceColor);
        if (success) {
            this.painter.drawOutline(g2, renderer, row, column, bar, renderer.isDrawBarOutline() && state.getBarWidth() > 3.0);
        }
    }

    @Override
    public void paintBarShadow(Graphics2D g2, BarRenderer renderer, int row, int column, RectangularShape bar, RectangleEdge base, boolean pegShadow) {
    }
}

