/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.statistic;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.i18n.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

@InternalApi
public class Accumulator {
    private static File axC;
    private static Hashtable<String, Object> buf;
    private static long bug;
    private static long buh;
    private static int bui;
    private static int buj;
    private static int buk;
    private static volatile int bul;
    private static volatile int bum;
    private static Set<Integer> bun;
    private static Set<String> buo;
    private static Set<String> bup;
    private static double buq;
    private static int bur;
    private static int bus;
    private static double but;
    private static double buu;
    private static int buv;
    private static int buw;

    private Accumulator() {
    }

    public static void incTotalRequest() {
        Accumulator.NE();
        ++bui;
    }

    public static void incReportRequest() {
        ++buj;
    }

    public static void incRenderedReports() {
        ++buk;
        bum = Math.max(bum, ++bul);
    }

    public static void decRenderedReports() {
        --bul;
    }

    public static int getCurrentRenderingReports() {
        return bul;
    }

    public static int getMaxRenderingReports() {
        return bum;
    }

    public static void countReportTemplates(URL reportUrl) {
        bun.add(reportUrl.hashCode());
    }

    public static void countClientLanguages(Locale locale) {
        buo.add(locale.getLanguage());
    }

    public static void countReportFormats(String format) {
        bup.add(format.startsWith("htm") ? "htm" : format);
    }

    public static void incPageCount(int pages) {
        buq += (double)pages;
        ++bur;
        bus = Math.max(bus, pages);
    }

    public static void countRecords(int fetchedRecord, int discardedRecords) {
        but += (double)fetchedRecord;
        buu += (double)discardedRecords;
        buv = Math.max(buv, fetchedRecord);
        buw = Math.max(buw, discardedRecords);
    }

    public static void print(Printer printer) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        Accumulator.a("Total Requests", decimalFormat, printer);
        Accumulator.a("Report Requests", decimalFormat, printer);
        Accumulator.a("Rendered Reports", decimalFormat, printer);
        Accumulator.a("Report Templates", decimalFormat, printer);
        Accumulator.a("Client Languages", decimalFormat, printer);
        Accumulator.a("Last used Client Languages", decimalFormat, printer);
        Accumulator.a("Report Formats", decimalFormat, printer);
        Accumulator.a("Last used Report Formats", decimalFormat, printer);
        Accumulator.a("Total Page Count", decimalFormat, printer);
        Accumulator.a("Maximal Page Count", decimalFormat, printer);
        Accumulator.a("Average Page Count", decimalFormat, printer);
        Accumulator.a("Total fetched Records", decimalFormat, printer);
        Accumulator.a("Maximal fetched Records", decimalFormat, printer);
        Accumulator.a("Total discarded Records", decimalFormat, printer);
        Accumulator.a("Maximal discarded Records", decimalFormat, printer);
    }

    public static void print() {
        BaseUtils.info("== Start Statistic Data ==========");
        BaseUtils.info("=== Average per Day ==============");
        Accumulator.print(new Printer(){

            @Override
            public void print(String key, String value, String description) {
                BaseUtils.info(key + ":\t" + value);
            }
        });
        BaseUtils.info("== End Statistic Data ============");
    }

    private static void a(String string, DecimalFormat decimalFormat, Printer printer) {
        Object object = buf.get(string);
        if (object == null) {
            object = "";
        }
        if (object instanceof Number && !Double.isNaN(((Number)object).doubleValue())) {
            object = decimalFormat.format(object);
        }
        String string2 = "Accumulator_" + string.replaceAll(" ", "_");
        printer.print(Msg.getMsg(string2, new Object[0]), object.toString(), Msg.getMsg(string2 + "_description", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void NE() {
        long l2 = System.currentTimeMillis();
        if (l2 > bug) {
            Class<Accumulator> clazz = Accumulator.class;
            synchronized (Accumulator.class) {
                if (l2 <= bug) return;
                Accumulator.a(buf, "");
                Accumulator.save();
                bui = 0;
                buj = 0;
                buk = 0;
                buq = 0.0;
                bus = 0;
                bur = 0;
                but = 0.0;
                buv = 0;
                buu = 0.0;
                buw = 0;
                bun.clear();
                buo.clear();
                bup.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
        if (l2 <= buh) return;
        Class<Accumulator> clazz = Accumulator.class;
        synchronized (Accumulator.class) {
            if (l2 <= buh) return;
            Accumulator.backup();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void backup() {
        if (axC == null) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Accumulator.a(hashtable, ".saved");
        buf.putAll(hashtable);
        Accumulator.save();
    }

    private static synchronized void a(Hashtable<String, Object> hashtable, String string) {
        Accumulator.a(bui, hashtable, "Total Requests" + string);
        Accumulator.a(buj, hashtable, "Report Requests" + string);
        Accumulator.a(buk, hashtable, "Rendered Reports" + string);
        Accumulator.a(buq, hashtable, "Total Page Count" + string);
        Accumulator.a(bus, hashtable, "Maximal Page Count" + string);
        Accumulator.a(but, hashtable, "Total fetched Records" + string);
        Accumulator.a(buv, hashtable, "Maximal fetched Records" + string);
        Accumulator.a(buu, hashtable, "Total discarded Records" + string);
        Accumulator.a(buw, hashtable, "Maximal discarded Records" + string);
        if (string.length() == 0) {
            Accumulator.a(bun.size(), hashtable, "Report Templates");
            Accumulator.a(buo.size(), hashtable, "Client Languages");
            hashtable.put("Last used Client Languages", buo);
            Accumulator.a(bup.size(), hashtable, "Report Formats");
            hashtable.put("Last used Report Formats", bup);
            Accumulator.a(buq / (double)bur, hashtable, "Average Page Count");
        } else {
            hashtable.put("Report Templates" + string, bun);
            hashtable.put("Client Languages" + string, buo);
            hashtable.put("Report Formats" + string, bup);
            hashtable.put("Average Page Count" + string, bur);
        }
        hashtable.put("Next Day", bug);
    }

    private static Hashtable<String, Object> NF() {
        Hashtable<String, Object> hashtable = buf = new Hashtable<String, Object>();
        try {
            axC = new File(System.getProperty("user.home"), ".cc.statistic");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(axC));
                hashtable = (Hashtable<String, Object>)objectInputStream.readObject();
                objectInputStream.close();
                if (hashtable != null) {
                    buf = hashtable;
                } else {
                    hashtable = buf;
                }
                bui = (int)Accumulator.dJ("Total Requests");
                buj = (int)Accumulator.dJ("Report Requests");
                buk = (int)Accumulator.dJ("Rendered Reports");
                buq = Accumulator.dJ("Total Page Count");
                bus = (int)Accumulator.dJ("Maximal Page Count");
                bur = (int)Accumulator.dJ("Average Page Count");
                but = Accumulator.dJ("Total fetched Records");
                buv = (int)Accumulator.dJ("Maximal fetched Records");
                buu = Accumulator.dJ("Total discarded Records");
                buw = (int)Accumulator.dJ("Maximal discarded Records");
                bun = Accumulator.dK("Report Templates");
                buo = Accumulator.dK("Client Languages");
                bup = Accumulator.dK("Report Formats");
                Long l2 = (Long)hashtable.get("Next Day");
                if (l2 != null) {
                    Accumulator.NG();
                    bug = l2;
                    Accumulator.NE();
                }
            }
            catch (Throwable throwable) {
                buf = hashtable;
                bun = Collections.synchronizedSet(new HashSet());
                buo = Collections.synchronizedSet(new HashSet());
                bup = Collections.synchronizedSet(new HashSet());
            }
            Accumulator.NG();
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            bun = Collections.synchronizedSet(new HashSet());
            buo = Collections.synchronizedSet(new HashSet());
            bup = Collections.synchronizedSet(new HashSet());
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Accumulator.backup();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashtable;
    }

    private static void NG() {
        Date date = new Date();
        buh = date.getTime() + 3600000L;
        date = new Date(date.getYear(), date.getMonth(), date.getDate() + 1);
        bug = date.getTime();
    }

    private static synchronized void save() {
        if (axC == null) {
            return;
        }
        Accumulator.NG();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(axC));
            objectOutputStream.writeObject(buf);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static double dJ(String string) {
        Number number = (Number)buf.get(string + ".saved");
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    private static Set dK(String string) {
        Set set = (Set)buf.get(string + ".saved");
        if (set != null) {
            return set;
        }
        return Collections.synchronizedSet(new HashSet());
    }

    private static synchronized void a(double d2, Hashtable<String, Object> hashtable, String string) {
        Double d3 = (Double)hashtable.get(string);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            d2 = 0.0;
        }
        if (d3 == null) {
            hashtable.put(string, d2);
        } else {
            double d4 = (d2 + 7.0 * d3) / 8.0;
            hashtable.put(string, d4);
        }
    }

    static {
        buf = Accumulator.NF();
    }

    @InternalApi
    public static interface Printer {
        public void print(String var1, String var2, String var3);
    }
}

