/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.api;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.util.StringFunctions;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.renderer.api.RendererFactory;
import com.inet.report.renderer.api.ToClientCmd;
import com.inet.report.renderer.api.commands.ExportAllCmd;
import com.inet.report.renderer.api.commands.e;
import com.inet.report.renderer.api.commands.f;
import com.inet.report.renderer.api.commands.g;
import com.inet.report.renderer.api.commands.h;
import com.inet.report.renderer.api.implementation.a;
import com.inet.report.renderer.api.implementation.b;
import com.inet.report.renderer.api.implementation.c;
import com.inet.report.renderer.api.implementation.d;
import com.inet.report.renderer.api.implementation.i;
import com.inet.report.renderer.api.implementation.j;
import com.inet.report.renderer.api.implementation.k;
import com.inet.report.renderer.api.implementation.l;
import com.inet.report.renderer.api.implementation.m;
import com.inet.report.renderer.api.implementation.n;
import com.inet.report.renderer.api.implementation.o;
import com.inet.report.renderer.api.implementation.p;
import com.inet.report.renderer.api.implementation.q;
import com.inet.report.renderer.api.implementation.r;
import com.inet.report.renderer.api.implementation.s;
import com.inet.report.renderer.api.implementation.t;
import com.inet.report.renderer.api.implementation.u;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class RendererFactoryManager {
    @Nonnull
    private static final RendererFactoryManager axP = new RendererFactoryManager();
    private static final ConfigValue<String> PW = new ConfigValue(ConfigKey.DEFAULT_RENDERING_FORMAT);
    private final Map<String, RendererFactory> axQ = new TreeMap<String, RendererFactory>((a2, b2) -> {
        int n2 = Integer.compare(a2.length(), b2.length());
        return n2 == 0 ? a2.compareTo((String)b2) : n2;
    });
    private final List<String> axR = new ArrayList<String>();
    private final HashMap<String, ToClientCmd> axS = new HashMap();

    private RendererFactoryManager() {
        List<RendererFactory> list = this.wd();
        list.addAll(ServerPluginManager.getInstance().get(RendererFactory.class));
        for (RendererFactory rendererFactory : list) {
            for (String string : rendererFactory.getSupportedFormats()) {
                if (this.axQ.containsKey(string)) {
                    throw new IllegalStateException("Duplicate format definition: " + string);
                }
                this.axQ.put(string, rendererFactory);
                if (!rendererFactory.allowsPartialFormatMatching()) continue;
                this.axR.add(string);
            }
        }
        this.axS.put("get_pg", new e());
        this.axS.put("get_pg_count", new g());
        this.axS.put("get_grouptree", new f());
        this.axS.put("get_pg_limit", new h());
        this.axS.put("export", new ExportAllCmd(){

            @Override
            @Nonnull
            public String getMimeType() {
                return "application/crystalclear";
            }
        });
    }

    @Nonnull
    public static RendererFactoryManager getInstance() {
        return axP;
    }

    @Nonnull
    public @Nonnull Set<@Nonnull Map.Entry<String, RendererFactory>> getDocumentRenderer() {
        return Collections.unmodifiableSet(this.axQ.entrySet());
    }

    @Nonnull
    public RendererFactory getDocumentRenderer(@Nonnull String exportFormat) throws IllegalStateException {
        RendererFactory rendererFactory = this.axQ.get(exportFormat);
        if (rendererFactory == null) {
            for (String string : this.axR) {
                if (!exportFormat.startsWith(string)) continue;
                rendererFactory = this.axQ.get(string);
                break;
            }
            if (rendererFactory == null) {
                throw new IllegalStateException("Unknown format: " + exportFormat);
            }
        }
        return rendererFactory;
    }

    @Nonnull
    public String reportFileToInitParam(@Nonnull String report, @Nonnull Properties props) {
        int n2 = report.lastIndexOf(".");
        if (n2 < 0) {
            return "";
        }
        Map.Entry<String, RendererFactory> entry = null;
        for (Map.Entry<String, RendererFactory> entry2 : this.axQ.entrySet()) {
            String string = entry2.getKey();
            Objects.requireNonNull(string);
            RendererFactory rendererFactory = entry2.getValue();
            if (!report.endsWith("." + string) || StringFunctions.isEmpty((String)rendererFactory.getInitFormat(string))) continue;
            entry = entry2;
            break;
        }
        if (entry == null) {
            return report.substring(Math.min(n2 + 1, report.length())).toLowerCase();
        }
        String string = (String)entry.getKey();
        Objects.requireNonNull(string);
        if (props.get("cmd") == null && props.get("export_fmt") == null) {
            props.put("init", Objects.requireNonNullElse(((RendererFactory)entry.getValue()).getInitFormat(string), (String)PW.get()));
        }
        props.put("report", report.substring(0, report.length() - string.length()) + "rpt");
        return "rpt";
    }

    @Nullable
    public ToClientCmd getToClientHandlerByCommand(@Nullable String command) {
        if (StringFunctions.isEmpty((String)command)) {
            return null;
        }
        ToClientCmd toClientCmd = this.axS.get(command);
        if (toClientCmd != null) {
            return toClientCmd;
        }
        Objects.requireNonNull(command);
        return this.getDocumentRenderer(command).getToClientCmd(command);
    }

    private List<RendererFactory> wd() {
        ArrayList<RendererFactory> arrayList = new ArrayList<RendererFactory>();
        arrayList.add(new com.inet.report.renderer.api.implementation.g());
        arrayList.add(new com.inet.report.renderer.api.implementation.h());
        arrayList.add(new n());
        arrayList.add(new d());
        arrayList.add(new r());
        arrayList.add(new p());
        arrayList.add(new i());
        arrayList.add(new o());
        arrayList.add(new com.inet.report.renderer.api.implementation.e());
        arrayList.add(new com.inet.report.renderer.api.implementation.f());
        arrayList.add(new k());
        arrayList.add(new m());
        arrayList.add(new u());
        arrayList.add(new a());
        arrayList.add(new c());
        arrayList.add(new b());
        arrayList.add(new l());
        arrayList.add(new q());
        arrayList.add(new t());
        arrayList.add(new s());
        arrayList.add(new j());
        return arrayList;
    }
}

