/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.encode;

import com.inet.error.ErrorCode;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.encode.AbstractDecoder;
import com.inet.report.encode.DecoderFactory;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.imageio.ImageIO;

public class ErrDecoder
extends AbstractDecoder {
    private String afO;
    private ErrorCode afP;
    private Object[] afQ;

    public ErrDecoder() {
    }

    public ErrDecoder(String errMsg) {
        this.afO = errMsg;
    }

    public ErrDecoder(byte[] buffer, int offset, int length, String errMsg) {
        super(buffer, offset, length);
        this.afO = errMsg;
    }

    public ErrDecoder(byte[] buffer, int offset, int length, ErrorCode errorCode, Object ... params) {
        super(buffer, offset, length);
        this.afP = errorCode;
        this.afQ = params;
        this.afO = errorCode.getMsg(params);
    }

    public String getErrorMessage() {
        return this.afO;
    }

    public ReportException getReportException() {
        if (this.afP != null) {
            return ReportExceptionFactory.createReportException(this.afP, this.afQ);
        }
        return ReportExceptionFactory.createReportException(ReportErrorCode.PictureError, this.afO);
    }

    @Override
    public BufferedImage decodeImage(int width, int height) {
        return DecoderFactory.getErrorImage(this.pN(), width, height);
    }

    @Override
    public byte[] getBuffer() {
        if (this.buffer == null) {
            BufferedImage bufferedImage = this.getImage(100, 100);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                this.buffer = byteArrayOutputStream.toByteArray();
            }
            catch (IOException iOException) {
                BaseUtils.printStackTrace(iOException);
            }
        }
        return this.buffer;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.afO);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.afO = (String)in.readObject();
    }

    private String pN() {
        return Msg.getMsg(this.afO, new Object[0]);
    }

    @Override
    public boolean isAutoScaledAndAligned() {
        return true;
    }
}

