/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.annotations.JsonData;
import com.inet.annotations.JsonExcludeNull;
import com.inet.lib.util.Encryption;
import java.io.IOException;

@JsonData
public class UrlAuthConfig {
    private AuthType type;
    @JsonExcludeNull
    private String username;
    @JsonExcludeNull
    private String password;
    @JsonExcludeNull
    private String bearer;
    @JsonExcludeNull
    private String provider;
    @JsonExcludeNull
    private String refreshToken;
    @JsonExcludeNull
    private String scopes;

    private UrlAuthConfig() {
    }

    public AuthType getType() {
        return this.type;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() throws IOException {
        return Encryption.decodePassword((String)this.password);
    }

    public String getBearerToken() {
        return this.bearer;
    }

    public String getOauthProvider() {
        return this.provider;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public void setRefreshToken(String refreshToken) {
        this.refreshToken = refreshToken;
    }

    @JsonData
    public static enum AuthType {
        none,
        basic,
        bearer,
        oauth;

    }
}

