/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.CascadingSource;
import com.inet.report.Database;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.SQLValueProvider;
import com.inet.report.TableSource;
import com.inet.report.bo;
import com.inet.report.database.DataFactory;
import com.inet.report.database.JdbcData;
import com.inet.report.database.fetch.b;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import java.sql.SQLException;
import java.util.Map;
import org.xml.sax.Attributes;

@PublicApi
public class FieldValueProvider
extends SQLValueProvider
implements CascadingSource {
    private Datasource qV;
    private int gO;
    private DatabaseField qW;
    private DatabaseField qX;

    public FieldValueProvider(DatabaseField values, DatabaseField descriptions, int sortType) {
        if (values == null) {
            throw new IllegalArgumentException("values database field is not allowed to be null");
        }
        this.V(sortType);
        this.setValues(values);
        this.qW = descriptions;
        this.gO = sortType;
        this.qV = values.kU.getDatasource();
        this.a(values, descriptions);
    }

    FieldValueProvider() {
    }

    private void a(DatabaseField databaseField, DatabaseField databaseField2) {
        if (databaseField2 != null && !databaseField2.kU.getDatasource().equals(this.qV)) {
            throw new IllegalArgumentException("database fields do not come from the same data source!");
        }
        if (databaseField2 != null && !databaseField2.kU.equals(databaseField.kU)) {
            throw new IllegalArgumentException("database fields do not come from the same table source!");
        }
        if (databaseField.kU.getSql() != null) {
            throw new IllegalArgumentException("database field comes from an SQL Query, this is not allowed!");
        }
    }

    protected String a(String string, boolean bl2, boolean bl3) throws ReportException, SQLException {
        this.V(this.gO);
        TableSource tableSource = this.getValues().kU;
        Datasource datasource = tableSource.getDatasource();
        Engine engine = datasource.getEngine();
        DataFactory dataFactory = datasource.getDataFactory();
        if (!(dataFactory instanceof JdbcData)) {
            throw new ReportException("Not an SQL-based database", 0);
        }
        JdbcData jdbcData = (JdbcData)dataFactory;
        b b2 = new b(engine.bM());
        String string2 = jdbcData.getSqlSyntax().convertIdentifier(datasource, this.getValues().getName());
        String string3 = null;
        StringBuilder stringBuilder = new StringBuilder(bl3 ? "DISTINCT " : "");
        stringBuilder.append(string2);
        if (this.qW != null) {
            string3 = jdbcData.getSqlSyntax().convertIdentifier(datasource, this.qW.getName());
            stringBuilder.append(", ").append(string3);
        }
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(string2);
        if (this.qW != null) {
            stringBuilder2.append(", ").append(string3);
        }
        StringBuilder stringBuilder3 = null;
        if (this.gO != 2 && dataFactory.getConfiguration().isUseOrderBy()) {
            stringBuilder3 = new StringBuilder();
            stringBuilder3.append(string2);
            if (this.gO == 0) {
                stringBuilder3.append(" ASC");
            } else if (this.gO == 1) {
                stringBuilder3.append(" DESC");
            }
        }
        if (bl2) {
            bo bo2 = b2.b(jdbcData, datasource);
            return bo2.a(stringBuilder.toString(), string, stringBuilder2.toString(), stringBuilder3 == null ? null : stringBuilder3.toString());
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SELECT ");
        stringBuffer.append((CharSequence)stringBuilder);
        stringBuffer.append(" FROM ");
        stringBuffer.append(tableSource.ku()).append(' ').append(tableSource.getAlias());
        if (string != null) {
            stringBuffer.append(" WHERE ");
            stringBuffer.append(string);
        }
        stringBuffer.append(" GROUP BY ");
        stringBuffer.append((CharSequence)stringBuilder2);
        if (stringBuilder3 != null) {
            stringBuffer.append(" ORDER BY ");
            stringBuffer.append((CharSequence)stringBuilder3);
        }
        return stringBuffer.toString();
    }

    @Override
    public String getSQL() throws ReportException, SQLException {
        return this.a(null, false, false);
    }

    private void V(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("sort type " + n2 + " is not a valid sort type.");
            }
        }
    }

    public int getSortType() {
        return this.gO;
    }

    public void setSortType(int sortType) {
        this.V(sortType);
        this.gO = sortType;
    }

    public DatabaseField getDescriptions() {
        return this.qW;
    }

    public void setDescriptions(DatabaseField descriptions) {
        this.a(this.getValues(), descriptions);
        this.qW = descriptions;
    }

    public DatabaseField getValues() {
        return this.qX;
    }

    public void setValues(DatabaseField values) {
        if (values == null) {
            throw new IllegalArgumentException("values field was null");
        }
        this.a(values, this.qW);
        this.qX = values;
    }

    @Override
    public Datasource getDatasource() {
        return this.qV;
    }

    public void setDatasource(Datasource datasource) {
        if (datasource == null) {
            throw new IllegalArgumentException("datasource was null");
        }
        this.qV = datasource;
    }

    @Override
    public String getFieldRefName() {
        TableSource tableSource = this.getValues().kU;
        Datasource datasource = tableSource.getDatasource();
        Engine engine = datasource.getEngine();
        Database database = (Database)datasource.getDataFactory();
        return database.convertIdentifier(datasource, this.getValues().getName());
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        Engine engine = (Engine)parserMap.get(PromptField.b.zM.name());
        try {
            switch (a.valueOf(tag)) {
                case ra: {
                    String string = atts.getValue("name");
                    String string2 = atts.getValue("value");
                    Field field = engine.bB.a(false, string2);
                    if (field == null) {
                        return null;
                    }
                    if (this.qV == null) {
                        this.qV = ((DatabaseField)field).getTableSource().getDatasource();
                    }
                    if ("dynamic value field".equals(string)) {
                        this.setValues((DatabaseField)field);
                        break;
                    }
                    if (!"dynamic description field".equals(string)) break;
                    this.setDescriptions((DatabaseField)field);
                    break;
                }
                case qZ: {
                    String string = atts.getValue("value");
                    this.setSortType(Integer.parseInt(string));
                }
            }
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
        }
        return null;
    }

    private static final class a
    extends Enum<a> {
        public static final /* enum */ a qZ = new a();
        public static final /* enum */ a ra = new a();
        private static final /* synthetic */ a[] rb;

        public static a[] values() {
            return (a[])rb.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] dd() {
            return new a[]{qZ, ra};
        }

        static {
            rb = a.dd();
        }
    }
}

