/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.lib.list.StringIntMap;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Fields;
import com.inet.report.FormulaField;
import com.inet.report.Group;
import com.inet.report.GroupField;
import com.inet.report.Join;
import com.inet.report.PromptField;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReferencedObject;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SQLField;
import com.inet.report.SortField;
import com.inet.report.ap;
import com.inet.report.at;
import com.inet.report.ba;
import com.inet.report.i18n.Msg;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.k;
import com.inet.report.parser.FatalParserException;
import com.inet.report.parser.NodeParser;
import com.inet.report.parser.XMLTag;
import com.inet.report.s;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Map;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

@PublicApi
public abstract class Field
implements ReferencedObject,
NodeParser,
Serializable {
    ba bB;
    int type;
    String name;
    private int qp = -1;
    int valueType = -1;
    int qq = -1;
    int qr;
    private Group gW;
    private Field lI;
    boolean lL;
    public static final int NUMBER = 6;
    public static final int CURRENCY = 7;
    public static final int BOOLEAN = 8;
    public static final int DATE = 9;
    public static final int TIME = 10;
    public static final int STRING = 11;
    public static final int BINARY = 14;
    public static final int DATETIME = 15;
    public static final int CURSOR = -10;
    public static final int UNKNOWN = -1;
    public static final int DATABASE_FIELD = 14;
    public static final int FORMULA_FIELD = 13;
    public static final int SUMMARY_FIELD = 11;
    public static final int SPECIAL_FIELD = 10;
    public static final int GROUP_NAME_FIELD = 12;
    public static final int PARAMETER_FIELD = 16;
    public static final int SORT_FIELD = 15;
    public static final int SQL_FIELD = 17;
    private s qs = new s(this);

    Field() {
    }

    static void a(StringIntMap stringIntMap) {
        stringIntMap.put("SpecialVarField", 10);
        stringIntMap.put("SummaryField", 11);
        stringIntMap.put("GroupNameField", 12);
        stringIntMap.put("FormulaField", 13);
        stringIntMap.put("DatabaseField", 14);
        stringIntMap.put("SortField", 15);
        stringIntMap.put("PromptVarField", 16);
        stringIntMap.put("SqlExprField", 17);
    }

    abstract Field[] D(int var1);

    public String paramString() {
        return this.getTypeAsString() + Msg.getMsg("withName", "'" + this.name + "'");
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Field field = (Field)obj;
        if (this.name == null) {
            return field.name == null;
        }
        return this.name.equalsIgnoreCase(field.name);
    }

    String cZ() {
        return Field.s(this.type, this.getName());
    }

    public String getPlaceholderName() {
        String string = Field.s(this.type, this.getName());
        return "{" + string + "}";
    }

    private static String s(int n2, String string) {
        switch (n2) {
            case 11: {
                return "#" + string;
            }
            case 13: {
                return "@" + string;
            }
            case 14: {
                return string;
            }
            case 16: {
                return "?" + string;
            }
            case 17: {
                return "%" + string;
            }
        }
        return string;
    }

    public String getName() {
        return this.name;
    }

    public abstract void setName(String var1) throws ReportException;

    public String getRefName() {
        switch (this.type) {
            case 13: {
                return "@" + this.name;
            }
            case 16: {
                return "?" + this.name;
            }
            case 11: {
                return "#" + this.name;
            }
            case 17: {
                return "%" + this.name;
            }
            case 12: {
                return "Groupname:" + this.getField().getRefName();
            }
        }
        return this.name;
    }

    public Field getField() {
        return this.lI;
    }

    public void setField(Field newField) {
        this.lI = newField;
    }

    public int getType() {
        return this.type;
    }

    public Group getGroup() {
        return this.gW;
    }

    public void setGroup(Group group) {
        this.gW = group;
    }

    public int getValueType() {
        return this.valueType;
    }

    String getValueTypeString() {
        switch (this.valueType) {
            case 6: {
                return "NUMBER";
            }
            case 7: {
                return "CURRENCY";
            }
            case 8: {
                return "BOOLEAN";
            }
            case 9: {
                return "DATE";
            }
            case 10: {
                return "TIME";
            }
            case 11: {
                return "STRING";
            }
            case 14: {
                return "BINARY";
            }
            case 15: {
                return "DATETIME";
            }
            case -10: {
                return "CURSOR";
            }
        }
        return "UNKNOWN";
    }

    public void setValueType(int newValue) {
        switch (newValue) {
            case -10: 
            case -1: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 1024: 
            case 2048: {
                this.valueType = newValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal argument for value type " + newValue + ". Expected NUMBER,CURRENCY,BOOLEAN,DATE,TIME,STRING,BINARY,DATETIME or CURSOR");
            }
        }
    }

    void k(PrintWriter printWriter, int n2) {
        String string = BaseUtils.getIndent(n2);
        ++n2;
        StringBuilder stringBuilder = new StringBuilder();
        if (this.name != null) {
            k.a(stringBuilder, n2, a.qv.name(), this.name);
        }
        if (this.lI != null && !this.lI.lL) {
            k.a(stringBuilder, n2, this.lI, "id");
        }
        if (!(this instanceof PromptField)) {
            try {
                this.valueType = this.getValueType();
            }
            catch (Exception exception) {
                this.valueType = -1;
                this.bB.b(exception);
            }
        }
        String string2 = this.getTypeAsString();
        if (this.bB.je() == this) {
            string2 = "RecordSelection";
        } else if (this.bB.jf() == this) {
            string2 = "GroupSelection";
        }
        printWriter.print(string + "<Field" + k.l("type", string2) + (this.bB != null && this.indexOf() < 0 ? k.l("id", k.z(this.indexOf())) : "") + k.l("valueType", k.z(this.valueType)) + ">\n");
        if (stringBuilder.length() > 0) {
            printWriter.print(stringBuilder.toString());
        }
        if (this instanceof GroupField && this.lL) {
            ((GroupField)this).t(printWriter, n2);
        } else {
            this.p(printWriter, n2);
        }
        printWriter.print(string + "</Field>\n");
    }

    protected abstract void p(PrintWriter var1, int var2);

    String getTypeAsString() {
        return Field.e(this.type);
    }

    static String e(int n2) {
        String string = "unknown";
        switch (n2) {
            case 10: {
                string = "SpecialVarField";
                break;
            }
            case 11: {
                string = "SummaryField";
                break;
            }
            case 12: {
                string = "GroupNameField";
                break;
            }
            case 13: {
                string = "FormulaField";
                break;
            }
            case 14: {
                string = "DatabaseField";
                break;
            }
            case 15: {
                string = "SortField";
                break;
            }
            case 16: {
                string = "PromptVarField";
                break;
            }
            case 17: {
                string = "SqlExprField";
            }
        }
        return string;
    }

    void a(int n2, String string, at at2) {
        switch (n2) {
            case 173: {
                try {
                    this.setName(string);
                }
                catch (ReportException reportException) {
                    this.name = string;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.name = string;
                }
                if (this instanceof DatabaseField && this.bB.jd().indexOf(this.name) == -1) {
                    this.bB.jd().addElement((DatabaseField)this);
                }
                if (this.type != 14) break;
                ap.a(this.bB.jc(), (DatabaseField)this);
                break;
            }
            case 204: {
                this.qr = Integer.parseInt(string);
                break;
            }
        }
    }

    void d(String string, Attributes attributes) throws ReportException {
        String string2 = attributes.getValue("value");
        if (string2 == null) {
            return;
        }
        a a2 = a.qu;
        try {
            a2 = a.valueOf(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (a2) {
            case qv: {
                try {
                    this.setName(string2);
                }
                catch (ReportException reportException) {
                    this.name = string2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.name = string2;
                }
                if (this instanceof DatabaseField && this.bB.jd().indexOf(this.name) == -1) {
                    this.bB.jd().addElement((DatabaseField)this);
                }
                if (this.type != 14) break;
                ap.a(this.bB.jc(), (DatabaseField)this);
                break;
            }
            case qw: {
                this.qr = Integer.parseInt(string2);
                break;
            }
        }
    }

    public int indexOf() {
        try {
            return this.bB.a(false, this);
        }
        catch (ReportException reportException) {
            BaseUtils.printStackTrace(reportException);
            return -1;
        }
    }

    void changeAllAliases(String oldAlias, String newAlias, Datasource dc) throws ReportException {
        if (this.lI != null) {
            this.lI.changeAllAliases(oldAlias, newAlias, dc);
        }
        if (this.getGroup() != null && !this.getGroup().dr()) {
            this.getGroup().changeAllAliases(oldAlias, newAlias, dc);
        }
    }

    public boolean isUsed() {
        if (this.getReferenceHolderCount() == 0) {
            return false;
        }
        ReferenceHolder[] referenceHolderArray = this.getReferenceHolders();
        for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
            if (referenceHolderArray[i2] instanceof Field) {
                int n2 = ((Field)((Object)referenceHolderArray[i2])).getType();
                if (n2 == 13) {
                    FormulaField formulaField = (FormulaField)referenceHolderArray[i2];
                    if (formulaField.getFormulaType() == 0) {
                        if (!formulaField.isUsed()) continue;
                        return true;
                    }
                    if (formulaField.getFormulaType() == 3) {
                        return true;
                    }
                    if (formulaField.getFormulaType() != 2 && formulaField.getFormulaType() != 1) continue;
                    return true;
                }
                if (!(n2 == 11 || n2 == 17 ? ((Field)((Object)referenceHolderArray[i2])).isUsed() : n2 == 15 && ((SortField)referenceHolderArray[i2]).getSort() >= 16)) continue;
                return true;
            }
            if (referenceHolderArray[i2] instanceof Join) continue;
            return true;
        }
        return false;
    }

    public boolean checkNameExists(String nameToCheck) {
        if (this.name == null) {
            return false;
        }
        return this.name.equalsIgnoreCase(nameToCheck);
    }

    @Override
    public void addReferenceHolder(ReferenceHolder holder) {
        this.qs.addReferenceHolder(holder);
    }

    @Override
    public ReferenceHolder[] getReferenceHolders() {
        return this.qs.getReferenceHolders();
    }

    @Override
    public int getReferenceHolderCount() {
        return this.qs.getReferenceHolderCount();
    }

    @Override
    public int getRealReferenceCount() {
        return this.qs.getRealReferenceCount();
    }

    @Override
    public void removeReferenceHolder(ReferenceHolder holder) {
        this.qs.removeReferenceHolder(holder);
    }

    public void rename(String newName) throws ReportException {
        Fields fields = this.bB.getFields();
        switch (this.getType()) {
            case 13: {
                Object object;
                int n2;
                for (n2 = 0; n2 < fields.getFormulaFieldsCount(); ++n2) {
                    object = fields.getFormulaField(n2);
                    if (object == this || !((Field)object).getName().equalsIgnoreCase(newName)) continue;
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.fieldWithNameAlreadyExists, "FormulaField", newName);
                }
                break;
            }
            case 16: {
                Object object;
                int n2;
                for (n2 = 0; n2 < fields.getPromptFieldsCount(); ++n2) {
                    fields.getPromptField(n2);
                    object = fields.getPromptField(n2);
                    if (object == this || !((Field)object).getName().equalsIgnoreCase(newName)) continue;
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.fieldWithNameAlreadyExists, "PromptVarField", newName);
                }
                break;
            }
            case 17: {
                Object object;
                int n2;
                for (n2 = 0; n2 < fields.getSQLExpressionFieldsCount(); ++n2) {
                    object = fields.getSQLExpressionField(n2);
                    if (object == this || !((Field)object).getName().equalsIgnoreCase(newName)) continue;
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.fieldWithNameAlreadyExists, "SqlExprField", newName);
                }
                break;
            }
            case 11: {
                Object object;
                int n2;
                for (n2 = 0; n2 < fields.getSummaryFieldsCount(); ++n2) {
                    object = fields.getSummaryField(n2);
                    if (object == this || !((Field)object).getName().equalsIgnoreCase(newName)) continue;
                    throw ReportExceptionFactory.createReportException(ReportErrorCode.fieldWithNameAlreadyExists, "SummaryField", newName);
                }
                break;
            }
        }
        this.E(newName);
        ReferenceHolder[] referenceHolderArray = this.getReferenceHolders();
        if (this.name != null) {
            for (ReferenceHolder object : referenceHolderArray) {
                Field field;
                if (object instanceof FormulaField) {
                    field = (FormulaField)object;
                    ((FormulaField)field).b(this.cZ(), Field.s(this.type, newName), null);
                    continue;
                }
                if (!(object instanceof SQLField)) continue;
                field = (SQLField)object;
                ((SQLField)field).changeAliasName(this.cZ(), Field.s(this.type, newName));
            }
        }
        this.name = newName;
        for (ReferenceHolder referenceHolder : referenceHolderArray) {
            ((ReferenceHolder)referenceHolder).resetReferences();
            ((ReferenceHolder)referenceHolder).setReferences();
        }
        fields.a(this, 3);
    }

    private void E(String string) throws ReportException {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 != '}') continue;
            throw ReportExceptionFactory.createReportException(ReportErrorCode.illegalCharInAliasname, "}");
        }
    }

    protected void b(Attributes attributes) throws ReportException {
        String string = attributes.getValue("name");
        String string2 = attributes.getValue("value");
        if (string2 == null) {
            throw new ReportException("Reference: value is empty ", 0);
        }
        string2 = this.F(string2);
        if (string.equals("id")) {
            this.setField(this.bB.a(false, string2));
        }
    }

    protected String F(String string) {
        if (string.charAt(0) == '{') {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    @Override
    public NodeParser parseElement(XMLTag group, String tag, Attributes atts, Map<String, Object> parserMap) throws FatalParserException {
        return null;
    }

    @Override
    public void parseText(String text, Map<String, Object> parserMap) {
    }

    @Override
    public void parseEndElement(XMLTag group, String tag, Map<String, Object> parserMap) throws FatalParserException {
    }

    @Override
    public boolean isDOMParser() {
        return false;
    }

    @Override
    public void parseDOM(Node node, Map<String, Object> parserMap) throws FatalParserException {
    }

    public Field duplicate(String name) {
        throw new UnsupportedOperationException("duplicating only works for FormulaFields, PromptFields, SQLFields, and SummaryFields.");
    }

    void U(int n2) {
        this.qp = n2;
    }

    int da() {
        return this.qp;
    }

    abstract Object getValue() throws ReportException;

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a qu = new a();
        public static final /* enum */ a qv = new a();
        public static final /* enum */ a qw = new a();
        public static final /* enum */ a qx = new a();
        public static final /* enum */ a qy = new a();
        private static final /* synthetic */ a[] qz;

        public static a[] values() {
            return (a[])qz.clone();
        }

        public static a valueOf(String name) {
            return Enum.valueOf(a.class, name);
        }

        private static /* synthetic */ a[] db() {
            return new a[]{qu, qv, qw, qx, qy};
        }

        static {
            qz = a.db();
        }
    }
}

