clearreportsApp.controller('reportexportcontroller', function ($rootScope, $scope, $timeout, modalservice, dataservice, errorservice, filechooser) {

    $scope.modalservice = modalservice;
    
    $scope.reportExportModel = {
        target: 'download',
        saveTarget: '',
        running: false,
        progress: 0,
        exportData: undefined,
        statusTimer: undefined
    };
    
    let saveExportOnServer = function(parameters) {
        errorservice.clearErrorContent('.reportexporterror');
        dataservice.execute('reportexport.saveonserver', {
            data: angular.toJson({
                parameters: parameters,
                saveTarget: $scope.reportExportModel.saveTarget
            }),
            alertSelector: '.reportexporterror', 
            handleSuccess: function(response) {
                if (modalservice.activemodal != undefined && modalservice.activemodal.reportExportDialog===true) {
                    modalservice.activemodal.close();
                    errorservice.shownotificationcontent($rootScope.getMsg('reportexportdialog.saveonserver.success'), errorservice.type.SUCCESS);
                }
            }, 
            afterError: function() {
                $scope.reportExportModel.running = false;
                $scope.reportExportModel.exportData = undefined;
            }
        });
    };
    
    let cacheKeyToParameter = function( reportCacheKey ) {
        let params = new URLSearchParams( reportCacheKey.parameter );
        params.set( "report", reportCacheKey.report );
        params.set( "export_fmt", reportCacheKey.format );
        return params.toString();
    }
    
    let updateStatus = function( reportCacheKey ) {
        errorservice.clearErrorContent('.reportexporterror');
        dataservice.execute('', {
            encrypt: false,
            url: '../report/?cmd=status&' + cacheKeyToParameter(reportCacheKey),
            alertSelector: '.reportexporterror', 
            handleSuccess: function(response) {
                response = angular.fromJson(response);
                $scope.reportExportModel.progress = response.progress;
                if (response.error != undefined) {
                    $scope.reportExportModel.running = false;
                    $scope.reportExportModel.exportData = undefined;
                    errorservice.showerrorcontent(response.error, ".reportexporterror");
                    return;
                }
                if (response.state == 'NO_ENGINE') { // FINISHED
                    if (modalservice.activemodal != undefined && modalservice.activemodal.reportExportDialog===true) {
                        
                        if ($scope.reportExportModel.target == 'saveonserver') {
                            let params = new URLSearchParams( reportCacheKey.parameter );
                            let parameters = {};
                            for (const p of params) {
                                parameters[p[0]] = p.length==2?p[1]:'';
                            }
                            saveExportOnServer(parameters);
                            return;
                        }
                        
                        $scope.reportExportModel.exportData = {
                            id: GUID.createNew(),
                            url: '../report/?disposition=attachment&' + cacheKeyToParameter(reportCacheKey),
                            filename: modalservice.activemodal.exportOptions.filename,
                            loaded: function() {
                                if (modalservice.activemodal != undefined && modalservice.activemodal.reportExportDialog===true) {
                                    modalservice.activemodal.close();
                                    errorservice.shownotificationcontent($rootScope.getMsg('reportexportdialog.download.success'), errorservice.type.SUCCESS);
                                }
                            }
                        };
                    }
                } else if (response.state == 'NO_CACHE_ENTRY') { // ERROR
                    $scope.reportExportModel.running = false;
                    $scope.reportExportModel.exportData = undefined;
                    errorservice.showerrorcontent($rootScope.getMsg('reportexportdialog.error'), ".reportexporterror");
                } else {
                    $scope.reportExportModel.statusTimer = $timeout(function() {
                        updateStatus( reportCacheKey );
                    }, 500);
                }
            }, 
            afterError: function() {
                $scope.reportExportModel.running = false;
                $scope.reportExportModel.exportData = undefined;
            }
        });
    };
    
    let startExport = function() {
        errorservice.clearErrorContent('.reportexporterror');
        $scope.reportExportModel.running = true;
        
        if (modalservice.activemodal.exportOptions.asyncWithProgress===false) {
            // synchronous execution, download will start with the export
            if ($scope.reportExportModel.target == 'saveonserver') {
                dataservice.execute(modalservice.activemodal.exportOptions.exportHandlerKey, {
                    data: angular.toJson({
                        format: modalservice.activemodal.exportOptions.format,
                        filename: modalservice.activemodal.exportOptions.filename,
                        reportData: modalservice.activemodal.exportOptions.reportDataProvider(),
                        saveTarget: $scope.reportExportModel.saveTarget,
                    }),
                    alertSelector: '.reportexporterror',
                    handleSuccess: function(response) {
                        if (modalservice.activemodal != undefined && modalservice.activemodal.reportExportDialog===true) {
                            modalservice.activemodal.close();
                            errorservice.shownotificationcontent($rootScope.getMsg('reportexportdialog.saveonserver.success'), errorservice.type.SUCCESS);
                        }
                    }, 
                    afterError: function() {
                        $scope.reportExportModel.running = false;
                        $scope.reportExportModel.exportData = undefined;
                    }
                });
            } else {
                $scope.reportExportModel.exportData = {
                    id: GUID.createNew(),
                    url: '?method=' + modalservice.activemodal.exportOptions.exportHandlerKey,
                    format: modalservice.activemodal.exportOptions.format,
                    filename: modalservice.activemodal.exportOptions.filename,
                    reportData: angular.toJson(modalservice.activemodal.exportOptions.reportDataProvider()),
                    loaded: function() {
                        if (modalservice.activemodal != undefined && modalservice.activemodal.reportExportDialog===true) {
                            modalservice.activemodal.close();
                            errorservice.shownotificationcontent($rootScope.getMsg('reportexportdialog.download.success'), errorservice.type.SUCCESS);
                        }
                    }
                };
            }
        } else {
            dataservice.execute(modalservice.activemodal.exportOptions.exportHandlerKey, {
                data: angular.toJson({
                    format: modalservice.activemodal.exportOptions.format,
                    filename: modalservice.activemodal.exportOptions.filename,
                    reportData: modalservice.activemodal.exportOptions.reportDataProvider()
                }),
                alertSelector: '.reportexporterror',
                handleSuccess: function(response) {
                    // asynchronous execution. need to poll the status
                    updateStatus( {
                        report: response.reportKey,
                        format: response.engineFormat,
                        parameter: response.parameter,
                    });
                }, 
                afterError: function() {
                    $scope.reportExportModel.running = false;
                    $scope.reportExportModel.exportData = undefined;
                }
            });
        }
    };
    
    modalservice.activemodal.actions = [{
        label: $rootScope.getMsg('reportexportdialog.action'),
        classname: 'btn-primary',
        action: function() {
            startExport();
        },
        disabled: function() {
            if ($scope.reportExportModel.running) {
                return true;
            }
            if ($scope.reportExportModel.target == 'saveonserver' && ($scope.reportExportModel.saveTarget == undefined || $scope.reportExportModel.saveTarget.length == 0)) {
                return true;
            }
            return false;
        }
    }];
    
    $scope.$watch('reportExportModel.target', function(newValue) {
        if (newValue == 'saveonserver') {
            if ($scope.reportExportModel.saveTarget == undefined || $scope.reportExportModel.saveTarget.length == 0) {
                $scope.openFileChooser();
            }
        }
    });
    
    $scope.openFileChooser = function() {
        let fileFilters = ['*.'+modalservice.activemodal.exportOptions.format];
        if (modalservice.activemodal.exportOptions.fileFilters != undefined && modalservice.activemodal.exportOptions.fileFilters.length>0) {
            fileFilters = modalservice.activemodal.exportOptions.fileFilters;
        }
        filechooser.showSpecificChooser(".reportexportdialog", $scope, modalservice.activemodal.exportOptions.availableFileChooserProtocols, true, false, $scope.reportExportModel.saveTarget, undefined, fileFilters, function (answer, path) {
            if (answer === FILECHOOSER.OK) {
                $scope.reportExportModel.saveTarget = path;
            }
        }, true, (modalservice.activemodal.exportOptions.filename || 'export') + '.' + modalservice.activemodal.exportOptions.format);
    };
    
    $scope.$on('$destroy', function() {
        $timeout.cancel($scope.reportExportModel.statusTimer);
    });
    
    $scope.$on('reportexport.error', function(event, error) {
        $scope.reportExportModel.running = false;
        $scope.reportExportModel.exportData = undefined;
        errorservice.showerrorcontent(error, ".reportexporterror");
    });
    
    if ((modalservice.activemodal.exportOptions.availableFileChooserProtocols||[]).length==0) {
        startExport();
    }
});
