/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.pdf;

import com.inet.error.ErrorCode;
import com.inet.http.utils.MimeTypes;
import com.inet.report.BaseUtils;
import com.inet.report.ReportException;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.renderer.doc.AbstractDocumentWriter;
import com.inet.report.renderer.doc.DocumentMetaData;
import com.inet.report.renderer.doc.Layout;
import com.inet.report.renderer.doc.WriterCapabilities;
import com.inet.report.renderer.pdf.PDFConfig;
import com.inet.report.renderer.pdf.e;
import com.inet.report.renderer.pdf.h;
import com.inet.report.renderer.pdf.i;
import com.inet.report.renderer.pdf.k;
import com.inet.report.renderer.pdf.l;
import com.inet.report.renderer.pdf.m;
import com.inet.report.renderer.pdf.model.aj;
import com.inet.report.renderer.pdf.model.am;
import com.inet.report.renderer.pdf.model.as;
import com.inet.report.renderer.pdf.model.o;
import com.inet.report.renderer.pdf.model.r;
import com.inet.report.renderer.pdf.model.structure.g;
import com.inet.report.renderer.pdf.sec.a;
import com.inet.report.renderer.pdf.sec.b;
import com.inet.report.renderer.pdf.sec.f;
import com.inet.shared.utils.MemoryStream;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PDFDocumentWriter
extends AbstractDocumentWriter {
    public static final String NAVIGATION_OUTLINES = "bookmarks";
    public static final String NAVIGATION_THUMBNAILS = "pages";
    public static final String ALG_TYPE = "algtype";
    public static final String ENCRYPT_METADATA = "encryptmeta";
    private boolean aVf = false;
    private boolean aVg;
    private boolean aVh;
    private Date IV;
    private boolean aVi;
    private MemoryStream CU = null;
    private e aVj;
    private com.inet.report.renderer.pdf.model.m aUg;
    @Nonnull
    private i aVk;
    @Nonnull
    private k aVl;
    private int aVm;
    private h aVn;
    private am aVo;

    public PDFDocumentWriter(PDFConfig config) {
        this.aVj = new e(config);
        this.aUg = this.aVj.GG();
        this.aVk = new i(this.aVj, this.aUg);
        this.aVl = new k(this.aUg.HT(), this.aVk, this.aUg.HW().isReplaceMissingChars());
    }

    @Override
    @Nonnull
    public Layout getLayout() {
        return this.aVk;
    }

    @Override
    @Nonnull
    public WriterCapabilities getCapabilities() {
        return this.aVl;
    }

    @Override
    public void setUserProperties(@Nullable Properties props) {
        props = props != null ? props : new Properties();
        super.setUserProperties(props);
        this.k(props);
        boolean bl2 = Boolean.parseBoolean(props.getProperty("fastwebview"));
        if (bl2) {
            this.aUg.HW().setLinear(bl2);
            this.aVn = new h(this.aUg);
        }
    }

    @Override
    public void setMetaData(@Nonnull DocumentMetaData metaData) {
        super.setMetaData(metaData);
        this.aVj.setMetaData(metaData);
        this.aVg = metaData.isClipboardEnabled();
        this.aVi = metaData.isGroupTreeVisible();
        this.aVh = metaData.isPrintingEnabled();
        this.IV = metaData.getPrintTime();
        this.GK();
        PDFConfig pDFConfig = this.aUg.HW();
        Properties properties = this.getProperties();
        l l2 = FACTUR_X && metaData.getProperty("facturx-level") != null ? l.aWu : l.cS(properties.getProperty("pdfa"));
        if (l2 != null && this.aVf) {
            ErrorCode.throwAny((Throwable)new ReportException("Documents that are encrypted or restrict access to their content (e.g., printing or copying to the clipboard) cannot be exported in PDF/A format.", ReportErrorCode.InvalidArgument.getErrorCodeNumber()));
        }
        pDFConfig.setPdfA(l2);
        m m2 = m.cT(properties.getProperty("pdfua"));
        if (m2 != null && this.aVf) {
            ErrorCode.throwAny((Throwable)new ReportException("Documents that are encrypted or restrict access to their content (e.g., printing or copying to the clipboard) cannot be exported in PDF/UA format.", ReportErrorCode.InvalidArgument.getErrorCodeNumber()));
        }
        pDFConfig.setPdfUA(m2);
        boolean bl2 = pDFConfig.isCreateStructure();
        String string = properties.getProperty("pdftags");
        if ("true".equalsIgnoreCase(string)) {
            bl2 = true;
        } else if ("false".equalsIgnoreCase(string)) {
            bl2 = false;
        }
        if (bl2) {
            g g2 = new g(this.aUg);
            this.aUg.a(g2);
            this.aVk.a(g2);
        }
        this.aUg.HT().dF();
    }

    @Override
    public void setPageLayout(int width, int height, boolean landscape, int topMargin, int leftMargin, int bottomMargin, int rightMargin) throws ReportException {
        super.setPageLayout(width, height, landscape, topMargin, leftMargin, bottomMargin, rightMargin);
        this.aVj.C(width, height, topMargin, leftMargin);
    }

    @Override
    public void startDocument() throws ReportException {
        super.startDocument();
        this.aVj.start();
        this.aVm = 0;
        g g2 = this.aUg.HX();
        if (g2 != null) {
            this.aVj.GH().a(g2.JB());
            DocumentMetaData documentMetaData = this.getMetaData();
            if (documentMetaData != null) {
                Locale locale = documentMetaData.getResourceLocale();
                String string = locale.toLanguageTag();
                this.aVj.GH().dc(string);
            }
        }
    }

    @Override
    public void startPage() throws ReportException {
        boolean bl2;
        super.startPage();
        boolean bl3 = bl2 = this.CU == null;
        if (!bl2) {
            this.ca(false);
        }
        this.aVo = this.aVk.GT();
        this.CU = new MemoryStream();
        if (this.aVn != null) {
            this.aVn.a(this.aVo);
        } else if (bl2) {
            this.aVj.Z(this.CU);
        }
    }

    @Override
    public void endPage() throws ReportException {
        super.endPage();
    }

    private void ca(boolean bl2) throws ReportException {
        if (bl2) {
            this.aVk.GW();
        }
        this.aVk.endPage();
        if (this.aVn == null) {
            this.aVj.c(this.CU, this.getPages().getPageCount() + 1, this.aVm);
            byte[] byArray = this.CU.toByteArray();
            this.getPages().addPage(byArray);
            this.aVm += byArray.length;
            this.aVo.dispose();
        }
        this.CU = null;
    }

    @Override
    public void endDocument() throws ReportException {
        Object object;
        int n2;
        super.endDocument();
        if (this.CU != null) {
            this.ca(true);
        }
        if (this.aVn != null) {
            n2 = this.aVn.a(this.aVj, this.getPages());
        } else {
            object = new MemoryStream();
            this.aVj.aa((MemoryStream)object);
            byte[] byArray = object.toByteArray();
            this.getPages().addPage(byArray);
            n2 = this.aVm + byArray.length;
        }
        object = this.aVk.GV();
        if (object != null) {
            ((as)object).a(this.getPages(), n2);
        }
    }

    private void GK() {
        String string;
        boolean bl2 = true;
        Properties properties = this.getProperties();
        if (properties != null && (string = properties.getProperty(ENCRYPT_METADATA, "true")) != null && string.equalsIgnoreCase("false")) {
            bl2 = false;
        }
        int n2 = a.k(this.aVg, this.aVh);
        String[] stringArray = a.l(properties);
        if (stringArray[0] == null) {
            if (!this.aVg || !this.aVh) {
                this.aVf = true;
                stringArray[0] = "DEFAULT_ALG";
            }
        } else {
            this.aVf = true;
        }
        if (this.aVf) {
            byte[] byArray = a.f(this.IV.getTime());
            b b2 = f.a(stringArray[0], stringArray[1], stringArray[2], n2, bl2, this.IV, byArray);
            this.aVj.a(b2, byArray);
        }
    }

    private void k(@Nonnull Properties properties) {
        String string = properties.getProperty("navview", "");
        if (NAVIGATION_OUTLINES.equals(string) || NAVIGATION_THUMBNAILS.equals(string)) {
            BaseUtils.info("PDF Export navigation type: " + string);
            this.aVj.cQ(string);
        }
    }

    @Override
    public void addAttchment(@Nonnull String fileName, byte @Nonnull [] data, @Nullable String additionalWriterOptions) {
        l l2 = this.aVj.GG().HW().getPdfA();
        if (l2 == null || l2.Hd() > 1) {
            String string;
            com.inet.report.renderer.pdf.model.k k2 = this.aVj.GH();
            aj aj2 = k2.HR();
            String string2 = MimeTypes.getMimeType((String)fileName).split(";")[0];
            o o2 = new o(this.aUg, data, string2, this.IV);
            r.a a2 = null;
            String string3 = string = "factur-x.xml".equals(fileName) ? "Structured electronic invoice data in Factur-X format" : null;
            if (additionalWriterOptions != null) {
                a2 = additionalWriterOptions.equalsIgnoreCase("MINIMUM") || additionalWriterOptions.equalsIgnoreCase("BASIC_WL") ? r.a.baM : r.a.baN;
            }
            r r2 = new r(this.aUg, o2, fileName, string, a2);
            aj2.a(r2);
        }
    }

    @Override
    @Nullable
    public com.inet.report.renderer.doc.i getStructureWriter() {
        return this.aUg.HX();
    }
}

