/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database.weblog;

import com.inet.annotations.InternalApi;
import com.inet.drive.api.DriveEntry;
import com.inet.drive.api.feature.Content;
import com.inet.drive.api.feature.Folder;
import com.inet.permissions.AccessDeniedException;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.config.datasource.DataSourceConfiguration;
import com.inet.report.database.ColumnInfo;
import com.inet.report.database.RelativePathDataFactory;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.database.csvdata.g;
import com.inet.report.plugins.drive.DriveReportPermissionChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class DatabaseWeblog
extends RelativePathDataFactory {
    private static final boolean adI = ServerPluginManager.getInstance().isPluginLoaded("drive");
    @Nonnull
    private static final @Nonnull Function<@Nonnull String, @Nullable String> adJ = string -> {
        int n2 = string.length() - 4;
        if (string.endsWith(".log") && string.lastIndexOf(46, n2 - 1) < 0) {
            return string.substring(0, n2);
        }
        if (string.endsWith(".csv")) {
            return string;
        }
        return null;
    };

    @Override
    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(@Nonnull Datasource ds, String catalog) throws ReportException {
        String string;
        DataSourceConfiguration dataSourceConfiguration = ds.getDataSourceConfiguration();
        if (dataSourceConfiguration != null && DatabaseWeblog.bc(string = dataSourceConfiguration.getProperty("path"))) {
            Object object;
            HashMap<String, TableSourceInfo> hashMap = new HashMap<String, TableSourceInfo>();
            if (adI && (object = a.be(string)) != null) {
                for (DriveEntry driveEntry : ((Folder)object.getFeature(Folder.class)).getChildren()) {
                    String string2;
                    if (!driveEntry.hasFeature(Content.class) || (string2 = adJ.apply(driveEntry.getDislayName())) == null) continue;
                    hashMap.put(string2, new TableSourceInfo(catalog, null, string2, 20));
                }
            }
            if (hashMap.isEmpty()) {
                object = "Table";
                hashMap.put((String)object, new TableSourceInfo(catalog, null, (String)object, 20));
            }
            return hashMap;
        }
        return super.getTableSourceInfos(ds, catalog, adJ);
    }

    private static boolean bc(String string) {
        return string.indexOf(58) > 1;
    }

    @Override
    @Nonnull
    public List<String> getPathNames(@Nonnull Datasource ds, @Nonnull String pathOrFile) {
        if (DatabaseWeblog.bc(pathOrFile)) {
            return Collections.singletonList(pathOrFile);
        }
        return super.getPathNames(ds, pathOrFile);
    }

    @Nonnull
    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN", "URLCONNECTION_SSRF_FD"}, justification="file name generated for the parsed log file")
    private InputStream g(@Nonnull TableSource tableSource) throws Exception {
        Datasource datasource = tableSource.getDatasource();
        Object object = tableSource.getDatabaseIdentifier();
        if (((String)object).indexOf(46) < 0) {
            object = (String)object + ".log";
        }
        Exception exception = null;
        List<String> list = this.getPathNames(datasource);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object2;
            String string = list.get(i2);
            if (DatabaseWeblog.bc(string)) {
                DriveEntry driveEntry;
                object2 = object;
                if (adI && (driveEntry = a.be(string)) != null && (driveEntry = (DriveEntry)((Folder)driveEntry.getFeature(Folder.class)).getChildren().stream().filter(arg_0 -> DatabaseWeblog.a((String)object2, arg_0)).findFirst().orElse(null)) != null && driveEntry.hasFeature(Content.class)) {
                    return ((Content)driveEntry.getFeature(Content.class)).getInputStream();
                }
                try {
                    return this.openConnection(datasource, new URL(string)).getInputStream();
                }
                catch (Exception exception2) {
                    exception = exception2;
                    continue;
                }
            }
            object2 = new File(string, (String)object);
            if (!((File)object2).exists()) continue;
            return new FileInputStream((File)object2);
        }
        if (exception != null) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
        return new FileInputStream(new File(list.get(0), (String)object));
    }

    @Override
    @Nonnull
    public List<ColumnInfo> getColumns(@Nonnull TableSource ts) throws ReportException {
        List<ColumnInfo> list;
        block8: {
            InputStream inputStream = this.g(ts);
            try {
                list = new g(inputStream).getColumns();
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception exception) {
                    throw ReportExceptionFactory.createReportExceptionWithCause(exception);
                }
            }
            inputStream.close();
        }
        return list;
    }

    @Override
    @Nonnull
    public TableData getTableSourceData(@Nonnull TableSource ts) throws ReportException {
        try {
            InputStream inputStream = this.g(ts);
            return new TableData(new g(inputStream).getResultSet());
        }
        catch (Exception exception) {
            throw ReportExceptionFactory.createReportExceptionWithCause(exception);
        }
    }

    @Override
    public boolean getReportDataPerInstance() {
        return true;
    }

    private static /* synthetic */ boolean a(String string, DriveEntry driveEntry) {
        return driveEntry.getDislayName().equals(adJ.apply(string));
    }

    private static class a {
        @Nullable
        public static DriveEntry be(String string) {
            DriveEntry driveEntry;
            URL uRL = null;
            try {
                uRL = new URL(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                driveEntry = DriveReportPermissionChecker.getDriveEntry(uRL);
                if (driveEntry == null) {
                    return null;
                }
            }
            catch (AccessDeniedException | FileNotFoundException throwable) {
                return null;
            }
            if (!driveEntry.hasFeature(Folder.class)) {
                return null;
            }
            return driveEntry;
        }
    }
}

