/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.database;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.report.AbstractValueElement;
import com.inet.report.BaseUtils;
import com.inet.report.Database;
import com.inet.report.DatabaseConfiguration;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.ReportDataHandler;
import com.inet.report.ReportException;
import com.inet.report.TableSource;
import com.inet.report.ac;
import com.inet.report.af;
import com.inet.report.by;
import com.inet.report.database.DataFactory;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.SuppressFBWarnings;

@InternalApi
public class DatabaseUtils {
    private static final ConfigValue<Integer> abk = new ConfigValue(ConfigKey.QUERY_TIMEOUT);

    public static boolean useJdbcDriver(DataFactory factory) {
        return factory instanceof Database;
    }

    @Nonnull
    @SuppressFBWarnings(value={"SQL_INJECTION_JDBC"}, justification="sql is internally created and not used from user input")
    public static final ResultSet executeQuery(Statement st, String sql, Object parameter) throws SQLException {
        int n2;
        if (sql != null && BaseUtils.isInfo()) {
            BaseUtils.info("Execute query:\n" + sql);
        }
        if ((n2 = ((Integer)abk.get()).intValue()) >= 0) {
            try {
                st.setQueryTimeout(n2);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (parameter != null) {
            return ((PreparedStatement)st).executeQuery();
        }
        return st.executeQuery(sql);
    }

    public static void getReportData(Engine engine) throws ReportException {
        by.j(engine).gX().oA();
    }

    @Nonnull
    public static ReportDataHandler getAdHocData(@Nonnull Engine engine) throws ReportException {
        return by.getAdHocData(engine);
    }

    @Nonnull
    public static String getFormattedValue(@Nonnull ReportDataHandler dataHandler, @Nonnull AbstractValueElement el) throws ReportException {
        Object object = dataHandler.getFieldValueByField(true, el.getField());
        return DatabaseUtils.getFormattedValue(el, object);
    }

    @Nonnull
    public static String getFormattedValue(@Nonnull AbstractValueElement el, @Nullable Object value) throws ReportException {
        return ac.a(el, by.D(el), value);
    }

    public static String[] parseSourceName(DatabaseConfiguration config, String sqlSource) {
        int n2 = config.isUseEscapeEverything() ? -1 : sqlSource.lastIndexOf(46);
        String[] stringArray = new String[3];
        if (n2 >= 0) {
            stringArray[2] = sqlSource.substring(n2 + 1);
            sqlSource = sqlSource.substring(0, n2);
        } else {
            stringArray[2] = sqlSource;
            sqlSource = "";
        }
        n2 = sqlSource.lastIndexOf(46);
        if (n2 >= 0) {
            stringArray[1] = sqlSource.substring(n2 + 1);
            sqlSource = sqlSource.substring(0, n2);
        } else {
            stringArray[1] = sqlSource.length() > 0 ? sqlSource : null;
            sqlSource = "";
        }
        stringArray[0] = sqlSource.length() > 0 ? sqlSource : null;
        return stringArray;
    }

    public static String getTableAlias(Datasource datasource, String tableName) throws ReportException {
        return af.getTableAlias(datasource, tableName);
    }

    public static int getTypeIntern(TableSource ts) {
        return af.getTypeIntern(ts);
    }
}

