/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.InternalApi;
import com.inet.report.Area;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.DatabaseField;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.Group;
import com.inet.report.GroupField;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.Section;
import com.inet.report.SpecialField;
import com.inet.report.SummaryField;
import com.inet.report.chart.ChartTitle;
import com.inet.report.chart.a;
import com.inet.report.chart.plot.AbstractPlot;
import com.inet.report.chart.plot.ChartStyle;
import com.inet.report.chart.plot.ContinuousAreaStyle;
import com.inet.report.chart.plot.ContinuousBarStyle;
import com.inet.report.chart.plot.ContinuousLineStyle;
import com.inet.report.i;
import com.inet.report.util.EngineUtils;
import java.awt.Color;
import java.awt.Paint;
import javax.annotation.Nonnull;

@InternalApi
public class DChartUtilities {
    public static String createErrorMessageForCheckSummaryField(Field field, int operation, boolean isFirstField, Chart2 chart, boolean isDate) {
        if (isDate) {
            return i.a(field, operation, chart);
        }
        return i.a(field, operation, isFirstField, chart);
    }

    public static boolean isSecondFieldRequired(int operation) {
        return operation == 10 || operation == 11 || operation == 12;
    }

    public static boolean isNthRequired(int operation) {
        return operation == 15 || operation == 16 || operation == 18 || operation == 14;
    }

    public static String generateLocalizedSummaryFieldName(Field field, int operation, int nth, int index, boolean isPercent) {
        return DChartUtilities.generateLocalizedSummaryFieldName(DChartUtilities.getFieldName(field), operation, nth, index, isPercent);
    }

    @Nonnull
    public static String generateLocalizedSummaryFieldName(String fieldName, int operation, int nth, int index, boolean isPercent) {
        StringBuilder stringBuilder = new StringBuilder();
        if (operation != 20) {
            stringBuilder.append(DChartUtilities.a(operation, nth, isPercent));
            stringBuilder.append(" ").append(EngineUtils.CHART_MSG.getMsg("Sum_Separator", new Object[0])).append(" ");
        }
        stringBuilder.append(fieldName);
        if (index != 0) {
            stringBuilder.append(" #");
            stringBuilder.append(index);
        }
        return stringBuilder.toString();
    }

    public static String getFieldName(Field field) {
        if (field instanceof DatabaseField) {
            return ((DatabaseField)field).getColumnLabel();
        }
        return field.getRefName();
    }

    public static String getLocalizedSumName(int operation) {
        return DChartUtilities.a(operation, -1, false);
    }

    private static String a(int n2, int n3, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (bl2) {
            stringBuilder.append(EngineUtils.CHART_MSG.getMsg("PercentOf", new Object[0])).append(' ');
        }
        String string = SummaryField.getOperationName(n2);
        if (DChartUtilities.isNthRequired(n2)) {
            if (n3 < 0) {
                stringBuilder.append(EngineUtils.CHART_MSG.getMsg(string, new Object[]{"x"}));
            } else {
                stringBuilder.append(EngineUtils.CHART_MSG.getMsg(string, new Object[]{n3}));
            }
        } else {
            stringBuilder.append(EngineUtils.CHART_MSG.getMsg(string, new Object[0]));
        }
        return stringBuilder.toString();
    }

    public static String createErrorMessageForCheckGroup(Field field, ChartStyle style, Chart2 chart, int groupIndex) {
        if (field instanceof SummaryField || field instanceof SpecialField || field instanceof GroupField) {
            return EngineUtils.CHART_MSG.getMsg("NotSupportedGroupFieldType", new Object[0]);
        }
        int n2 = field.getValueType();
        if (n2 == -1) {
            return EngineUtils.CHART_MSG.getMsg("UnknownFieldType", new Object[]{field.getRefName()});
        }
        if (groupIndex == 0) {
            if (style.equals(ContinuousAreaStyle.AREA_DATE) || style.equals(ContinuousBarStyle.BAR_DATE) || style.equals(ContinuousLineStyle.LINE_DATE)) {
                if (n2 != 9 && n2 != 10 && n2 != 15) {
                    return EngineUtils.CHART_MSG.getMsg("ChartSupportsDateOnly", new Object[0]);
                }
            } else if ((style.equals(ContinuousAreaStyle.AREA_NUMBER) || style.equals(ContinuousBarStyle.BAR_NUMBER) || style.equals(ContinuousLineStyle.LINE_NUMBER)) && n2 != 6 && n2 != 7) {
                return EngineUtils.CHART_MSG.getMsg("ChartSupportsNumberOnly", new Object[0]);
            }
        }
        return "";
    }

    public static final Paint[] getDefaultColorSequence() {
        return AbstractPlot.DEFAULT_COLOR_SEQUENCE;
    }

    public static final Paint[] getDefaultBlackAndWhiteColorSequence() {
        Paint[] paintArray = new Color[]{new Color(10, 10, 10), Color.lightGray, Color.gray, new Color(220, 220, 220), Color.darkGray, new Color(150, 150, 150), new Color(75, 75, 75), new Color(125, 125, 125), new Color(195, 195, 195), Color.white};
        return paintArray;
    }

    public static final Paint[] getOldChartColorSequence() {
        Paint[] paintArray = new Color[]{Color.blue, Color.red, Color.yellow, Color.green, Color.cyan, Color.magenta, new Color(128, 64, 0), Color.lightGray, new Color(10, 200, 10), Color.orange, new Color(170, 80, 180), new Color(180, 180, 80), new Color(64, 128, 128), new Color(220, 40, 90), new Color(10, 10, 10), Color.pink, new Color(128, 0, 128), new Color(50, 190, 200), Color.gray, Color.white, new Color(105, 150, 100), new Color(10, 10, 200), new Color(220, 220, 30), new Color(240, 15, 160), new Color(0, 170, 255), new Color(250, 160, 10), new Color(255, 100, 0), new Color(10, 250, 160), new Color(100, 170, 170), new Color(180, 90, 80)};
        return paintArray;
    }

    public static final Paint[] getDefaultRedGradientColorSequence() {
        Paint[] paintArray = new Color[]{new Color(179, 58, 58), new Color(183, 59, 59), new Color(187, 60, 60), new Color(191, 62, 62), new Color(195, 63, 63), new Color(199, 65, 65), new Color(203, 66, 66), new Color(207, 67, 67), new Color(211, 69, 69), new Color(215, 70, 70), new Color(219, 72, 72), new Color(223, 73, 73), new Color(227, 75, 75), new Color(231, 76, 76), new Color(235, 77, 77), new Color(239, 79, 79), new Color(243, 80, 80), new Color(247, 82, 82), new Color(251, 83, 83), new Color(255, 85, 85)};
        return paintArray;
    }

    public static final Paint[] getDefaultGreenGradientColorSequence() {
        Paint[] paintArray = new Color[]{new Color(58, 179, 58), new Color(59, 183, 59), new Color(60, 187, 60), new Color(62, 191, 62), new Color(63, 195, 63), new Color(65, 199, 65), new Color(66, 203, 66), new Color(67, 207, 67), new Color(69, 211, 69), new Color(70, 215, 70), new Color(72, 219, 72), new Color(73, 223, 73), new Color(75, 227, 75), new Color(76, 231, 76), new Color(77, 235, 77), new Color(79, 239, 79), new Color(80, 243, 80), new Color(82, 247, 82), new Color(83, 251, 83), new Color(85, 255, 85)};
        return paintArray;
    }

    public static final Paint[] getDefaultBlueGradientColorSequence() {
        Paint[] paintArray = new Color[]{new Color(58, 58, 179), new Color(59, 59, 183), new Color(60, 60, 187), new Color(62, 62, 191), new Color(63, 63, 195), new Color(65, 65, 199), new Color(66, 66, 203), new Color(67, 67, 207), new Color(69, 69, 211), new Color(70, 70, 215), new Color(72, 72, 219), new Color(73, 73, 223), new Color(75, 75, 227), new Color(76, 76, 231), new Color(77, 77, 235), new Color(79, 79, 239), new Color(80, 80, 243), new Color(82, 82, 247), new Color(83, 83, 251), new Color(85, 85, 255)};
        return paintArray;
    }

    public static final Paint[] getDefaultRBGGradientColorSequence() {
        Paint[] paintArray = new Color[]{new Color(179, 58, 58), new Color(154, 58, 82), new Color(130, 58, 106), new Color(106, 58, 130), new Color(82, 58, 154), new Color(58, 58, 179), new Color(58, 82, 154), new Color(58, 106, 130), new Color(58, 130, 106), new Color(58, 154, 82), new Color(58, 179, 58), new Color(82, 154, 58), new Color(106, 130, 58), new Color(130, 106, 58), new Color(154, 82, 58)};
        return paintArray;
    }

    public static final Paint[] getDefaultFireGradientColorSequence() {
        Paint[] paintArray = new Color[]{new Color(0, 0, 0), new Color(22, 0, 0), new Color(44, 0, 0), new Color(66, 0, 0), new Color(88, 0, 0), new Color(110, 0, 0), new Color(132, 0, 0), new Color(154, 0, 0), new Color(180, 0, 0), new Color(190, 8, 0), new Color(200, 16, 0), new Color(210, 24, 0), new Color(220, 32, 0), new Color(230, 40, 0), new Color(240, 48, 0), new Color(255, 60, 0), new Color(255, 87, 0), new Color(255, 114, 0), new Color(255, 141, 0), new Color(255, 168, 0), new Color(255, 195, 0), new Color(255, 222, 0), new Color(255, 255, 0), new Color(255, 255, 36), new Color(255, 255, 72), new Color(255, 255, 108), new Color(255, 255, 144), new Color(255, 255, 180), new Color(255, 255, 216), new Color(255, 255, 255)};
        return paintArray;
    }

    public static final Paint[] getDefaultInetColorSequence() {
        Paint[] paintArray = new Color[]{new Color(120, 141, 190), new Color(230, 183, 94), new Color(160, 175, 220), new Color(247, 211, 146)};
        return paintArray;
    }

    public static void setAutoTitle(ChartTitle title, String value) {
        a.setAutoTitle(title, value);
    }

    public static String getTitle(ChartTitle chartTitle) {
        return a.getTitle(chartTitle);
    }

    public static Field getCurrentField(Chart2 chart) {
        PromptField promptField = null;
        try {
            promptField = new PromptField(chart.getEngine().bB);
            promptField.setPromptType(6);
            promptField.setAllowMultipleValues(false);
            promptField.setDiscreteOrRangeType(0);
            promptField.setPromptValue(new Double(-1.0));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return promptField;
    }

    public static String getGroupNameSubtitle(Chart2 chart, boolean isSample) {
        Object object;
        block7: {
            Section section = (Section)chart.getParent();
            Group group = ((Area)section.getParent()).getGroup();
            object = "";
            Engine engine = chart.getEngine();
            if (group.dt() == 30 && group.getField() != null) {
                if (isSample) {
                    if (group.getField() instanceof DatabaseField) {
                        object = "@";
                    }
                    object = String.valueOf(object) + DChartUtilities.getFieldName(group.getField());
                } else {
                    try {
                        object = engine.bB.gN().getFieldValueByField(false, group.getGroupNameField());
                    }
                    catch (ReportException reportException) {
                        if (!BaseUtils.isDebug()) break block7;
                        BaseUtils.printStackTrace(reportException);
                    }
                }
            }
        }
        if (object == null) {
            return "";
        }
        return object.toString();
    }

    public static boolean isInGroupHeaderFooter(Chart2 chart) {
        Section section = (Section)chart.getParent();
        int n2 = section.getType();
        return n2 == 5 || n2 == 6;
    }
}

