/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.time;

import com.inet.jfree.data.time.RegularTimePeriod;
import com.inet.jfree.data.time.TimeSeries;
import com.inet.jfree.data.time.TimeSeriesDataItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class HistogramTimeSeries
extends TimeSeries {
    public HistogramTimeSeries(TimeSeries original, HashMap<Integer, String> groupNameValues) {
        super(original.getKey(), original.getTimePeriodClass());
        this.data = this.getData(original.getItems(), groupNameValues);
    }

    private List<TimeSeriesDataItem> getData(List<TimeSeriesDataItem> original, HashMap<Integer, String> groupNameValues) {
        if (original.size() == 0) {
            return original;
        }
        ArrayList<TimeSeriesDataItem> result = new ArrayList<TimeSeriesDataItem>();
        HashMap<Integer, String> newValues = new HashMap<Integer, String>();
        for (int i = 0; i < original.size(); ++i) {
            TimeSeriesDataItem originalItem = original.get(i);
            if (i > 0) {
                RegularTimePeriod previous = originalItem.getPeriod().previous();
                if (original.get(i - 1).getPeriod().compareTo(previous) < 0) {
                    result.add(new TimeSeriesDataItem(previous, 0.0));
                }
            }
            String value = groupNameValues.get(i);
            newValues.put(result.size(), value);
            result.add(originalItem);
            if (i >= original.size() - 1) continue;
            RegularTimePeriod next = originalItem.getPeriod().next();
            if (original.get(i + 1).getPeriod().compareTo(next) <= 0) continue;
            result.add(new TimeSeriesDataItem(next, 0.0));
        }
        groupNameValues.clear();
        groupNameValues.putAll(newValues);
        return result;
    }
}

