/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer.category;

import com.inet.jfree.chart.renderer.AbstractRenderer;
import com.inet.jfree.chart.renderer.GradientPainter;
import com.inet.jfree.chart.renderer.category.AreaRenderer;
import com.inet.jfree.chart.renderer.category.Face;
import com.inet.jfree.chart.renderer.category.StandardAreaPainter;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.jfree.ui.RectangleEdge;

public class GradientAreaPainter
extends StandardAreaPainter {
    private boolean horizontal;
    private GradientPainter painter = new GradientPainter();

    public GradientAreaPainter(boolean horizontal) {
        this.horizontal = horizontal;
    }

    @Override
    public void paintArea(Graphics2D g2, AbstractRenderer renderer, int rowCount, int column, Shape[] areas, GeneralPath[] separators, RectangleEdge location, boolean drawOutline, boolean drawLastOutline) {
        for (int i = 0; i < rowCount; ++i) {
            Paint paint = renderer.getItemPaint(i, column);
            Shape area = areas[i];
            Point2D.Float start = null;
            Point2D.Float end = null;
            Rectangle bounds = areas[i].getBounds();
            if (this.horizontal) {
                if (location == RectangleEdge.TOP || location == RectangleEdge.BOTTOM) {
                    start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMaxY());
                    end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
                } else if (location == RectangleEdge.LEFT || location == RectangleEdge.RIGHT) {
                    start = new Point2D.Float((float)bounds.getMaxX(), (float)bounds.getMinY());
                    end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
                }
            } else if (location == RectangleEdge.TOP || location == RectangleEdge.BOTTOM) {
                start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
                end = new Point2D.Float((float)bounds.getMaxX(), (float)bounds.getMinY());
            } else if (location == RectangleEdge.LEFT || location == RectangleEdge.RIGHT) {
                start = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMaxY());
                end = new Point2D.Float((float)bounds.getMinX(), (float)bounds.getMinY());
            }
            boolean success = this.painter.paintGradient(g2, paint, area, start, end, GradientPainter.ColorOfGradient.gradient);
            if (!success) continue;
            this.painter.drawOutline(g2, renderer, i, column, separators[i], drawOutline);
        }
        if (drawLastOutline && drawOutline) {
            this.painter.drawOutline(g2, renderer, rowCount, column, separators[rowCount], true);
        }
    }

    @Override
    public void paintSide(Graphics2D g2, AreaRenderer renderer, int row, int column, Shape shape, Paint paint, RectangleEdge location, Face face) {
        boolean success = this.painter.paintGradient(g2, paint, shape, null, null, GradientPainter.ColorOfGradient.secondColor);
        if (success) {
            this.painter.drawOutline(g2, renderer, row, column, shape, renderer.isOutline());
        }
    }
}

