/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.jsonrpc;

import com.inet.annotations.JsonData;
import com.inet.report.jsonrpc.JsonRpcResult;
import com.inet.report.jsonrpc.JsonRpcResultError;
import com.inet.report.jsonrpc.JsonRpcResultValue;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@JsonData
public class JsonRpcRequest {
    private String jsonrpc;
    private String method;
    private Object params;
    private Object id;
    private static final AtomicInteger COUNTER = new AtomicInteger();

    JsonRpcRequest() {
    }

    public JsonRpcRequest(String method, Object params) {
        this.jsonrpc = "2.0";
        this.method = method;
        this.params = params;
        this.id = COUNTER.getAndIncrement();
    }

    public static Field[] getDeclaredFields() {
        try {
            Field[] fieldArray = new Field[4];
            int n2 = 0;
            fieldArray[n2++] = JsonRpcRequest.class.getDeclaredField("jsonrpc");
            fieldArray[n2++] = JsonRpcRequest.class.getDeclaredField("method");
            fieldArray[n2++] = JsonRpcRequest.class.getDeclaredField("params");
            fieldArray[n2++] = JsonRpcRequest.class.getDeclaredField("id");
            return fieldArray;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalStateException(noSuchFieldException);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public Object getParams() {
        return this.params;
    }

    public Object getParam(int idx) {
        if (this.params != null) {
            return ((List)this.params).get(idx);
        }
        return null;
    }

    public Object getParam(String name) {
        if (this.params != null) {
            return ((Map)this.params).get(name);
        }
        return null;
    }

    public JsonRpcResult result(Object data) {
        return new JsonRpcResultValue(this, data);
    }

    public JsonRpcResult error(String error) {
        return this.error(0, error);
    }

    public JsonRpcResult error(int errorCode, String errorMsg) {
        return new JsonRpcResultError(this, errorCode, errorMsg);
    }

    public Object getId() {
        return this.id;
    }
}

