/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.Datasource;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.TableSource;
import com.inet.report.database.BaseDataFactory;
import com.inet.report.database.SimpleResultSet;
import com.inet.report.database.TableData;
import com.inet.report.database.TableSourceInfo;
import com.inet.report.i18n.ReportErrorCode;
import java.sql.ResultSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public class DatabaseSetData
extends BaseDataFactory {
    private final HashMap<String, ResultSet> lg = new HashMap();

    @Override
    @Nonnull
    public Map<String, TableSourceInfo> getTableSourceInfos(Datasource ds, String catalog) throws ReportException {
        return new HashMap<String, TableSourceInfo>();
    }

    @Override
    public TableData getTableSourceData(TableSource ts) throws ReportException {
        String string = ts.getDatabaseIdentifier();
        ResultSet resultSet = this.lg.get(string);
        if (resultSet != null) {
            return new TableData(resultSet);
        }
        throw ReportExceptionFactory.createReportException(ReportErrorCode.DataNotSetForTable, string);
    }

    public void setData(String tableAlias, ResultSet rs) {
        this.lg.put(tableAlias, rs);
    }

    public void setData(String tableAlias, String[] columns, Object[][] rows) {
        SimpleResultSet simpleResultSet = new SimpleResultSet(columns);
        simpleResultSet.getAllRows().addAll(Arrays.asList(rows));
        this.setData(tableAlias, simpleResultSet);
    }
}

