/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.report.CrossTab;
import com.inet.report.CrossTabBody;
import com.inet.report.CrossTabHeader;
import com.inet.report.Element;
import com.inet.report.Field;
import com.inet.report.FieldElement;
import com.inet.report.FormulaField;
import com.inet.report.PropertyConstants;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.m;
import com.inet.report.y;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

@PublicApi
public class CrossTabHeaderList
implements Serializable {
    private final CrossTab jc;
    @Nonnull
    private final List<CrossTabHeader> jP;
    private boolean jQ;
    private FormulaField jR;
    private FormulaField jS;
    private boolean jT;
    private boolean jU;
    private int jV;

    CrossTabHeaderList(CrossTab crossTab) {
        this.jc = crossTab;
        this.jP = new ArrayList<CrossTabHeader>();
    }

    public void remove(int index) throws ReportException {
        if (index == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.CantDropGrandTotal, new Object[0]);
        }
        CrossTabHeader crossTabHeader = this.jP.get(index);
        this.jc.getBody().a(crossTabHeader);
        this.jP.remove(index);
        crossTabHeader.resetReferences();
        this.jc.aS().be();
        this.jc.aS().bf();
    }

    @Nonnull
    public CrossTabHeader add(@Nonnull Field field) {
        Element element;
        int n2;
        int n3;
        CrossTabHeader crossTabHeader = new CrossTabHeader(this.jc, this, field);
        this.jP.add(crossTabHeader);
        CrossTabBody crossTabBody = this.jc.getBody();
        boolean bl2 = this.jc.getOptions().getSummaryHorizontal();
        int n4 = Math.max(1, crossTabBody.getSummaryFieldsCount());
        if (this.isRow()) {
            crossTabBody.b(crossTabHeader);
            n3 = 2036;
            n2 = 230;
            if (this.size() == 2) {
                element = this.jP.get(0).getText();
                n3 = Math.max(n3, element.getWidth());
            }
            if (!bl2) {
                n2 *= n4;
            }
        } else {
            crossTabBody.c(crossTabHeader);
            n3 = 810;
            n2 = 230;
            if (this.size() == 2) {
                element = this.jP.get(0).getText();
                n2 = Math.max(n2, element.getHeight());
            }
            if (bl2) {
                n3 *= n4;
            }
        }
        if ((element = crossTabHeader.getFieldElement()) == null) {
            element = crossTabHeader.getText();
        }
        element.setWidth(n3);
        element.setHeight(n2);
        return crossTabHeader;
    }

    public void move(int from, int to) throws ReportException {
        Element element;
        int n2;
        if (from == 0 || to == 0) {
            throw ReportExceptionFactory.createReportException(ReportErrorCode.CantDropGrandTotal, new Object[0]);
        }
        this.jP.get(to);
        boolean bl2 = this.isRow();
        int[] nArray = new int[this.jP.size()];
        for (n2 = 1; n2 < nArray.length; ++n2) {
            element = this.jP.get(n2).bu();
            nArray[n2] = bl2 ? element.jk : element.width;
        }
        this.jP.add(to, this.jP.remove(from));
        for (n2 = 1; n2 < nArray.length; ++n2) {
            element = this.jP.get(n2).bu();
            if (bl2) {
                element.jk = nArray[n2];
                continue;
            }
            element.width = nArray[n2];
        }
        this.jc.aS().be();
        this.jc.aS().bf();
    }

    @Nonnull
    @Deprecated
    CrossTabHeader bz() {
        CrossTabHeader crossTabHeader = new CrossTabHeader(this.jc, this, null);
        this.jP.add(crossTabHeader);
        return crossTabHeader;
    }

    @Nonnull
    public CrossTabHeader get(int index) {
        return this.jP.get(index);
    }

    public boolean isRow() {
        return this == this.jc.getRows();
    }

    public int size() {
        return this.jP.size();
    }

    @Nonnull
    public CrossTabHeader getGrandTotal() {
        return this.jP.get(0);
    }

    public boolean getTotalOnStart() {
        return this.jQ;
    }

    public void setTotalOnStart(boolean value) {
        this.jQ = value;
    }

    public void setTotalOnStartFormula(FormulaField newFormula) {
        String string;
        int n2;
        FormulaField.d(this.jR);
        if (this.isRow()) {
            n2 = 465;
            string = "rowTotalOnLeft";
        } else {
            n2 = 466;
            string = "columnTotalOnTop";
        }
        this.jR = this.jc.a(newFormula, n2, string);
    }

    public FormulaField getTotalOnStartFormula() {
        return this.jR;
    }

    public boolean getSuppressEmptyLines() {
        return this.jT;
    }

    public void setSuppressEmptyLines(boolean suppressEmptyLines) {
        this.jT = suppressEmptyLines;
    }

    public void setSuppressEmptyLinesFormula(FormulaField newFormula) {
        String string;
        int n2;
        FormulaField.d(this.jS);
        if (this.isRow()) {
            n2 = 455;
            string = "suppressEmptyRows";
        } else {
            n2 = 454;
            string = "suppressEmptyColumns";
        }
        this.jS = this.jc.a(newFormula, n2, string);
    }

    public FormulaField getSuppressEmptyLinesFormula() {
        return this.jS;
    }

    public boolean getIndentLabel() {
        return this.jU;
    }

    public void setIndentLabel(boolean indentLabel) {
        if (this.jU != indentLabel) {
            this.jU = indentLabel;
            this.jc.aS().be();
            this.jc.aS().bf();
        }
    }

    public int getIndentLabelSize() {
        return this.jV;
    }

    public void setIndentLabelSize(int indentLabelSize) {
        if (indentLabelSize < 0) {
            throw y.a("indentLabelSize", indentLabelSize, null);
        }
        if (this.jV != indentLabelSize) {
            this.jV = indentLabelSize;
            if (this.isRow()) {
                this.jc.aS().be();
            } else {
                this.jc.aS().bf();
            }
        }
    }

    void setReferences() {
        for (int i2 = 0; i2 < this.jP.size(); ++i2) {
            this.jP.get(i2).setReferences();
        }
    }

    void resetReferences() {
        for (int i2 = 0; i2 < this.jP.size(); ++i2) {
            this.jP.get(i2).resetReferences();
        }
    }

    void b(@Nonnull List<FormulaField> list) {
        for (int i2 = 0; i2 < this.jP.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.jP.get(i2);
            crossTabHeader.b(list);
        }
        list.add(PropertyConstants.setPropertyDefault(this.jS, this.getSuppressEmptyLines()));
        list.add(PropertyConstants.setPropertyDefault(this.jR, this.getTotalOnStart()));
    }

    int g(CrossTabHeader crossTabHeader) {
        return this.jP.indexOf(crossTabHeader);
    }

    int b(Element element) {
        for (int i2 = 0; i2 < this.jP.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.jP.get(i2);
            if (crossTabHeader.getFieldElement() == element) {
                return i2;
            }
            for (int i3 = crossTabHeader.by() - 1; i3 >= 0; --i3) {
                if (crossTabHeader.getText(i3) != element) continue;
                return i2;
            }
        }
        return -1;
    }

    void ba() {
        m m2 = this.jc.aS();
        for (int i2 = 0; i2 < this.jP.size(); ++i2) {
            CrossTabHeader crossTabHeader = this.jP.get(i2);
            for (int i3 = crossTabHeader.by() - 1; i3 >= 0; --i3) {
                crossTabHeader.getText(i3).addPropertyChangeListener(m2);
            }
            FieldElement fieldElement = crossTabHeader.getFieldElement();
            if (fieldElement == null) continue;
            fieldElement.addPropertyChangeListener(m2);
        }
    }
}

