/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.data.general;

import com.inet.jfree.data.general.Dataset;
import com.inet.jfree.data.general.DatasetChangeEvent;
import com.inet.jfree.data.general.DatasetChangeListener;
import com.inet.jfree.data.general.DatasetGroup;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;

public abstract class AbstractDataset
implements Dataset,
Cloneable,
Serializable,
ObjectInputValidation {
    private static final long serialVersionUID = 1918768939869230744L;
    private DatasetGroup group;
    private transient EventListenerList listenerList;
    private ArrayList<String> itemLabels = new ArrayList();

    protected AbstractDataset() {
        this.group = new DatasetGroup();
        this.listenerList = new EventListenerList();
    }

    @Override
    public DatasetGroup getGroup() {
        return this.group;
    }

    @Override
    public void setGroup(DatasetGroup group) {
        if (group == null) {
            throw new IllegalArgumentException("Null 'group' argument.");
        }
        this.group = group;
    }

    @Override
    public void addChangeListener(DatasetChangeListener listener) {
        this.listenerList.add(DatasetChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(DatasetChangeListener listener) {
        this.listenerList.remove(DatasetChangeListener.class, listener);
    }

    public boolean hasListener(EventListener listener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(listener);
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    protected void notifyListeners(DatasetChangeEvent event) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != DatasetChangeListener.class) continue;
            ((DatasetChangeListener)listeners[i + 1]).datasetChanged(event);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractDataset clone = (AbstractDataset)super.clone();
        clone.listenerList = new EventListenerList();
        return clone;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.listenerList = new EventListenerList();
        stream.registerValidation(this, 10);
    }

    @Override
    public void validateObject() throws InvalidObjectException {
        this.fireDatasetChanged();
    }

    public void addItemLabel(String label) {
        this.itemLabels.add(label);
    }

    public void addItemLabel(String label, int row) {
        this.itemLabels.add(row, label);
    }

    public String getItemLabel(int row) {
        if (row >= this.itemLabels.size()) {
            return "";
        }
        return this.itemLabels.get(row);
    }
}

