/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.renderer;

import com.inet.jfree.chart.renderer.AbstractRenderer;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Point2D;

public class GradientPainter {
    public boolean paintColor(Graphics2D g2, Color color, Shape shape) {
        if (color.getAlpha() == 0) {
            return false;
        }
        g2.setPaint(color);
        g2.fill(shape);
        return true;
    }

    public boolean paintGradient(Graphics2D g2, Paint paint, Shape shape, Point2D start, Point2D end, ColorOfGradient colorOfGradient) {
        Color c0 = null;
        Color c1 = null;
        if (paint instanceof Color) {
            return this.paintColor(g2, (Color)paint, shape);
        }
        if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            c0 = gp.getColor1();
            c1 = gp.getColor2();
        } else {
            c0 = Color.blue;
            c1 = Color.blue.brighter();
        }
        if (c0.getAlpha() == 0) {
            return false;
        }
        if (colorOfGradient.equals((Object)ColorOfGradient.firstColor)) {
            return this.paintColor(g2, c0, shape);
        }
        if (colorOfGradient.equals((Object)ColorOfGradient.secondColor)) {
            return this.paintColor(g2, c1, shape);
        }
        paint = new GradientPaint(start, c0, end, c1);
        g2.setPaint(paint);
        g2.fill(shape);
        return true;
    }

    public void drawOutline(Graphics2D g2, AbstractRenderer renderer, int row, int column, Shape shape, boolean condition) {
        if (condition) {
            Stroke stroke = renderer.getItemOutlineStroke(row, column);
            Paint paint = renderer.getItemOutlinePaint(row, column);
            if (stroke != null && paint != null) {
                g2.setStroke(stroke);
                g2.setPaint(paint);
                g2.draw(shape);
            }
        }
    }

    public static enum ColorOfGradient {
        gradient,
        firstColor,
        secondColor;

    }
}

