/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.InternalApi;
import com.inet.viewer.PromptValue;
import com.inet.viewer.h;
import com.inet.viewer.i18n.a;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;

@InternalApi
public class RealtimeValidationPopup
implements ActionListener,
FocusListener,
DocumentListener,
PopupMenuListener {
    private JComponent bCI;
    private int bCC;
    private boolean bCJ;
    private Timer bCK;
    private Popup bCL;
    private JLabel bCM;
    private JPanel bCN;
    private boolean bCO;
    private Point bCP;
    private JComboBox bCQ;
    private boolean bCR;
    private boolean bCS;
    private Class bCT;
    private Constructor bCU;
    private Class[] bCV = new Class[]{String.class};
    private Color bCW;
    public static final Color POPUP_BGCOLOR_NORMAL = new Color(255, 255, 225);
    public static final Color POPUP_BGCOLOR_ERROR = new Color(1.0f, 0.7f, 0.7f);
    public static final Color POPUP_BGCOLOR_INCOMPLETE = new Color(255, 227, 119);
    public static final Color LAYOUT_ERROR_BACKGROUND = new Color(1.0f, 0.7f, 0.7f);
    private Format bCX;

    private RealtimeValidationPopup(int promptType) {
        this.bCC = promptType;
        this.bCM = new JLabel();
        this.bCN = new JPanel();
        this.bCN.setOpaque(true);
        this.bCN.add(this.bCM);
        this.bCN.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                RealtimeValidationPopup.this.hidePopup();
                e2.consume();
            }
        });
        this.bCN.setBorder(BorderFactory.createBevelBorder(0, Color.GRAY, Color.BLACK));
        this.bCK = new Timer(5000, this);
    }

    public RealtimeValidationPopup(JTextComponent textcomponent, JComboBox surroundingBox, int promptType, boolean isUSformatted) {
        this(promptType);
        this.initFormats();
        if (this.bCX == null) {
            return;
        }
        this.bCR = isUSformatted;
        textcomponent.getDocument().addDocumentListener(this);
        if (surroundingBox != null) {
            surroundingBox.addActionListener(this);
            surroundingBox.addPopupMenuListener(this);
            this.bCQ = surroundingBox;
        }
        this.bCI = textcomponent;
        this.bCI.addFocusListener(this);
        this.bCW = this.bCI.getBackground();
    }

    private void initFormats() {
        this.bCX = null;
        switch (this.bCC % 128) {
            case 6: 
            case 7: {
                this.bCX = this.bCR ? NumberFormat.getInstance(Locale.US) : PromptValue.NUMBERFORMAT;
                break;
            }
            case 9: {
                this.bCX = this.bCR ? DateFormat.getDateInstance(3, Locale.US) : PromptValue.DATEFORMAT;
                break;
            }
            case 15: {
                this.bCX = this.bCR ? DateFormat.getDateTimeInstance(3, 2, Locale.US) : PromptValue.DATETIMEFORMAT;
                break;
            }
            case 10: {
                this.bCX = this.bCR ? DateFormat.getTimeInstance(2, Locale.US) : PromptValue.TIMEFORMAT;
                break;
            }
            default: {
                return;
            }
        }
    }

    private void Pq() {
        if (this.bCI instanceof JPasswordField) {
            return;
        }
        Object object = this.getValue();
        String string = object.toString();
        if (!this.bCI.isEnabled() || !this.bCI.isShowing() || object.toString().length() == 0 || this.bCI instanceof JComboBox && ((JComboBox)this.bCI).isPopupVisible() || (this.bCC % 128 == 6 || this.bCC % 128 == 7) && string.equals("-")) {
            if (!this.bCI.isEnabled()) {
                this.bCI.setBackground(UIManager.getDefaults().getColor("TextField.disabledBackground"));
            } else {
                this.bCI.setBackground(POPUP_BGCOLOR_NORMAL);
            }
            this.hidePopup();
            return;
        }
        try {
            Object object2;
            if (object instanceof PromptValue) {
                if (((PromptValue)object).isOnlyDescription()) {
                    this.hidePopup();
                    return;
                }
                object2 = ((PromptValue)object).getDescription();
                if (object2 != null && ((String)object2).length() > 0) {
                    string = ((PromptValue)object).getValueString();
                }
            }
            object2 = null;
            object2 = this.bCX.parseObject(string);
            String string2 = this.getFormatedText(object2);
            if (this.bCS && this.bCT != null) {
                if (this.bCT == Object.class) {
                    this.bCT = String.class;
                }
                this.bCU = this.bCT.getConstructor(this.bCV);
                this.bCU.newInstance(string);
            }
            this.bCJ = false;
            if (string2.equals(string)) {
                this.hidePopup();
            } else {
                Point point = this.bCI.getLocationOnScreen();
                point.y += this.bCI.getHeight();
                this.a(string2, POPUP_BGCOLOR_NORMAL, point);
            }
            this.bCI.invalidate();
            this.bCI.setBackground(POPUP_BGCOLOR_NORMAL);
        }
        catch (Exception exception) {
            if (this.a(this.bCX, string)) {
                this.showIncompletePopup();
            }
            this.showErrorPopup();
        }
    }

    public String getFormatedText(Object parsedObject) {
        return this.bCX.format(parsedObject);
    }

    private boolean a(Format format, String string) {
        boolean bl2 = false;
        if (format instanceof h) {
            format = ((h)format).On();
        }
        if (format instanceof SimpleDateFormat) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)format;
            String string2 = simpleDateFormat.toPattern();
            SimpleDateFormat simpleDateFormat2 = null;
            String string3 = string2;
            block2: for (int i2 = 1; i2 <= string2.length(); ++i2) {
                for (int i3 = 0; i3 <= string2.length() - i2; ++i3) {
                    string3 = string2.substring(i3, i3 + i2);
                    simpleDateFormat2 = new SimpleDateFormat(string3);
                    try {
                        Date date = simpleDateFormat2.parse(string);
                        String string4 = simpleDateFormat2.format(date);
                        String string5 = string.replaceAll("0", "");
                        String string6 = string4.replaceAll("0", "");
                        if (!string.equals(string4) && !string5.equals(string4) && !string.equals(string6) && !string5.equals(string6)) continue;
                        bl2 = true;
                        continue block2;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return bl2;
    }

    public void showErrorPopup() {
        Point point = this.bCI.getLocationOnScreen();
        point.y += this.bCI.getHeight();
        this.bCJ = true;
        Object object = a.getMsg("prompt.invalid_input");
        object = (String)object + this.Pr();
        this.a((String)object, POPUP_BGCOLOR_ERROR, point);
        this.bCI.setBackground(LAYOUT_ERROR_BACKGROUND);
        this.bCI.invalidate();
    }

    public void showIncompletePopup() {
        Point point = this.bCI.getLocationOnScreen();
        point.y += this.bCI.getHeight();
        this.bCJ = true;
        Object object = a.getMsg("prompt.incomplete_input");
        object = (String)object + this.Pr();
        this.a((String)object, POPUP_BGCOLOR_INCOMPLETE, point);
        this.bCI.setBackground(POPUP_BGCOLOR_INCOMPLETE);
        this.bCI.invalidate();
    }

    private String Pr() {
        Format format = switch (this.bCC) {
            case 9 -> PromptValue.DATEFORMAT;
            case 15 -> PromptValue.DATETIMEFORMAT;
            case 10 -> PromptValue.TIMEFORMAT;
            default -> null;
        };
        if (format instanceof SimpleDateFormat) {
            return a.getMsg("prompt.format_must_be", ((SimpleDateFormat)format).toPattern());
        }
        if (this.bCC == 6 || this.bCC == 7) {
            return a.getMsg("prompt.expected_number");
        }
        return "";
    }

    private void a(String string, Color color, Point point) {
        string = this.ee(string);
        this.bCM.setText(string);
        this.bCN.setBackground(color);
        if (!this.bCO) {
            this.bCP = point;
        } else {
            point = this.bCP;
        }
        if (this.bCL != null) {
            this.hidePopup();
        }
        this.bCL = PopupFactory.getSharedInstance().getPopup(this.bCI, this.bCN, point.x, point.y);
        this.bCL.show();
        this.bCO = true;
        if (this.bCK.isRunning()) {
            this.bCK.restart();
        } else {
            this.bCK.start();
        }
    }

    private String ee(String object) {
        object = this.bCJ ? "<html>" + (String)object + "</html>" : a.getMsg("prompt.interpreted_as", object);
        return object;
    }

    private Object getValue() {
        if (this.bCI instanceof JPasswordField) {
            return new String(((JPasswordField)this.bCI).getPassword());
        }
        if (this.bCI instanceof JTextComponent) {
            String string;
            String string2 = ((JTextComponent)this.bCI).getText();
            if (this.bCQ == null) {
                return string2;
            }
            Object object = this.bCQ.getSelectedItem();
            if (this.bCI != null && this.bCQ.isEditable() && object != null && !(string = object.toString()).equals(string2)) {
                return string2;
            }
            if (object == null) {
                object = "";
            }
            return object;
        }
        if (this.bCI instanceof JComboBox) {
            return ((JComboBox)this.bCI).getSelectedItem();
        }
        return null;
    }

    public void hidePopup() {
        if (this.bCL != null) {
            this.bCL.hide();
        }
        this.bCO = false;
        if (this.bCK.isRunning()) {
            this.bCK.stop();
        }
    }

    public void setCheckClassType(boolean checkClassType, Class classtype) {
        this.bCS = checkClassType;
        this.bCT = classtype;
    }

    public void setPromptType(int promptType) {
        this.bCC = promptType;
        this.initFormats();
    }

    public void unregister() {
        if (this.bCI == null) {
            return;
        }
        if (this.bCI instanceof JTextField) {
            ((JTextField)this.bCI).getDocument().removeDocumentListener(this);
        } else if (this.bCI instanceof JComboBox) {
            ((JComboBox)this.bCI).removeActionListener(this);
            ((JComboBox)this.bCI).removePopupMenuListener(this);
        }
        this.bCI.removeFocusListener(this);
        if (this.bCQ != null) {
            this.bCQ.removeActionListener(this);
            this.bCQ.removePopupMenuListener(this);
        }
        this.bCI.setBackground(this.bCW);
    }

    public boolean isPopupError() {
        return this.bCJ;
    }

    @Override
    public void changedUpdate(DocumentEvent e2) {
        this.Pq();
    }

    @Override
    public void insertUpdate(DocumentEvent e2) {
        this.Pq();
    }

    @Override
    public void removeUpdate(DocumentEvent e2) {
        this.Pq();
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        if (e2.getSource() instanceof JComboBox) {
            this.Pq();
        } else {
            this.hidePopup();
        }
    }

    @Override
    public void focusGained(FocusEvent e2) {
        this.Pq();
    }

    @Override
    public void focusLost(FocusEvent e2) {
        this.hidePopup();
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent e2) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent e2) {
        this.hidePopup();
    }

    public void setFormat(Format format) {
        this.bCX = format;
    }
}

