/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.formula;

import com.inet.report.DatabaseField;
import com.inet.report.Datasource;
import com.inet.report.Field;
import com.inet.report.SQLField;
import com.inet.report.SummaryField;
import com.inet.report.TableSource;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class FieldFilter {
    private Set<TableSource> aie;

    public FieldFilter() {
    }

    public FieldFilter(@Nullable List<TableSource> allowedTables) {
        this.aie = allowedTables != null ? new HashSet<TableSource>(allowedTables) : null;
    }

    public FieldFilter(Datasource ds) {
        if (ds != null) {
            this.aie = new HashSet<TableSource>();
            for (int i2 = 0; i2 < ds.getTableSourceCount(); ++i2) {
                this.aie.add(ds.getTableSource(i2));
            }
        }
    }

    public boolean accepts(Field f2) {
        if (this.aie == null || f2 == null) {
            return true;
        }
        if (f2 instanceof DatabaseField) {
            return this.aie.contains(((DatabaseField)f2).getTableSource());
        }
        if (f2 instanceof SummaryField) {
            SummaryField summaryField = (SummaryField)f2;
            return this.accepts(summaryField.getField()) && this.accepts(summaryField.getField2nd()) && this.accepts(summaryField.getChangeField()) && this.accepts(summaryField.getResetField());
        }
        if (f2 instanceof SQLField) {
            SQLField sQLField = (SQLField)f2;
            return this.accepts(sQLField.getField());
        }
        return true;
    }
}

