/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.config;

import com.inet.annotations.PublicApi;
import com.inet.config.ConfigKeyParser;
import com.inet.config.LicenseInfo;
import com.inet.config.LicenseManager;
import com.inet.plugin.ServerPluginManager;
import com.inet.report.BaseUtils;
import java.util.Objects;
import javax.annotation.Nonnull;

@PublicApi
public final class LicenseKeyInfo {
    private static LicenseKeyInfo ZH;
    private LicenseInfo ZI;

    public LicenseKeyInfo(String licenseKey) {
        if (licenseKey == null) {
            this.ZI = ConfigKeyParser.getCurrent();
            return;
        }
        this.ZI = new ConfigKeyParser().getLicenseInfo(licenseKey).getCurrent();
    }

    LicenseKeyInfo(@Nonnull LicenseInfo license) {
        Objects.requireNonNull(license);
        this.ZI = license;
    }

    @Nonnull
    public static final LicenseKeyInfo getCurrent() {
        if (ZH == null) {
            try {
                if (ZH == null && ServerPluginManager.getInstance().getState() != ServerPluginManager.ServerPluginManagerState.INIT) {
                    Class.forName("com.inet.report.Engine").getConstructor(String.class).newInstance("java");
                }
            }
            catch (Throwable throwable) {
                BaseUtils.error(throwable);
            }
            ZH = new LicenseKeyInfo(ConfigKeyParser.getCurrent());
        }
        return ZH;
    }

    public final boolean isPlus() {
        return this.ZI.isValid() && Boolean.parseBoolean((String)this.ZI.getAttributes().get("crplus"));
    }

    public final String getLicenseText() {
        return this.ZI.getDisplayName();
    }

    public final String getLicensee() {
        return this.ZI.getLicensee();
    }

    public final boolean isValid() {
        return this.ZI.isValid();
    }

    public final String getErrorMessage() {
        return this.ZI.getErrorMessage();
    }

    public final boolean hasExpiredDate() {
        return this.ZI.hasExpiredDate();
    }

    public final String getWaterMark() {
        return (String)this.ZI.getAttributes().get("watermark");
    }

    public final boolean isSite() {
        return this.ZI.isValid() && this.ZI.getAttributes().get("ip") == null;
    }

    public final LicenseInfo getLicenseInfo() {
        return this.ZI;
    }

    static {
        LicenseManager.getInstance().addLicenseListener(licenseInfo -> {
            ZH = new LicenseKeyInfo(licenseInfo);
        });
    }
}

