clearreportsApp.directive("reportexport", function ($timeout) {
    return {
        template:   '<form ng-attr-action="{{exportModel.url}}" ng-attr-target="{{exportModel.id}}" method="POST" style="display:none">' +
                    '    <input ng-if="timezone" type="text" name="timezone" ng-model="timezone">' +
                    '    <input ng-if="exportModel.format" type="text" name="format" ng-model="exportModel.format">' +
                    '    <input ng-if="exportModel.filename" type="text" name="filename" ng-model="exportModel.filename">' +
                    '    <input ng-if="exportModel.reportData" type="text" name="reportdata" ng-model="exportModel.reportData">' +
                    '    <input type="submit">' +
                    '</form>' +
                    '<iframe src="" style="display:none"></iframe>',
        link: function (scope, element, attrs) {
            
            scope.timezone = moment.tz.guess(); // The timezone is cached on momentjs side.
            
            $timeout(function() {
                let timeoutGuard = undefined;
                let iframe = element.find('iframe');
                iframe[0].contentWindow.name = scope.exportModel.id;
                iframe.on('load', function(event) {
                    clearInterval(intVal);
                    $timeout.cancel(timeoutGuard);
                    scope.$apply(function() {
                        let messageTag = event.target.contentDocument.getElementById('error-message');
                        if (messageTag != undefined) {
                            scope.$emit('reportexport.error', Util.getHtmlEncoded(messageTag.innerText));
                            return;
                        }
                        scope.$emit('reportexport.error', Util.fastHtml2text(event.target.contentDocument.body.textContent));
                    });
                });

                let setCookie = function(cname, cvalue, exdays) {
                    let d = new Date();
                    d.setTime(d.getTime() + (exdays*24*60*60*1000));
                    let expires = "expires="+ d.toUTCString();
                    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
                };
                
                let getCookie = function(cname) {
                    var name = cname + "="; // var instead of let because of jshint :-(
                    let decodedCookie = decodeURIComponent(document.cookie);
                    let ca = decodedCookie.split(';');
                    for(let i = 0; i <ca.length; i++) {
                        let c = ca[i];
                        while (c.charAt(0) == ' ') {
                            c = c.substring(1);
                        }
                        if (c.indexOf(name) == 0) {
                            return c.substring(name.length, c.length);
                        }
                    }
                    return "";
                };
                
                var intVal = setInterval(function() {
                    if (getCookie('i-net-content-download') == 'true') {
                        setCookie('i-net-content-download', '', 1);
                        clearInterval(intVal);
                        $timeout.cancel(timeoutGuard);
                        $timeout(function() {
                            if (scope.exportModel.loaded != undefined) {
                                scope.exportModel.loaded();
                            }
                        });
                    }
                }, 100);
                
                setCookie('i-net-content-download', '', 1);
                timeoutGuard = $timeout(function() {
                    clearInterval(intVal);
                    $timeout.cancel(timeoutGuard);
                    if (scope.exportModel.loaded != undefined) {
                        scope.exportModel.loaded();
                    }
                }, 15000);
                element.find('form').submit();
                
            });
        },
        scope: {
            exportModel: "="
        },
        restrict : 'E'
    };
});
