/*
 * Decompiled with CFR 0.152.
 */
package com.inet.jfree.chart.plot;

import com.inet.jfree.chart.axis.NumberTick;
import com.inet.jfree.chart.axis.ValueAxis;
import com.inet.jfree.chart.plot.PlotRenderingInfo;
import com.inet.jfree.chart.plot.PolarPlot;
import com.inet.jfree.chart.renderer.PolarItemRenderer;
import com.inet.jfree.data.general.DatasetUtilities;
import com.inet.jfree.data.xy.PolarXYDataset;
import com.inet.jfree.data.xy.XYDataset;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.jfree.ui.TextAnchor;

public class InetPolarPlot
extends PolarPlot {
    private List<NumberTick> angleTicks;

    public InetPolarPlot() {
        this(null, null, null);
    }

    public InetPolarPlot(PolarXYDataset dataset, ValueAxis radiusAxis, PolarItemRenderer renderer) {
        super(dataset, radiusAxis, renderer);
        this.angleTicks = dataset != null ? dataset.getAngleTicks() : new ArrayList<NumberTick>();
        if (this.angleTicks.isEmpty()) {
            this.angleTicks = new ArrayList<NumberTick>();
            this.angleTicks.add(new NumberTick(new Double(0.0), "0", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
            this.angleTicks.add(new NumberTick(new Double(45.0), "45", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
            this.angleTicks.add(new NumberTick(new Double(90.0), "90", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
            this.angleTicks.add(new NumberTick(new Double(135.0), "135", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
            this.angleTicks.add(new NumberTick(new Double(180.0), "180", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
            this.angleTicks.add(new NumberTick(new Double(225.0), "225", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
            this.angleTicks.add(new NumberTick(new Double(270.0), "270", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
            this.angleTicks.add(new NumberTick(new Double(315.0), "315", TextAnchor.CENTER, TextAnchor.CENTER, 0.0));
        }
    }

    @Override
    public List getAngleTicks() {
        return this.angleTicks;
    }

    @Override
    protected void render(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info) {
        if (!DatasetUtilities.isEmptyOrNull(super.getDataset())) {
            int seriesCount = super.getDataset().getSeriesCount();
            for (int series = seriesCount - 1; series >= 0; --series) {
                super.getRenderer().drawSeries(g2, dataArea, info, this, super.getDataset(), series);
            }
        } else {
            this.drawNoDataMessage(g2, dataArea);
        }
    }

    @Override
    public void setDataset(XYDataset dataset) {
        super.setDataset(dataset);
        if (dataset instanceof PolarXYDataset) {
            this.angleTicks = ((PolarXYDataset)dataset).getAngleTicks();
        }
    }

    @Override
    protected List refreshAngleTicks() {
        return this.getAngleTicks();
    }
}

