/*
 * Decompiled with CFR 0.152.
 */
package com.inet.viewer;

import com.inet.annotations.PublicApi;
import com.inet.viewer.ActionPool;
import com.inet.viewer.CustomPromptEditor;
import com.inet.viewer.ProgressPool;
import com.inet.viewer.PromptData;
import com.inet.viewer.RenderData;
import com.inet.viewer.ReportView;
import com.inet.viewer.ReportViewChangeListener;
import com.inet.viewer.ReportViewer;
import com.inet.viewer.SwingReportView;
import com.inet.viewer.SwingToolBar;
import com.inet.viewer.SwingViewerContext;
import com.inet.viewer.ToolBar;
import com.inet.viewer.ViewerContext;
import com.inet.viewer.ViewerException;
import com.inet.viewer.ViewerUtils;
import com.inet.viewer.l;
import com.inet.viewer.n;
import com.inet.viewer.props.DefaultSetting;
import com.inet.viewer.y;
import java.applet.Applet;
import java.awt.AWTPermission;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

@PublicApi
public class SwingReportViewer
extends JPanel
implements ReportViewer {
    private ChangeListener bJe = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent evt) {
            JTabbedPane jTabbedPane = (JTabbedPane)evt.getSource();
            int n2 = jTabbedPane.getSelectedIndex();
            if (n2 == -1) {
                return;
            }
            SwingReportViewer.this.setCurrentReportView((SwingReportView)jTabbedPane.getComponentAt(n2));
            SwingReportViewer.this.repaint();
        }
    };
    private int bJf;
    public static final int VERSION_MAJOR = 25;
    public static final int VERSION_MINOR = 10;
    private com.inet.viewer.props.a bJg = new com.inet.viewer.props.b();
    static final Dimension bFt = new Dimension(640, 480);
    private ArrayList bJh = new ArrayList();
    private boolean bsL = true;
    private boolean bJi = true;
    private boolean bJj;
    private SwingReportView bJk;
    private y bJl;
    private ActionPool bJm;
    private ArrayList bJn = new ArrayList();
    private SwingToolBar bJo;
    private Map bJp = new HashMap();
    private ProgressPool bJq = new ProgressPool();
    private PropertyChangeSupport bCp = new PropertyChangeSupport(this);
    private String bJr;
    private ViewerContext byI;
    public static final int PRINTER_USE_DEFAULT_FORMAT_IF_SIMILAR = 0;
    public static final int PRINTER_USE_REPORT_FORMAT = 1;
    private Throwable bJs;
    private final HashMap bGJ = new HashMap();
    private Boolean bJt = null;

    public SwingReportViewer() {
        this((ViewerContext)null);
    }

    public SwingReportViewer(ViewerContext context) {
        this.bJm = new ActionPool(this);
        this.bJo = new SwingToolBar(this);
        if (context == null) {
            context = new SwingViewerContext(this);
        }
        this.setViewerContext(context);
        SwingUtilities.invokeLater(new Runnable(){
            private final String[] bJv = new String[]{"notfound.gif", "rootnode.gif", "groupnode_magnifier.gif", "groupnodeexp.gif", "groupnode.gif"};
            private int MZ;

            @Override
            public void run() {
                ViewerUtils.getImageIcon(this.bJv[this.MZ++]);
                if (this.MZ < this.bJv.length) {
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        ViewerUtils.logClientData(SwingReportViewer.getVersion());
        this.setRequestFocusEnabled(true);
        this.setFocusable(true);
        if (this.getLayout() instanceof FlowLayout) {
            this.setLayout(new BorderLayout());
        }
        this.add((Component)this.bJo, "North");
        this.setPreferredSize(bFt);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.Rz();
            }
        };
        abstractAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, ViewerUtils.RY()));
        this.a(abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.RA();
            }
        };
        abstractAction2.putValue("AcceleratorKey", KeyStroke.getKeyStroke(84, ViewerUtils.RY() | 0x40));
        this.a(abstractAction2);
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SwingReportViewer.this.bJj = !SwingReportViewer.this.bJj;
                for (int i2 = 0; i2 < SwingReportViewer.this.bJh.size(); ++i2) {
                    ((b)SwingReportViewer.this.bJh.get((int)i2)).bJw.Ru().db(SwingReportViewer.this.bJj);
                }
            }
        };
        abstractAction3.putValue("AcceleratorKey", KeyStroke.getKeyStroke(77, ViewerUtils.RY() | 0x40));
        this.a(abstractAction3);
        AbstractAction abstractAction4 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SwingReportViewer.this.bJl != null && SwingReportViewer.this.bJl.indexOfComponent(SwingReportViewer.this.bJk) > 0) {
                    SwingReportViewer.this.closeReportView(SwingReportViewer.this.bJk);
                }
            }
        };
        abstractAction4.putValue("AcceleratorKey", KeyStroke.getKeyStroke(115, ViewerUtils.RY()));
        this.a(abstractAction4);
        ActionPool actionPool = this.getActionPool();
        this.a(actionPool.getViewerAction(17));
        this.a(actionPool.getViewerAction(16));
        this.a(actionPool.getViewerAction(15));
        this.a(actionPool.getViewerAction(13));
        this.a(actionPool.getViewerAction(14));
        this.a(actionPool.getViewerAction(18));
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new AWTPermission("accessClipboard"));
            }
        }
        catch (SecurityException securityException) {
            actionPool.getViewerAction(1).setEnabled(false);
            actionPool.getViewerAction(2).setEnabled(false);
        }
    }

    @Override
    public void setViewerContext(ViewerContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        if (context instanceof SwingViewerContext) {
            ((SwingViewerContext)context).setViewer(this);
        }
        this.byI = context;
    }

    @Override
    public ViewerContext getViewerContext() {
        return this.byI;
    }

    private void a(Action action) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        this.getInputMap(2).put(keyStroke, action);
        this.getActionMap().put(action, action);
    }

    @Override
    public void closeAllReportViews() {
        ViewerUtils.debug("closing and disposing of all ReportViews...");
        for (b b2 : this.bJh) {
            b2.bJw.unregister();
        }
        this.bJh.clear();
        this.setCurrentReportView(null);
        this.removeAll();
        this.add((Component)this.bJo, "North");
        this.bJl = new y(this);
        this.add((Component)this.bJl, "Center");
        this.repaint();
    }

    @Override
    public void closeReportView(int index) {
        Component component = ((b)this.bJh.get((int)index)).bJw.getComponent();
        this.closeReportView((SwingReportView)component);
    }

    @Override
    public void closeReportView(ReportView view) {
        if (view == null) {
            throw new IllegalArgumentException();
        }
        if (this.bJl == null) {
            return;
        }
        int n2 = this.bJl.indexOfComponent((SwingReportView)view);
        this.bJl.removeTabAt(n2);
        this.bJh.remove(n2);
        this.setCurrentReportView((SwingReportView)this.bJl.getSelectedComponent());
        ((SwingReportView)view).unregister();
    }

    @Override
    public ToolBar getToolBar() {
        return this.bJo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportView addNewReportView(RenderData data, boolean isClosable) {
        if (data == null) {
            throw new IllegalArgumentException("RenderData is null");
        }
        ReportView reportView = this.c(data);
        if (reportView != null) {
            return reportView;
        }
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            ReportView reportView2 = this.createReportView(data);
            this.addReportView(reportView2, isClosable);
            return reportView2;
        }
    }

    @Override
    public void addReportView(ReportView repView, boolean isClosable) {
        if (repView == null) {
            throw new IllegalArgumentException();
        }
        RenderData renderData = repView.getReportData();
        this.a(repView, renderData, isClosable);
    }

    @Override
    public ReportView addNewReportView(RenderData data) {
        boolean bl2 = this.bJh.size() > 0;
        return this.addNewReportView(data, bl2);
    }

    public ReportView createReportView(RenderData data) {
        SwingReportView swingReportView = new SwingReportView(this, this.bJg, this.getViewerContext());
        swingReportView.init(data);
        return swingReportView;
    }

    @Override
    public void addReportView(ReportView repView) {
        boolean bl2 = this.bJh.size() > 0;
        this.addReportView(repView, bl2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(ReportView reportView, RenderData renderData, boolean bl2) {
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            boolean bl3;
            this.setPreferredSize(null);
            this.requestFocusInWindow();
            if (this.c(renderData) != null) {
                return;
            }
            this.bJh.add(new b((SwingReportView)reportView, renderData.getReportLocation(), renderData.getProperties()));
            this.setCurrentReportView(reportView);
            boolean bl4 = bl3 = this.bJl == null;
            if (bl3) {
                this.bJl = new y(this);
                this.add((Component)this.bJl, "Center");
                this.bJl.addChangeListener(this.bJe);
            }
            String string = SwingReportViewer.eg(renderData.getReportTitle());
            this.bJl.a(string, reportView.getComponent(), bl2);
            this.bJl.setSelectedComponent(reportView.getComponent());
            PropertyChangeListener[] propertyChangeListenerArray = this.bCp.getPropertyChangeListeners();
            for (int i2 = 0; i2 < propertyChangeListenerArray.length; ++i2) {
                reportView.getStatusBar().addStateChangeListener(propertyChangeListenerArray[i2]);
            }
        }
    }

    private ReportView c(RenderData renderData) {
        Iterator iterator = this.bJh.iterator();
        if (this.bJl != null) {
            while (iterator.hasNext()) {
                b b2 = (b)iterator.next();
                if (!b2.My.equals(renderData.getReportLocation()) || !"adhoc".equals(b2.My) && !b2.JO.equals(renderData.getProperties())) continue;
                this.bJl.setSelectedComponent(b2.bJw.getComponent());
                return b2.bJw;
            }
        }
        return null;
    }

    private static String eg(String string) {
        if (string != null && string.length() > 20) {
            String string2 = string.substring(0, 17) + "...";
            return string2;
        }
        return string;
    }

    @Override
    public void removeNotify() {
        if (this.bJl != null) {
            this.bJl.removeChangeListener(this.bJe);
        }
        for (b b2 : this.bJh) {
            b2.bJw.unregister();
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        Object object2;
        if (this.bJl != null) {
            this.bJl.addChangeListener(this.bJe);
        }
        if (this.getRootPane() == null) {
            throw new ViewerException("The top window must be a Swing component - you cannot add the Viewer to a Frame or Dialog, use a JFrame or JDialog instead.");
        }
        for (Object object2 : this.bJh) {
            ((b)object2).bJw.OD();
        }
        object2 = SwingReportViewer.a(this);
        if (object2 instanceof Applet && ((Applet)object2).getAppletContext() != null) {
            this.setViewerContext(new com.inet.viewer.b(this.getViewerContext(), (Applet)object2));
        } else if (this.getViewerContext() == null) {
            this.setViewerContext(new SwingViewerContext(this));
        }
        super.addNotify();
    }

    private static Component a(Component component) {
        Container container = component.getParent();
        if (!(container == null || container instanceof Applet && ((Applet)container).getAppletContext() != null)) {
            return SwingReportViewer.a(container);
        }
        return container;
    }

    void b(n n2, RenderData renderData) {
        RenderData renderData2;
        if (n2 != null && (renderData2 = l.a(n2, renderData)) != null) {
            this.addNewReportView(renderData2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReportView getCurrentReportView() {
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            return this.bJk;
        }
    }

    @Override
    public void setCurrentReportView(ReportView rv) {
        int n2;
        if (rv != null && this.bJl != null && (n2 = this.bJl.indexOfComponent(rv.getComponent())) != -1 && n2 != this.bJl.getSelectedIndex()) {
            this.bJl.removeChangeListener(this.bJe);
            this.bJl.setSelectedComponent(rv.getComponent());
            this.bJl.addChangeListener(this.bJe);
            this.repaint();
        }
        this.bJk = (SwingReportView)rv;
        this.Ry();
    }

    @Override
    public void setHasGroupTree(boolean hasGroupTree) {
        this.a(hasGroupTree ? Boolean.TRUE : Boolean.FALSE);
        this.cZ(hasGroupTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cZ(boolean bl2) {
        this.bsL = bl2;
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            for (int i2 = 0; i2 < this.bJh.size(); ++i2) {
                ((b)this.bJh.get((int)i2)).bJw.setHasGroupTree(bl2);
            }
        }
    }

    @Override
    public boolean hasGroupTree() {
        return this.bsL;
    }

    @Override
    public void setHasStatusBar(boolean hasStatusBar) {
        this.da(hasStatusBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void da(boolean bl2) {
        this.bJi = bl2;
        SwingReportViewer swingReportViewer = this;
        synchronized (swingReportViewer) {
            for (int i2 = 0; i2 < this.bJh.size(); ++i2) {
                ((b)this.bJh.get((int)i2)).bJw.cW(bl2);
            }
        }
    }

    @Override
    public boolean hasStatusBar() {
        return this.bJi;
    }

    boolean Rx() {
        return this.bJj;
    }

    public static int getMajorVersion() {
        return 25;
    }

    public static int getMinorVersion() {
        return 10;
    }

    public static String getVersionSuffix() {
        String string = "";
        return string;
    }

    public static String getVersion() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(25);
        stringBuffer.append(".");
        stringBuffer.append(10);
        stringBuffer.append(".");
        stringBuffer.append("217");
        stringBuffer.append(SwingReportViewer.getVersionSuffix());
        return stringBuffer.toString();
    }

    public ActionPool getActionPool() {
        return this.bJm;
    }

    void d(Throwable throwable) {
        this.bJs = throwable;
    }

    public Throwable getLastError() {
        return this.bJs;
    }

    @Override
    public Component getComponent() {
        return this;
    }

    private void Ry() {
        for (int i2 = 0; i2 < this.bJn.size(); ++i2) {
            ((ReportViewChangeListener)this.bJn.get(i2)).reportViewChanged(this.bJk);
        }
    }

    @Override
    public void addReportViewChangeListener(ReportViewChangeListener rvcl) {
        if (rvcl == null) {
            throw new IllegalArgumentException();
        }
        this.bJn.add(rvcl);
    }

    @Override
    public void removeReportViewChangeListener(ReportViewChangeListener rvcl) {
        if (rvcl == null) {
            throw new IllegalArgumentException();
        }
        this.bJn.remove(rvcl);
    }

    public static PrintStream getLoggingStream() {
        return ViewerUtils.getLogStream();
    }

    public static void setLoggingStream(PrintStream stream) {
        ViewerUtils.setLogStream(stream);
    }

    void a(SwingReportView swingReportView, String string) {
        int n2;
        if (this.bJl != null && (n2 = this.bJl.indexOfComponent(swingReportView)) != -1) {
            String string2 = SwingReportViewer.eg(string);
            this.bJl.setTitleAt(n2, string2);
            if (!string.equals(string2)) {
                this.bJl.setToolTipTextAt(n2, string);
            }
            this.bJl.revalidate();
        }
    }

    @Override
    public ReportView getReportView(int i2) {
        return ((b)this.bJh.get((int)i2)).bJw;
    }

    @Override
    public int getReportViewCount() {
        return this.bJh.size();
    }

    @Override
    public void addStateChangeListener(PropertyChangeListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException();
        }
        this.bCp.addPropertyChangeListener(l2);
        for (int i2 = 0; i2 < this.getReportViewCount(); ++i2) {
            this.getReportView(i2).getStatusBar().addStateChangeListener(l2);
        }
        this.getProgressPool().addStateChangeListener(l2);
    }

    @Override
    public void removeStateChangeListener(PropertyChangeListener l2) {
        if (l2 == null) {
            throw new IllegalArgumentException();
        }
        this.bCp.removePropertyChangeListener(l2);
        for (int i2 = 0; i2 < this.getReportViewCount(); ++i2) {
            this.getReportView(i2).getStatusBar().removeStateChangeListener(l2);
        }
        this.getProgressPool().addStateChangeListener(l2);
    }

    @Override
    public ProgressPool getProgressPool() {
        return this.bJq;
    }

    public String getDefaultExportDirectory() {
        return this.RB();
    }

    public void setDefaultExportDirectory(String directory) {
        this.eh(directory);
    }

    private void Rz() {
        if (this.bJl != null) {
            int n2 = this.bJl.indexOfComponent(this.bJk);
            SwingReportView swingReportView = (SwingReportView)this.bJl.getComponentAt((n2 + 1) % this.bJl.getTabCount());
            this.bJl.setSelectedComponent(swingReportView);
            this.setCurrentReportView(swingReportView);
        }
    }

    private void RA() {
        if (this.bJl != null) {
            int n2 = this.bJl.indexOfComponent(this.bJk);
            if (n2 == 0) {
                n2 = this.bJl.getTabCount();
            }
            SwingReportView swingReportView = (SwingReportView)this.bJl.getComponentAt((n2 - 1) % this.bJl.getTabCount());
            this.bJl.setSelectedComponent(swingReportView);
            this.setCurrentReportView(swingReportView);
        }
    }

    void showError(Throwable th, Object source) {
        this.d(th);
        this.getViewerContext().showError(th, source);
    }

    @Override
    public void setCustomPromptEditor(String promptName, int valueType, CustomPromptEditor editor) {
        promptName = promptName.toLowerCase();
        if (editor == null) {
            this.bJp.remove(new a(promptName, valueType));
        } else {
            this.bJp.put(new a(promptName, valueType), editor);
        }
    }

    CustomPromptEditor z(String string, int n2) {
        CustomPromptEditor customPromptEditor = (CustomPromptEditor)this.bJp.get(new a(string.toLowerCase(), n2));
        if (customPromptEditor != null) {
            return customPromptEditor;
        }
        return (CustomPromptEditor)this.bJp.get(new a(string.toLowerCase(), -1));
    }

    void eh(String string) {
        this.bJr = string;
    }

    String RB() {
        return this.bJr;
    }

    HashMap RC() {
        return this.bGJ;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void c(PromptData[] promptDataArray) {
        HashMap hashMap = this.bGJ;
        synchronized (hashMap) {
            for (int i2 = 0; i2 < promptDataArray.length; ++i2) {
                String string = promptDataArray[i2].getName();
                if (string == null) continue;
                this.bGJ.put(string.toLowerCase(), promptDataArray[i2].getPromptValueObject());
            }
        }
    }

    public void setPrinterDefaultFormatHandling(int printerDefaultFormatHandling) {
        if (printerDefaultFormatHandling != 0 && printerDefaultFormatHandling != 1) {
            throw new IllegalArgumentException("parameter must be either PRINTER_USE_DEFAULT_FORMAT_IF_SIMILAR or PRINTER_USE_REPORT_FORMAT!");
        }
        this.bJf = printerDefaultFormatHandling;
    }

    public int getPrinterDefaultFormatHandling() {
        return this.bJf;
    }

    void a(Boolean bl2) {
        this.bJt = bl2;
    }

    Boolean RD() {
        return this.bJt;
    }

    public DefaultSetting getDefaultSetting(DefaultSetting.a key) {
        return this.bJg.a(key);
    }

    public void setDefaultSetting(DefaultSetting.a key, DefaultSetting value) {
        this.bJg.a(key, value);
    }

    private static class b {
        private SwingReportView bJw;
        private String My;
        private Properties JO;

        private b(SwingReportView swingReportView, String string, Properties properties) {
            this.bJw = swingReportView;
            this.My = string;
            this.JO = properties;
        }

        public boolean equals(Object obj) {
            return this.bJw.equals(obj) || super.equals(obj);
        }
    }

    private static class a {
        private final String aXc;
        private final int btx;

        private a(String string, int n2) {
            this.aXc = string;
            this.btx = n2;
        }

        public boolean equals(Object obj) {
            return obj instanceof a && ((a)obj).btx == this.btx && (((a)obj).aXc == null && this.aXc == null || ((a)obj).aXc.equals(this.aXc));
        }

        public int hashCode() {
            return this.aXc.hashCode() + this.btx * 17;
        }
    }
}

