/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.webapi.reporting;

import com.inet.http.ClientMessageException;
import com.inet.logging.LogManager;
import com.inet.plugin.webapi.api.handler.RequestHandler;
import com.inet.report.Engine;
import com.inet.report.Fields;
import com.inet.report.PromptField;
import com.inet.report.ReportException;
import com.inet.report.webapi.ReportingWebAPIExtension;
import com.inet.report.webapi.reporting.ReportingPromptInfoResponseEntry;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@Tag(name="Reporting", description="Report prompt operations")
public class b
extends RequestHandler<Void, List<ReportingPromptInfoResponseEntry>> {
    public b() {
        super(new String[]{"prompts"});
    }

    public String getHelpPageKey() {
        return "webapi.reporting.report.prompts";
    }

    @Operation(summary="Get report prompts", description="Retrieves a list of all prompt fields defined in a report file", responses={@ApiResponse(responseCode="200", description="Prompt fields retrieved successfully"), @ApiResponse(responseCode="400", description="Report parameter not defined or invalid"), @ApiResponse(responseCode="500", description="Error reading report file")})
    @Parameter(description="The report that should be rendered", in=ParameterIn.QUERY, name="report", required=true)
    public List<ReportingPromptInfoResponseEntry> b(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Void void_, boolean bl2) throws IOException {
        String string = httpServletRequest.getParameter("report");
        if (string == null || string.length() == 0) {
            throw new ClientMessageException(ReportingWebAPIExtension.LANG.getMsg("webapi.reporting.parameterNotDefined", new Object[]{"report"}));
        }
        try {
            Engine engine = new Engine("java");
            engine.setReportFile(string);
            ArrayList<ReportingPromptInfoResponseEntry> arrayList = new ArrayList<ReportingPromptInfoResponseEntry>();
            this.a(engine, arrayList, -1);
            for (int i2 = 0; i2 < engine.getSubReportCount(); ++i2) {
                this.a(engine.getSubReport(i2), arrayList, i2);
            }
            return arrayList;
        }
        catch (ReportException reportException) {
            LogManager.getApplicationLogger().error((Throwable)reportException);
            throw new ClientMessageException(ReportingWebAPIExtension.LANG.getMsg("webapi.reporting.reportFileError", new Object[]{string, reportException.getMessage()}));
        }
    }

    private void a(Engine engine, List<ReportingPromptInfoResponseEntry> list, int n2) throws ReportException {
        Fields fields = engine.getFields();
        int n3 = fields.getPromptFieldsCount();
        for (int i2 = 0; i2 < n3; ++i2) {
            PromptField promptField = fields.getPromptField(i2);
            Object object = promptField.getName();
            if (n2 >= 0) {
                object = "#" + (n2 + 1) + "#" + (String)object;
            }
            list.add(new ReportingPromptInfoResponseEntry((String)object, promptField.getValueType()));
        }
    }

    @Operation(summary="Get report prompts", description="Retrieves a list of all prompt fields defined in a report file", responses={@ApiResponse(responseCode="200", description="Prompt fields retrieved successfully"), @ApiResponse(responseCode="400", description="Report parameter not defined or invalid"), @ApiResponse(responseCode="500", description="Error reading report file")})
    @Parameter(description="The report that should be rendered", in=ParameterIn.QUERY, name="report", required=true)
    public /* synthetic */ Object handle(@Nonnull HttpServletRequest httpServletRequest, @Nonnull HttpServletResponse httpServletResponse, @Nullable Object object, boolean bl2) throws IOException {
        return this.b(httpServletRequest, httpServletResponse, (Void)object, bl2);
    }
}

