/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.statistic;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.i18n.Msg;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Set;

@InternalApi
public class Accumulator {
    private static File axC;
    private static Hashtable<String, Object> bue;
    private static long buf;
    private static long bug;
    private static int buh;
    private static int bui;
    private static int buj;
    private static volatile int buk;
    private static volatile int bul;
    private static Set<Integer> bum;
    private static Set<String> bun;
    private static Set<String> buo;
    private static double bup;
    private static int buq;
    private static int bur;
    private static double bus;
    private static double but;
    private static int buu;
    private static int buv;

    private Accumulator() {
    }

    public static void incTotalRequest() {
        Accumulator.NE();
        ++buh;
    }

    public static void incReportRequest() {
        ++bui;
    }

    public static void incRenderedReports() {
        ++buj;
        bul = Math.max(bul, ++buk);
    }

    public static void decRenderedReports() {
        --buk;
    }

    public static int getCurrentRenderingReports() {
        return buk;
    }

    public static int getMaxRenderingReports() {
        return bul;
    }

    public static void countReportTemplates(URL reportUrl) {
        bum.add(reportUrl.hashCode());
    }

    public static void countClientLanguages(Locale locale) {
        bun.add(locale.getLanguage());
    }

    public static void countReportFormats(String format) {
        buo.add(format.startsWith("htm") ? "htm" : format);
    }

    public static void incPageCount(int pages) {
        bup += (double)pages;
        ++buq;
        bur = Math.max(bur, pages);
    }

    public static void countRecords(int fetchedRecord, int discardedRecords) {
        bus += (double)fetchedRecord;
        but += (double)discardedRecords;
        buu = Math.max(buu, fetchedRecord);
        buv = Math.max(buv, discardedRecords);
    }

    public static void print(Printer printer) {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        Accumulator.a("Total Requests", decimalFormat, printer);
        Accumulator.a("Report Requests", decimalFormat, printer);
        Accumulator.a("Rendered Reports", decimalFormat, printer);
        Accumulator.a("Report Templates", decimalFormat, printer);
        Accumulator.a("Client Languages", decimalFormat, printer);
        Accumulator.a("Last used Client Languages", decimalFormat, printer);
        Accumulator.a("Report Formats", decimalFormat, printer);
        Accumulator.a("Last used Report Formats", decimalFormat, printer);
        Accumulator.a("Total Page Count", decimalFormat, printer);
        Accumulator.a("Maximal Page Count", decimalFormat, printer);
        Accumulator.a("Average Page Count", decimalFormat, printer);
        Accumulator.a("Total fetched Records", decimalFormat, printer);
        Accumulator.a("Maximal fetched Records", decimalFormat, printer);
        Accumulator.a("Total discarded Records", decimalFormat, printer);
        Accumulator.a("Maximal discarded Records", decimalFormat, printer);
    }

    public static void print() {
        BaseUtils.info("== Start Statistic Data ==========");
        BaseUtils.info("=== Average per Day ==============");
        Accumulator.print(new Printer(){

            @Override
            public void print(String key, String value, String description) {
                BaseUtils.info(key + ":\t" + value);
            }
        });
        BaseUtils.info("== End Statistic Data ============");
    }

    private static void a(String string, DecimalFormat decimalFormat, Printer printer) {
        Object object = bue.get(string);
        if (object == null) {
            object = "";
        }
        if (object instanceof Number && !Double.isNaN(((Number)object).doubleValue())) {
            object = decimalFormat.format(object);
        }
        String string2 = "Accumulator_" + string.replaceAll(" ", "_");
        printer.print(Msg.getMsg(string2, new Object[0]), object.toString(), Msg.getMsg(string2 + "_description", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void NE() {
        long l2 = System.currentTimeMillis();
        if (l2 > buf) {
            Class<Accumulator> clazz = Accumulator.class;
            synchronized (Accumulator.class) {
                if (l2 <= buf) return;
                Accumulator.a(bue, "");
                Accumulator.save();
                buh = 0;
                bui = 0;
                buj = 0;
                bup = 0.0;
                bur = 0;
                buq = 0;
                bus = 0.0;
                buu = 0;
                but = 0.0;
                buv = 0;
                bum.clear();
                bun.clear();
                buo.clear();
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
        if (l2 <= bug) return;
        Class<Accumulator> clazz = Accumulator.class;
        synchronized (Accumulator.class) {
            if (l2 <= bug) return;
            Accumulator.backup();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void backup() {
        if (axC == null) {
            return;
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Accumulator.a(hashtable, ".saved");
        bue.putAll(hashtable);
        Accumulator.save();
    }

    private static synchronized void a(Hashtable<String, Object> hashtable, String string) {
        Accumulator.a(buh, hashtable, "Total Requests" + string);
        Accumulator.a(bui, hashtable, "Report Requests" + string);
        Accumulator.a(buj, hashtable, "Rendered Reports" + string);
        Accumulator.a(bup, hashtable, "Total Page Count" + string);
        Accumulator.a(bur, hashtable, "Maximal Page Count" + string);
        Accumulator.a(bus, hashtable, "Total fetched Records" + string);
        Accumulator.a(buu, hashtable, "Maximal fetched Records" + string);
        Accumulator.a(but, hashtable, "Total discarded Records" + string);
        Accumulator.a(buv, hashtable, "Maximal discarded Records" + string);
        if (string.length() == 0) {
            Accumulator.a(bum.size(), hashtable, "Report Templates");
            Accumulator.a(bun.size(), hashtable, "Client Languages");
            hashtable.put("Last used Client Languages", bun);
            Accumulator.a(buo.size(), hashtable, "Report Formats");
            hashtable.put("Last used Report Formats", buo);
            Accumulator.a(bup / (double)buq, hashtable, "Average Page Count");
        } else {
            hashtable.put("Report Templates" + string, bum);
            hashtable.put("Client Languages" + string, bun);
            hashtable.put("Report Formats" + string, buo);
            hashtable.put("Average Page Count" + string, buq);
        }
        hashtable.put("Next Day", buf);
    }

    private static Hashtable<String, Object> NF() {
        Hashtable<String, Object> hashtable = bue = new Hashtable<String, Object>();
        try {
            axC = new File(System.getProperty("user.home"), ".cc.statistic");
            try {
                ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(axC));
                hashtable = (Hashtable<String, Object>)objectInputStream.readObject();
                objectInputStream.close();
                if (hashtable != null) {
                    bue = hashtable;
                } else {
                    hashtable = bue;
                }
                buh = (int)Accumulator.dJ("Total Requests");
                bui = (int)Accumulator.dJ("Report Requests");
                buj = (int)Accumulator.dJ("Rendered Reports");
                bup = Accumulator.dJ("Total Page Count");
                bur = (int)Accumulator.dJ("Maximal Page Count");
                buq = (int)Accumulator.dJ("Average Page Count");
                bus = Accumulator.dJ("Total fetched Records");
                buu = (int)Accumulator.dJ("Maximal fetched Records");
                but = Accumulator.dJ("Total discarded Records");
                buv = (int)Accumulator.dJ("Maximal discarded Records");
                bum = Accumulator.dK("Report Templates");
                bun = Accumulator.dK("Client Languages");
                buo = Accumulator.dK("Report Formats");
                Long l2 = (Long)hashtable.get("Next Day");
                if (l2 != null) {
                    Accumulator.NG();
                    buf = l2;
                    Accumulator.NE();
                }
            }
            catch (Throwable throwable) {
                bue = hashtable;
                bum = Collections.synchronizedSet(new HashSet());
                bun = Collections.synchronizedSet(new HashSet());
                buo = Collections.synchronizedSet(new HashSet());
            }
            Accumulator.NG();
        }
        catch (Throwable throwable) {
            BaseUtils.printStackTrace(throwable);
            bum = Collections.synchronizedSet(new HashSet());
            bun = Collections.synchronizedSet(new HashSet());
            buo = Collections.synchronizedSet(new HashSet());
        }
        try {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Accumulator.backup();
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return hashtable;
    }

    private static void NG() {
        Date date = new Date();
        bug = date.getTime() + 3600000L;
        date = new Date(date.getYear(), date.getMonth(), date.getDate() + 1);
        buf = date.getTime();
    }

    private static synchronized void save() {
        if (axC == null) {
            return;
        }
        Accumulator.NG();
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(axC));
            objectOutputStream.writeObject(bue);
            objectOutputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static double dJ(String string) {
        Number number = (Number)bue.get(string + ".saved");
        if (number != null) {
            return number.doubleValue();
        }
        return 0.0;
    }

    private static Set dK(String string) {
        Set set = (Set)bue.get(string + ".saved");
        if (set != null) {
            return set;
        }
        return Collections.synchronizedSet(new HashSet());
    }

    private static synchronized void a(double d2, Hashtable<String, Object> hashtable, String string) {
        Double d3 = (Double)hashtable.get(string);
        if (Double.isNaN(d2) || Double.isInfinite(d2)) {
            d2 = 0.0;
        }
        if (d3 == null) {
            hashtable.put(string, d2);
        } else {
            double d4 = (d2 + 7.0 * d3) / 8.0;
            hashtable.put(string, d4);
        }
    }

    static {
        bue = Accumulator.NF();
    }

    @InternalApi
    public static interface Printer {
        public void print(String var1, String var2, String var3);
    }
}

