/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.axis.AbstractMarker;
import com.inet.report.chart.f;
import com.inet.report.j;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class IntervalMarker
extends AbstractMarker {
    private double Xg = 0.0;
    private FormulaField Xh;
    private boolean Xi;
    private double Xj = 0.0;
    private FormulaField Xk;
    private boolean Xl;

    public double getFirstValue() {
        return this.Xg;
    }

    public void setFirstValue(double firstValue) {
        this.Xg = firstValue;
    }

    public double getSecondValue() {
        return this.Xj;
    }

    public void setSecondValue(double secondValue) {
        this.Xj = secondValue;
    }

    @Override
    protected StringBuilder cs(int n2) {
        StringBuilder stringBuilder = super.cs(n2);
        f.b(stringBuilder, n2, "FirstValue", String.valueOf(this.getFirstValue()));
        f.b(stringBuilder, n2, "SecondValue", String.valueOf(this.getSecondValue()));
        if (this.Xh != null) {
            j.a(stringBuilder, n2, this.Xh, this.Xi ? "markerFromDate" : "markerFrom");
        }
        if (this.Xk != null) {
            j.a(stringBuilder, n2, this.Xk, this.Xl ? "markerToDate" : "markerTo");
        }
        return stringBuilder;
    }

    @Override
    public void readProperties(Element element, Chart2 chart) {
        super.readProperties(element, chart);
        NodeList nodeList = element.getChildNodes();
        FormulaField formulaField = j.a(nodeList, chart, "markerFrom");
        if (formulaField != null) {
            this.setFirstValueFormula(formulaField, false);
            chart.updateReferences();
        } else {
            formulaField = j.a(nodeList, chart, "markerFromDate");
            if (formulaField != null) {
                this.setFirstValueFormula(formulaField, true);
                chart.updateReferences();
            }
        }
        FormulaField formulaField2 = j.a(nodeList, chart, "markerTo");
        if (formulaField2 != null) {
            this.setSecondValueFormula(formulaField2, false);
            chart.updateReferences();
        } else {
            formulaField2 = j.a(nodeList, chart, "markerToDate");
            if (formulaField2 != null) {
                this.setSecondValueFormula(formulaField2, true);
                chart.updateReferences();
            }
        }
        for (int i2 = 0; i2 < nodeList.getLength(); ++i2) {
            double d2;
            String string;
            if (!(nodeList.item(i2) instanceof Element)) continue;
            Element element2 = (Element)nodeList.item(i2);
            if (element2.getNodeName().equals("FirstValue")) {
                string = element2.getAttribute("value");
                if (string.length() <= 0) continue;
                d2 = Double.parseDouble(string);
                this.setFirstValue(d2);
                continue;
            }
            if (!element2.getNodeName().equals("SecondValue") || (string = element2.getAttribute("value")).length() <= 0) continue;
            d2 = Double.parseDouble(string);
            this.setSecondValue(d2);
        }
    }

    public FormulaField getFirstValueFormula() {
        return this.Xh;
    }

    public void setFirstValueFormula(FormulaField firstValueFormula, boolean isDate) {
        if (firstValueFormula != null && firstValueFormula.getFormulaType() != 3) {
            throw new IllegalArgumentException("This formula is not from type FormulaField.FORMULA_PROPERTY");
        }
        if (this.Xh != null) {
            this.Xh.resetReferences();
        }
        this.Xh = firstValueFormula;
        this.Xi = isDate;
    }

    public FormulaField getSecondValueFormula() {
        return this.Xk;
    }

    public void setSecondValueFormula(FormulaField secondValueFormula, boolean isDate) {
        if (secondValueFormula != null && secondValueFormula.getFormulaType() != 3) {
            throw new IllegalArgumentException("This formula is not from type FormulaField.FORMULA_PROPERTY");
        }
        if (this.Xk != null) {
            this.Xk.resetReferences();
        }
        this.Xk = secondValueFormula;
        this.Xl = isDate;
    }

    public boolean isFirstValueFormulaDate() {
        return this.Xi;
    }

    public boolean isSecondValueFormulaDate() {
        return this.Xl;
    }
}

