/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.chart.axis;

import com.inet.annotations.PublicApi;
import com.inet.report.BaseUtils;
import com.inet.report.Chart2;
import com.inet.report.FormulaField;
import com.inet.report.chart.f;
import com.inet.report.i;
import com.inet.report.j;
import java.io.Serializable;
import java.util.Date;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

@PublicApi
public class DateRange
implements Serializable {
    private Date WS;
    private Date WT;
    private FormulaField WU;
    private FormulaField WV;
    private boolean vz;

    public DateRange() {
        this.vz = true;
    }

    public DateRange(Date lower, Date upper) {
        if (lower == null) {
            throw i.d("lower");
        }
        if (upper == null) {
            throw i.d("upper");
        }
        if (lower.after(upper)) {
            throw new IllegalArgumentException("Parameter 'upper' before 'lower'.");
        }
        this.vz = false;
        this.WS = (Date)lower.clone();
        this.WT = (Date)upper.clone();
    }

    public boolean isAutoRange() {
        return this.vz;
    }

    public void setAutoRange(boolean autoRange) {
        this.vz = autoRange;
    }

    public Date getLowerBound() {
        if (this.WS != null) {
            return (Date)this.WS.clone();
        }
        return null;
    }

    public void setLowerBound(Date lower) {
        if (this.WT != null && this.WT.before(lower)) {
            throw new IllegalArgumentException("Parameter 'lower' greater than upper bound.");
        }
        this.WS = lower != null ? (Date)lower.clone() : null;
    }

    public FormulaField getLowerBoundFormula() {
        return this.WU;
    }

    public void setLowerBoundFormula(FormulaField lowerBoundFormula) {
        this.WU = lowerBoundFormula;
    }

    public Date getUpperBound() {
        if (this.WT != null) {
            return (Date)this.WT.clone();
        }
        return null;
    }

    public void setUpperBound(Date upper) {
        if (this.WS != null && this.WS.after(upper)) {
            throw new IllegalArgumentException("Parameter 'upper' less than 'lower'.");
        }
        this.WT = upper != null ? (Date)upper.clone() : null;
    }

    public FormulaField getUpperBoundFormula() {
        return this.WV;
    }

    public void setUpperBoundFormula(FormulaField upperBoundFormula) {
        this.WV = upperBoundFormula;
    }

    boolean mV() {
        return !(this.getUpperBound() == null && this.getUpperBoundFormula() == null || this.getLowerBound() == null && this.getLowerBoundFormula() == null);
    }

    void saveProperties(StringBuilder buffer, int depth) {
        if (!this.isAutoRange() && this.mV()) {
            buffer.append(BaseUtils.getIndent(depth));
            buffer.append("<");
            buffer.append("RangeDate");
            buffer.append(' ');
            if (this.WS != null) {
                f.b(buffer, "lowerBound", Long.toString(this.WS.getTime()));
            }
            if (this.WT != null) {
                f.b(buffer, "upperBound", Long.toString(this.WT.getTime()));
            }
            buffer.append(">\n");
            if (this.WU != null) {
                j.a(buffer, depth, this.WU, "chartAxisMinDateFormula");
            }
            if (this.WV != null) {
                j.a(buffer, depth, this.WV, "chartAxisMaxDateFormula");
            }
            buffer.append("<");
            buffer.append("/");
            buffer.append("RangeDate");
            buffer.append(">\n");
        }
    }

    void readProperties(Element element, Chart2 chart) {
        NodeList nodeList;
        FormulaField formulaField;
        this.setAutoRange(false);
        String string = element.getAttribute("lowerBound");
        if (string.length() > 0) {
            long l2 = Long.valueOf(string);
            this.setLowerBound(new Date(l2));
        }
        if ((formulaField = j.a(nodeList = element.getChildNodes(), chart, "chartAxisMinDateFormula")) != null) {
            this.setLowerBoundFormula(formulaField);
        }
        if ((string = element.getAttribute("upperBound")).length() > 0) {
            long l3 = Long.valueOf(string);
            this.setUpperBound(new Date(l3));
        }
        if ((formulaField = j.a(nodeList, chart, "chartAxisMaxDateFormula")) != null) {
            this.setUpperBoundFormula(formulaField);
        }
    }
}

