/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.report.Database;
import com.inet.report.Datasource;
import com.inet.report.ReportException;

public class DatabaseAccess
extends Database {
    public DatabaseAccess() {
        this.getConfiguration().setAliasToken("AS", false);
    }

    @Override
    protected boolean needQuote(String identifier) {
        char c2 = identifier.charAt(0);
        switch (c2) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return super.needQuote(identifier);
    }

    @Override
    protected String[] parseSourceName(String sqlSource) {
        String[] stringArray = super.parseSourceName(sqlSource);
        stringArray[1] = null;
        return stringArray;
    }

    @Override
    protected String getSqlIdentifier(Datasource ds, String identifier, boolean escapeEverything) {
        int n2 = identifier.lastIndexOf(46);
        if (n2 < 0) {
            return super.getSqlIdentifier(ds, identifier, escapeEverything);
        }
        return identifier.substring(0, ++n2) + super.getSqlIdentifier(ds, identifier.substring(n2), escapeEverything);
    }

    @Override
    public String convertToString(String parameter) {
        return "Cstr(" + parameter + ")";
    }

    @Override
    public String convertToInt(String parameter) {
        return "int( " + parameter + ")";
    }

    @Override
    public String convertToDouble(String parameter) {
        return "Cdbl( " + parameter + ")";
    }

    @Override
    public String convertToDate(String year, String month, String day) {
        return "Cvdate(Cstr(" + year + ")+'/'+Cstr(" + month + ")+'/'+Cstr(" + day + "))";
    }

    @Override
    public String convertToTime(String hour, String minute, String sec) {
        return "Cvdate(Cstr(" + hour + ")+':'+Cstr(" + minute + ")+':'+Cstr(" + sec + "))";
    }

    @Override
    public String convertToTime(String time) throws ReportException {
        throw new ReportException("Not Executable on Database.", 150);
    }

    @Override
    public String convertToTimeStamp(String year, String month, String day, String hour, String minute, String sec) {
        return "Cvdate(Cstr(" + year + ")+'/'+Cstr(" + month + ")+'/'+Cstr(" + day + ")+ ' ' + Cstr(" + hour + ")+':'+Cstr(" + minute + ")+':'+Cstr(" + sec + "))";
    }

    @Override
    public int getMaxAliasNameLength() {
        return 256;
    }
}

