/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report;

import com.inet.annotations.PublicApi;
import com.inet.cache.MemoryStoreMap;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.lib.util.StringFunctions;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseField;
import com.inet.report.DatabaseMetaDataFactory;
import com.inet.report.DatabaseTables;
import com.inet.report.Datasource;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FormulaField;
import com.inet.report.Join;
import com.inet.report.ParameterList;
import com.inet.report.ReferenceHolder;
import com.inet.report.ReportDataHandler;
import com.inet.report.ReportException;
import com.inet.report.ReportExceptionFactory;
import com.inet.report.SortField;
import com.inet.report.TableSource;
import com.inet.report.ba;
import com.inet.report.bm;
import com.inet.report.bn;
import com.inet.report.bo;
import com.inet.report.by;
import com.inet.report.database.DatabaseUtils;
import com.inet.report.database.JdbcData;
import com.inet.report.database.fetch.DataCollector;
import com.inet.report.database.fetch.FetchTables;
import com.inet.report.database.fetch.c;
import com.inet.report.database.fetch.d;
import com.inet.report.database.metadata.a;
import com.inet.report.database.sql.PromptPlaceholderReplacer;
import com.inet.report.database.sql.SqlSyntax;
import com.inet.report.i18n.ReportErrorCode;
import com.inet.report.list.DatabaseFieldList;
import com.inet.report.rowsource.b;
import com.inet.report.util.EngineUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.annotation.Nullable;

@PublicApi
public class Database
extends JdbcData
implements SqlSyntax,
Serializable {
    private static final String[] kg = new String[]{"absolute", "action", "add", "all", "allocate", "alter", "and", "any", "are", "as", "asc", "assertion", "at", "authorization", "avg", "begin", "between", "bit", "bit_length", "both", "by", "cascade", "cascaded", "case", "cast", "catalog", "char", "character", "char_length", "character_length", "check", "close", "coalesce", "collate", "collation", "column", "commit", "connect", "connection", "constraint", "constraints", "continue", "convert", "corresponding", "count", "create", "cross", "current", "current_date", "current_time", "current_timestamp", "current_user", "cursor", "date", "day", "deallocate", "dec", "decimal", "declare", "default", "deferrable", "deferred", "delete", "desc", "describe", "descriptor", "diagnostics", "disconnect", "distinct", "domain", "double", "drop", "else", "end", "end-exec", "escape", "except", "exception", "exec", "execute", "exists", "external", "extract", "false", "fetch", "first", "float", "for", "foreign", "found", "from", "full", "get", "global", "go", "goto", "grant", "group", "having", "hour", "identity", "immediate", "in", "indicator", "initially", "inner", "input", "insensitive", "insert", "int", "integer", "intersect", "interval", "into", "is", "isolation", "join", "key", "language", "last", "leading", "left", "level", "like", "local", "lower", "match", "max", "min", "minute", "module", "month", "names", "national", "natural", "nchar", "next", "no", "not", "null", "nullif", "numeric", "octet_length", "of", "on", "only", "open", "option", "or", "order", "outer", "output", "overlaps", "pad", "partial", "position", "precision", "prepare", "preserve", "primary", "prior", "privileges", "procedure", "public", "read", "real", "references", "relative", "restrict", "revoke", "right", "rollback", "rows", "schema", "scroll", "second", "section", "select", "session", "session_user", "set", "size", "smallint", "some", "space", "sql", "sqlcode", "sqlerror", "sqlstate", "substring", "sum", "system_user", "table", "temporary", "then", "time", "timestamp", "timezone_hour", "timezone_minute", "to", "trailing", "transaction", "translate", "translation", "trim", "true", "union", "unique", "unknown", "update", "upper", "usage", "user", "using", "value", "values", "varchar", "varying", "view", "when", "whenever", "where", "with", "work", "write", "year", "zone"};
    private static final HashSet<String> kh = new HashSet<String>(Arrays.asList(kg));
    private HashSet<String> ki;
    static final ConfigValue<Boolean> kj = new ConfigValue<Boolean>(ConfigKey.METADATACACHE_ENABLED){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            if (EngineUtils.isDesigner()) {
                super.setValue("false");
            } else {
                super.setValue(strValue);
            }
        }
    };
    private static final MemoryStoreMap<a, com.inet.report.database.metadata.b> kk = new MemoryStoreMap();
    static final Map<a, com.inet.report.database.metadata.b> kl = Collections.synchronizedMap(kk);
    private static final ConfigValue<Double> km = new ConfigValue<Double>(ConfigKey.METADATACACHE_TIMEOUT){

        protected void setValue(@Nullable String strValue) throws IllegalArgumentException {
            super.setValue(strValue);
            double d2 = (Double)this.get();
            kk.setTimeout((int)(d2 * 60.0), false);
        }
    };
    private transient c kn = new c();
    transient PromptPlaceholderReplacer ko = new PromptPlaceholderReplacer(this);

    public Database() {
        this.initTransient();
    }

    protected void initTransient() {
        this.kn = new c();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean scanSourceType(TableSource ts, ParameterList dataTypeScale, boolean useMetaDataCache) throws SQLException, ReportException {
        com.inet.report.database.metadata.b b2;
        a a2;
        boolean bl2;
        block35: {
            bl2 = false;
            Datasource datasource = ts.getDatasource();
            String[] stringArray = this.parseSourceName(ts.kv());
            if (datasource.ca() && stringArray[0] != null) {
                stringArray[0] = datasource.getCatalog();
            }
            if (datasource.bZ()) {
                stringArray[1] = datasource.getSchema();
            }
            if (stringArray[0] != null && stringArray[0].length() == 0) {
                stringArray[0] = null;
            }
            if (stringArray[1] != null && stringArray[1].length() == 0) {
                stringArray[1] = null;
            }
            if (stringArray[2] != null && stringArray[2].length() == 0) {
                stringArray[2] = null;
            }
            if (BaseUtils.isInfo()) {
                BaseUtils.info(stringArray[0] + " " + stringArray[1] + " " + stringArray[2] + "  " + String.valueOf(this.getClass()));
            }
            a2 = null;
            b2 = null;
            if (((Boolean)kj.get()).booleanValue() && (b2 = kl.get(a2 = a.a(ts.getDatasource(), stringArray[0], stringArray[1], stringArray[2]))) != null && useMetaDataCache) {
                dataTypeScale.load(b2.oP());
                return b2.oO();
            }
            dataTypeScale.clear();
            try (Connection connection = datasource.getConnection();){
                if (connection == null) {
                    boolean bl3 = false;
                    return bl3;
                }
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet resultSet = null;
                int n2 = 4;
                try {
                    resultSet = databaseMetaData.getTables(stringArray[0], stringArray[1], stringArray[2], null);
                    if (resultSet.next()) {
                        String string = resultSet.getString(4);
                        n2 = string == null ? 1 : (string.equals("TABLE") ? 1 : (string.equals("VIEW") ? 2 : (string.equals("SYSTEM TABLE") ? 1 : 1)));
                    }
                }
                catch (SQLException sQLException) {
                    BaseUtils.warning("metadata get tables failed: " + String.valueOf(sQLException));
                    BaseUtils.printStackTrace(sQLException);
                }
                finally {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (n2 <= 1) break block35;
                try {
                    resultSet = this.getProcedureColumns(datasource, stringArray[0], stringArray[1], stringArray[2]);
                    boolean bl4 = this.scanSourceTypeParameters(connection, stringArray[0], stringArray[1], resultSet, dataTypeScale);
                    resultSet.close();
                    if (n2 == 4 && bl4 || n2 == 2 && dataTypeScale.getInputCount() > 0) {
                        bl2 = true;
                        ++n2;
                        break block35;
                    }
                    if (bl4 || n2 != 4) break block35;
                    try {
                        resultSet = databaseMetaData.getProcedures(stringArray[0], stringArray[1], stringArray[2]);
                        bl2 = resultSet.next();
                        resultSet.close();
                    }
                    catch (Throwable throwable) {
                        BaseUtils.printStackTrace(throwable);
                    }
                }
                catch (Throwable throwable) {
                    if (n2 == 4) {
                        bl2 = false;
                    }
                    BaseUtils.warning("metadata get procedure columns failed: " + String.valueOf(throwable));
                    BaseUtils.printStackTrace(throwable);
                }
            }
        }
        if (((Boolean)kj.get()).booleanValue() && b2 == null) {
            b2 = new com.inet.report.database.metadata.b(bl2, dataTypeScale.clone());
            kl.put(a2, b2);
        }
        return bl2;
    }

    protected void scanIdentifierQuoteString(Datasource dc) throws SQLException, ReportException {
        try (Connection connection = dc.getConnection();){
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            dc.getDataFactory().getConfiguration().setIdentifierQuoteString(databaseMetaData.getIdentifierQuoteString(), true);
            Database.a(databaseMetaData, true, true);
        }
    }

    static final void a(DatabaseMetaData databaseMetaData, boolean bl2, boolean bl3) {
        if (BaseUtils.isInfo()) {
            String string;
            String string2;
            String string3;
            String string4;
            block16: {
                block14: {
                    string4 = "unknown driver name";
                    string3 = "unknown driver version";
                    string2 = "unknown database product name";
                    string = "unknown database product version";
                    if (bl2) {
                        block13: {
                            try {
                                string4 = databaseMetaData.getDriverName();
                            }
                            catch (Throwable throwable) {
                                if (!BaseUtils.isDebug()) break block13;
                                BaseUtils.debug("DatabaseMetaData did not return info about driver name, caused by: " + throwable.toString());
                            }
                        }
                        try {
                            string3 = databaseMetaData.getDriverVersion();
                        }
                        catch (Throwable throwable) {
                            if (!BaseUtils.isDebug()) break block14;
                            BaseUtils.debug("DatabaseMetaData did not return info about driver version, caused by: " + throwable.toString());
                        }
                    }
                }
                if (bl3) {
                    block15: {
                        try {
                            string2 = databaseMetaData.getDatabaseProductName();
                        }
                        catch (Throwable throwable) {
                            if (!BaseUtils.isDebug()) break block15;
                            BaseUtils.debug("DatabaseMetaData did not return info about database product name, caused by: " + throwable.toString());
                        }
                    }
                    try {
                        string = databaseMetaData.getDatabaseProductVersion();
                    }
                    catch (Throwable throwable) {
                        if (!BaseUtils.isDebug()) break block16;
                        BaseUtils.debug("DatabaseMetaData did not return info about database product version, caused by: " + throwable.toString());
                    }
                }
            }
            if (bl2) {
                BaseUtils.info("Driver Info  : " + string4 + " , Version: " + string3);
            }
            if (bl3) {
                BaseUtils.info("Database Info: " + string2 + " , Version: " + string);
            }
        }
    }

    protected boolean scanSourceTypeParameters(Connection con, String srcCatalog, String srcSchema, ResultSet rs, ParameterList parameters) throws SQLException {
        String string;
        String string2;
        parameters.clear();
        boolean bl2 = false;
        try {
            string2 = con.getCatalog();
        }
        catch (Throwable throwable) {
            string2 = null;
        }
        try {
            string = con.getSchema();
        }
        catch (Throwable throwable) {
            string = null;
        }
        while (rs.next()) {
            String string3 = rs.getString(1);
            if (!StringFunctions.isEmpty((String)string3) && (StringFunctions.isEmpty((String)srcCatalog) ? !StringFunctions.isEmpty((String)string2) && !string3.equalsIgnoreCase(string2) : !string3.equalsIgnoreCase(srcCatalog))) continue;
            String string4 = rs.getString(2);
            if (!StringFunctions.isEmpty((String)string4) && (!StringFunctions.isEmpty((String)srcSchema) ? !string4.equalsIgnoreCase(srcSchema) : !StringFunctions.isEmpty((String)string) && !string4.equalsIgnoreCase(string))) continue;
            bl2 = true;
            this.scanSourceTypeParameterSingle(rs, parameters);
        }
        return bl2;
    }

    protected void scanSourceTypeParameterSingle(ResultSet rs, ParameterList parameters) throws SQLException {
        String string = rs.getString(4);
        int n2 = rs.getInt(5);
        int n3 = rs.getInt(6);
        int n4 = rs.getInt(10);
        if (BaseUtils.isDebug()) {
            BaseUtils.debug("Add parameter name " + string + " type " + n2 + " dataType " + n3 + " scale " + n4);
        }
        if (string != null) {
            parameters.a(string, n2, n3, n4, this.isCursor(n3));
        } else {
            parameters.a("der Treiber hat keinen Namen geliefert", n2, n3, n4, this.isCursor(n3));
        }
    }

    protected String[] parseSourceName(String sqlSource) {
        return DatabaseUtils.parseSourceName(this.getConfiguration(), sqlSource);
    }

    @Override
    protected String getColumnName(String colName, String alias, int driverVersion, TableSource ts, int colIdx) {
        return super.getColumnName(colName, alias, driverVersion, ts, colIdx);
    }

    void a(Datasource datasource) {
        if (this.ki != null) {
            return;
        }
        if (datasource != null) {
            this.ki = new HashSet();
            try (Connection connection = datasource.getConnection();){
                String string;
                DatabaseMetaData databaseMetaData;
                if (connection != null && (databaseMetaData = connection.getMetaData()) != null && (string = databaseMetaData.getSQLKeywords()) != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreElements()) {
                        String string2 = (String)stringTokenizer.nextElement();
                        this.ki.add(string2.toLowerCase());
                    }
                }
            }
            catch (ReportException reportException) {
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected boolean needQuote(String identifier) {
        if (this.getConfiguration().isUseQuoteLowerCase()) {
            return true;
        }
        if (this.isKeyword(identifier)) {
            return true;
        }
        char[] cArray = identifier.toCharArray();
        int n2 = cArray.length;
        while (n2-- > 0) {
            switch (cArray[n2]) {
                case ' ': 
                case '!': 
                case '$': 
                case '%': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '=': 
                case '@': 
                case '\\': 
                case '^': 
                case '`': 
                case '{': 
                case '}': 
                case '~': 
                case '\u00b4': {
                    return true;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (n2 != 0) break;
                    return true;
                }
            }
        }
        return false;
    }

    protected boolean isKeyword(String identifier) {
        String string = identifier.toLowerCase();
        return kh.contains(string) || this.ki != null && this.ki.contains(string);
    }

    protected String getSqlIdentifier(Datasource ds, String identifier, boolean escapeEverything) {
        int n2;
        this.a(ds);
        int n3 = 0;
        String string = this.getConfiguration().getIdentifierQuoteString();
        if (string == null || string.length() == 0 || string.equals(" ")) {
            return identifier;
        }
        if (escapeEverything) {
            return string + identifier + string;
        }
        int n4 = identifier.length();
        StringBuilder stringBuilder = new StringBuilder(n4 * 2);
        n3 = 0;
        do {
            String string2;
            boolean bl2;
            if (bl2 = this.needQuote(string2 = (n2 = identifier.indexOf(46, n3)) != -1 ? identifier.substring(n3, n2) : identifier.substring(n3))) {
                stringBuilder.append(string);
            }
            if (n2 != -1) {
                stringBuilder.append(string2);
                if (bl2) {
                    stringBuilder.append(string);
                }
                if (n4 > n2 + 1 && identifier.charAt(n2 + 1) == '.') {
                    stringBuilder.append("..");
                    n3 = n2 + 2;
                    continue;
                }
                stringBuilder.append('.');
            } else {
                stringBuilder.append(string2);
                if (bl2) {
                    stringBuilder.append(string);
                }
            }
            n3 = n2 + 1;
        } while (n2 != -1);
        return stringBuilder.toString();
    }

    static boolean a(DatabaseField databaseField, ba ba2) {
        int n2;
        for (n2 = 0; n2 < ba2.IB.length; ++n2) {
            if (!ba2.IB[n2].name.equals(databaseField.name)) continue;
            return true;
        }
        for (n2 = 0; ba2.IB != null && n2 < ba2.IB.length; ++n2) {
            SortField sortField = ba2.IB[n2];
            if (!(sortField.getField() instanceof FormulaField)) continue;
            List<DatabaseField> list = by.b((FormulaField)sortField.getField(), DatabaseField.class, false);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                if (databaseField != list.get(i2)) continue;
                return true;
            }
        }
        return false;
    }

    final int a(DatabaseTables databaseTables, Datasource datasource, String string, Connection connection) throws ReportException, SQLException {
        bo bo2 = this.bC();
        bo2.J(databaseTables.bM()).g(datasource.bX());
        bo2.a(Collections.emptySet());
        bo2.f(new ArrayList<Join>());
        String string2 = bo2.a(string, "1=0", null, null);
        String string3 = new PromptPlaceholderReplacer(this.getSqlSyntax()).replace(string2.toString(), databaseTables.bM().getFields());
        try (Statement statement = connection.createStatement();){
            int n2;
            block13: {
                ResultSet resultSet = DatabaseUtils.executeQuery(statement, string3, null);
                try {
                    ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                    if (resultSetMetaData.getColumnCount() != 1) {
                        throw ReportExceptionFactory.createReportException(ReportErrorCode.MultiSqlCols, string);
                    }
                    n2 = DatabaseTables.mapSqlTypeToCCType(resultSetMetaData.getColumnType(1));
                    if (resultSet == null) break block13;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return n2;
        }
    }

    @Override
    protected String getSourceNameWithChange(TableSource ts, boolean escapeEverything) {
        Datasource datasource = ts.getDatasource();
        String string = ts.getDatabaseIdentifier();
        if (datasource.bZ() || datasource.ca()) {
            String[] stringArray = this.parseSourceName(string);
            StringBuilder stringBuilder = new StringBuilder();
            if (datasource.ca() && stringArray[0] != null) {
                stringArray[0] = datasource.getCatalog();
            }
            if (datasource.bZ()) {
                stringArray[1] = datasource.getSchema();
            }
            if (stringArray[0] != null) {
                stringBuilder.append(stringArray[0]);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            if (stringArray[1] != null) {
                stringBuilder.append(stringArray[1]);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            stringBuilder.append(stringArray[2]);
            string = stringBuilder.toString();
        }
        return this.getSqlIdentifier(datasource, string, escapeEverything);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void a(ResultSet resultSet, ba ba2) throws SQLException, ReportException {
        try {
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            DatabaseFieldList databaseFieldList = new DatabaseFieldList();
            DatabaseTables databaseTables = ba2.jc();
            ArrayList<Field> arrayList = new ArrayList<Field>(n2);
            TableSource tableSource = null;
            if (databaseTables.getDatasource(0).getTableSourceCount() > 0 && databaseTables.getDatasource(0).getTableSource(0) != null) {
                tableSource = databaseTables.getDatasource(0).getTableSource(0);
                tableSource.getDatasource().setDataSourceConfigurationName(null);
            }
            int n3 = -1;
            try {
                Connection connection = resultSet.getStatement().getConnection();
                n3 = connection.getMetaData().getDriverMajorVersion();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            block9: for (int i2 = 0; i2 < n2; ++i2) {
                String string;
                String string2 = resultSetMetaData.getColumnName(i2 + 1);
                if (tableSource != null) {
                    string = resultSetMetaData.getColumnLabel(i2 + 1);
                    string2 = this.getColumnName(string2, string, n3, tableSource, i2);
                }
                string = resultSetMetaData.getTableName(i2 + 1);
                int n4 = -1;
                if (string != null && string.length() > 0) {
                    n4 = ba2.jd().indexOf(string + "." + string2);
                }
                if (n4 < 0) {
                    n4 = ba2.jd().indexOf(string2);
                }
                if (n4 < 0) {
                    n4 = ba2.jd().indexOfShortName(string2);
                }
                if (n4 < 0) {
                    if (ba2.IA != null) {
                        for (int i3 = 0; i3 < ba2.IA.length; ++i3) {
                            if (!ba2.IA[i3].getName().equalsIgnoreCase(string2)) continue;
                            arrayList.add(ba2.IA[i3]);
                            continue block9;
                        }
                    }
                    DatabaseField databaseField = new DatabaseField(ba2);
                    databaseField.kW = databaseField.name = string2;
                    arrayList.add(databaseField);
                    continue;
                }
                DatabaseField databaseField = ba2.jd().elementAt(n4);
                arrayList.add(databaseField);
                databaseFieldList.addElement(databaseField);
            }
            ReportDataHandler reportDataHandler = ba2.gN();
            reportDataHandler.setDatabaseColumns(arrayList);
            reportDataHandler.setSortLocally(true);
            reportDataHandler.setRowSource(null);
            bm.a(ba2, resultSet);
            if (ba2.IQ >= 0) {
                reportDataHandler.setOriginalRowSource(bm.a(resultSet, null, ba2, databaseFieldList));
            } else {
                reportDataHandler.setOriginalRowSource(new b());
            }
            reportDataHandler.setRowPosition(0);
        }
        finally {
            block22: {
                try {
                    if (!bm.I(ba2)) {
                        resultSet.close();
                    }
                }
                catch (Throwable throwable) {
                    if (!BaseUtils.isParanoid()) break block22;
                    BaseUtils.paranoid(throwable);
                }
            }
        }
    }

    static final void a(DatabaseTables databaseTables) {
        int n2 = databaseTables.getDatasourceCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                Datasource datasource = databaseTables.getDatasource(i2);
                if (!databaseTables.bM().getEngine().oh) continue;
                datasource.closeConnection();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getAddOp() {
        return "+";
    }

    @Override
    public String sqlConcat(Object leftOperant, Object rightOperant) {
        return String.valueOf(leftOperant) + this.getAddOp() + String.valueOf(rightOperant);
    }

    private String a(String string, String string2, String ... stringArray) {
        String string3 = this.sqlConcat(string, string2);
        for (String string4 : stringArray) {
            string3 = this.sqlConcat(string3, string4);
        }
        return string3;
    }

    @Override
    protected ResultSet getTables(Datasource ds, String catalog) throws SQLException, ReportException {
        try (Connection connection = ds.getConnection();){
            if (connection == null) {
                ResultSet resultSet = DatabaseMetaDataFactory.getTables(new String[0], catalog);
                return resultSet;
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData == null) {
                ResultSet resultSet = DatabaseMetaDataFactory.getTables(new String[0], catalog);
                return resultSet;
            }
            ResultSet resultSet = databaseMetaData.getTables(catalog, null, null, null);
            return resultSet;
        }
    }

    @Override
    protected ResultSet getProcedures(Datasource ds, String catalog) throws SQLException, ReportException {
        try (Connection connection = ds == null ? null : ds.getConnection();){
            if (connection == null) {
                ResultSet resultSet = DatabaseMetaDataFactory.a(new String[0], catalog);
                return resultSet;
            }
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            if (databaseMetaData == null) {
                ResultSet resultSet = DatabaseMetaDataFactory.a(new String[0], catalog);
                return resultSet;
            }
            ResultSet resultSet = databaseMetaData.getProcedures(catalog, null, null);
            return resultSet;
        }
    }

    @Override
    protected ResultSet getProcedureColumns(Datasource ds, String catalog, String schema, String procedure) throws SQLException, ReportException {
        block9: {
            try (Connection connection = ds == null ? null : ds.getConnection();){
                DatabaseMetaData databaseMetaData;
                if (connection == null || (databaseMetaData = connection.getMetaData()) == null) break block9;
                try {
                    ResultSet resultSet = databaseMetaData.getProcedureColumns(catalog, schema, procedure, null);
                    return resultSet;
                }
                catch (Exception exception) {
                    BaseUtils.printStackTrace(exception);
                }
            }
        }
        return DatabaseMetaDataFactory.a(null, new String[0], new int[0], new int[0]);
    }

    public boolean isCursor(int sqlType) {
        return false;
    }

    protected int getCursorType(int dataType) {
        return dataType;
    }

    static boolean a(Field field, FormulaField formulaField) {
        ReferenceHolder[] referenceHolderArray = field.getReferenceHolders();
        for (int i2 = 0; i2 < referenceHolderArray.length; ++i2) {
            if (referenceHolderArray[i2] == formulaField) continue;
            return false;
        }
        return true;
    }

    public int getMaxAliasNameLength() {
        return 18;
    }

    @Override
    public String convertToString(String parameter) throws ReportException {
        return "{fn CONVERT( " + parameter + ", SQL_CHAR ) }";
    }

    @Override
    public String convertToInt(String parameter) throws ReportException {
        return "{fn CONVERT( " + parameter + ", SQL_INTEGER ) }";
    }

    @Override
    public String convertToDouble(String parameter) throws ReportException {
        return "{fn CONVERT( " + parameter + ", SQL_DOUBLE ) }";
    }

    @Override
    public String convertToTime(String time) throws ReportException {
        return this.l(time);
    }

    private String l(String string) {
        return "{fn CONVERT(" + string + ",SQL_TIME)}";
    }

    @Override
    public String convertToDate(String date) throws ReportException {
        return this.m(date);
    }

    private String m(String string) {
        return "{fn CONVERT(" + string + ",SQL_Date)}";
    }

    @Override
    public String convertToDate(String year, String month, String day) throws ReportException {
        String string = this.convertStringToSQLSyntax("-", true);
        return this.m(this.a(this.b(year, 4), string, this.b(month, 2), string, this.b(day, 2)));
    }

    @Override
    public String convertToTime(String hour, String minute, String sec) throws ReportException {
        String string = this.convertStringToSQLSyntax(":", true);
        return this.l(this.a(this.b(hour, 2), string, this.b(minute, 2), string, this.b(sec, 2)));
    }

    @Override
    public String convertToTimeStamp(String year, String month, String day, String hour, String minute, String sec) throws ReportException {
        String string = this.convertStringToSQLSyntax("-", true);
        String string2 = this.convertStringToSQLSyntax(":", true);
        String string3 = this.convertStringToSQLSyntax(" ", true);
        return "{fn CONVERT( " + this.a(this.b(year, 4), string, this.b(month, 2), string, this.b(day, 2), string3, this.b(hour, 2), string2, this.b(minute, 2), string2, this.b(sec, 2)) + ",SQL_TIMESTAMP)}";
    }

    private String b(String string, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append('0');
        }
        return "{fn RIGHT( {fn CONCAT( " + this.convertStringToSQLSyntax(stringBuilder.toString(), true) + " , " + string + " ) }, " + n2 + ") }";
    }

    @Override
    public String convertModOperation(String dividend, String divisor) throws ReportException {
        return dividend + "%" + divisor;
    }

    @Override
    public String convertStringToSQLSyntax(String s2, boolean isFunctionParam) {
        int n2 = s2.indexOf(39);
        if (n2 >= 0) {
            int n3 = 0;
            char[] cArray = new char[s2.length()];
            s2.getChars(0, s2.length(), cArray, 0);
            StringBuilder stringBuilder = new StringBuilder(cArray.length + 16);
            do {
                stringBuilder.append(cArray, n3, n2 - n3 + 1);
            } while ((n2 = s2.indexOf(39, (n3 = n2) + 1)) >= 0);
            if (n3 < cArray.length) {
                stringBuilder.append(cArray, n3, cArray.length - n3);
            }
            s2 = stringBuilder.toString();
        }
        return "'" + s2 + "'";
    }

    public boolean isUseOrderBy() {
        return this.getConfiguration().isUseOrderBy();
    }

    public void setUseOrderBy(boolean useOrderBy) {
        this.getConfiguration().setUseOrderBy(useOrderBy, true);
    }

    public boolean isUseParenthesiseForJoin() {
        return this.getConfiguration().isUseParenthesiseForJoin();
    }

    public void setUseParenthesiseForJoin(boolean useParenthesiseForJoin) {
        this.getConfiguration().setUseParenthesiseForJoin(useParenthesiseForJoin, true);
    }

    public boolean isUseQuoteLowerCase() {
        return this.getConfiguration().isUseQuoteLowerCase();
    }

    public void setUseQuoteLowerCase(boolean useQuoteLowerCase) {
        this.getConfiguration().setUseQuoteLowerCase(useQuoteLowerCase, true);
    }

    public boolean isUseSQL92syntax() {
        return this.getConfiguration().isUseSQL92syntax();
    }

    public void setUseSQL92syntax(boolean useSQL92syntax) {
        this.getConfiguration().setUseSQL92syntax(useSQL92syntax, false, true);
    }

    public boolean isUseWhereClause() {
        return this.getConfiguration().isUseWhereClause();
    }

    public void setUseWhereClause(boolean useWhereClause) {
        this.getConfiguration().setUseWhereClause(useWhereClause, true);
    }

    @Deprecated
    public String getAliasToken() {
        return this.getConfiguration().getAliasToken();
    }

    @Deprecated
    public void setAliasToken(String aliasToken) {
        this.getConfiguration().setAliasToken(aliasToken, true);
    }

    public String getIdentifierQuoteString() {
        return this.getConfiguration().getIdentifierQuoteString();
    }

    public void setIdentifierQuoteString(String quoteString) {
        this.getConfiguration().setIdentifierQuoteString(quoteString, true);
    }

    public boolean isEscapeEverything() {
        return this.getConfiguration().isUseEscapeEverything();
    }

    public void setUseEscapeEverything(boolean escapeEvreything) {
        this.getConfiguration().setUseEscapeEverything(escapeEvreything, true);
    }

    protected void findColumnLabels(TableSource tableSource) {
        int n2 = tableSource.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            tableSource.getDatabaseField(i2).setColumnLabel(null);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.initTransient();
    }

    @Override
    public String toSQL92(String function, Field field) throws ReportException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("{fn ").append(function).append('(').append(field.getValue()).append(")}");
        return stringBuilder.toString();
    }

    @Override
    public String convertToBoolean(boolean value) {
        return value ? "(1=1)" : "(1=0)";
    }

    @Override
    public String convertToBoolean(String fieldReference, boolean invert) {
        return fieldReference + (invert ? " = 0" : " <> 0");
    }

    @Override
    public String convertIdentifier(Datasource ds, String identifier) {
        return this.getSqlIdentifier(ds, identifier, false);
    }

    bo bC() {
        return new bo(this.getConfiguration(), this.getSqlSyntax(), this.kn);
    }

    @Override
    public SqlSyntax getSqlSyntax() {
        return this;
    }

    @Override
    public void fetchData(Engine engine, FetchTables fetchTables, DataCollector dataCollector) throws ReportException {
        bn bn2 = new bn(engine.bM());
        d d2 = (d)fetchTables;
        this.kn = d2.oH();
        bn2.a(d2, dataCollector);
    }
}

