/*
 * Decompiled with CFR 0.152.
 */
package com.inet.problemfinder.rules;

import com.inet.problemfinder.ProblemFinderWarning;
import com.inet.problemfinder.ProblemFinderWarningImpl;
import com.inet.problemfinder.i18n.Msg;
import com.inet.problemfinder.rules.AbstractRuleField;
import com.inet.report.BaseUtils;
import com.inet.report.Engine;
import com.inet.report.Field;
import com.inet.report.FormulaField;
import com.inet.report.ReportException;
import com.inet.report.Validatable;
import com.inet.report.Validity;
import com.inet.report.i18n.ReportErrorCode;
import java.util.List;
import javax.swing.AbstractAction;

public class RuleFieldValid
extends AbstractRuleField {
    @Override
    public List<ProblemFinderWarning> findErrors(Engine engine) {
        List<ProblemFinderWarning> list;
        block5: {
            list = super.findErrors(engine);
            if (engine == null) {
                return list;
            }
            try {
                ProblemFinderWarning problemFinderWarning;
                Object object;
                FormulaField formulaField = engine.getSFField();
                if (formulaField != null && (object = this.a(engine, formulaField)) != null) {
                    list.add((ProblemFinderWarning)object);
                }
                if ((object = engine.getGFField()) != null && (problemFinderWarning = this.a(engine, (Field)object)) != null) {
                    list.add(problemFinderWarning);
                }
            }
            catch (ReportException reportException) {
                if (!BaseUtils.isDebug()) break block5;
                BaseUtils.debug(reportException);
            }
        }
        return list;
    }

    @Override
    protected ProblemFinderWarning check(Engine engine, Field field) {
        Validity validity;
        ProblemFinderWarningImpl problemFinderWarningImpl = null;
        if (field instanceof Validatable && (validity = ((Validatable)((Object)field)).validate()) != null) {
            Validity.States states = validity.getState();
            String string = Msg.getFieldDisplayName(field);
            String string2 = Msg.getMsg("ProblemFinder.Rule.FieldValid.warn", string);
            if (validity.getErrorData() instanceof ReportException) {
                ReportException reportException = (ReportException)validity.getErrorData();
                if (reportException.getErrorCode() == ReportErrorCode.WarningPrintedArray.getErrorCodeNumber()) {
                    return null;
                }
                string2 = reportException.getLocalizedMessage();
            }
            if (states == Validity.States.WARNING) {
                problemFinderWarningImpl = new ProblemFinderWarningImpl(field, ProblemFinderWarning.Type.WARNING, this, string2, string, new AbstractAction[0]);
            } else if (states == Validity.States.ERROR || states == Validity.States.DEPENDING_ERROR) {
                problemFinderWarningImpl = new ProblemFinderWarningImpl(field, ProblemFinderWarning.Type.ERROR, this, string2, string, new AbstractAction[0]);
            }
        }
        return problemFinderWarningImpl;
    }

    @Override
    public String getRuleLabel() {
        return Msg.getMsg("ProblemFinder.Rule.FieldValid.label");
    }

    private ProblemFinderWarning a(Engine engine, Field field) {
        ProblemFinderWarningImpl problemFinderWarningImpl = null;
        FormulaField formulaField = (FormulaField)field;
        boolean bl2 = false;
        try {
            bl2 = FormulaField.isEmpty(formulaField.getFormula(), formulaField.getSyntax() == 1002, engine);
        }
        catch (ReportException reportException) {
            // empty catch block
        }
        if (!bl2) {
            String string = null;
            try {
                string = formulaField.getFormulaType() == 1 ? Msg.getMsg("Record_Selection") : Msg.getMsg("Group_selection_formula");
                int n2 = formulaField.checkFormula(formulaField.getFormula(), formulaField.getSyntax() == 1002, formulaField.getNullBehavior());
                if (n2 != 8) {
                    problemFinderWarningImpl = new ProblemFinderWarningImpl(field, ProblemFinderWarning.Type.WARNING, this, Msg.getMsg("ProblemFinder.The_selection_formula_does_not_have_the_return_type_boolean"), string, new AbstractAction[0]);
                }
            }
            catch (ReportException reportException) {
                ProblemFinderWarning.Type type = reportException.getErrorCode() < 0 ? ProblemFinderWarning.Type.WARNING : ProblemFinderWarning.Type.ERROR;
                String string2 = reportException.getErrorCode() < 0 ? Msg.getMsg("ProblemFinder.Rule.FieldValid.warning", string) : Msg.getMsg("ProblemFinder.Rule.FieldValid.warn", string);
                problemFinderWarningImpl = new ProblemFinderWarningImpl(field, type, this, string2, string, new AbstractAction[0]);
            }
        }
        return problemFinderWarningImpl;
    }
}

