/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.pdf;

import com.inet.annotations.InternalApi;
import com.inet.config.ConfigKey;
import com.inet.config.ConfigValue;
import com.inet.config.ConfigurationManager;
import com.inet.lib.json.Json;
import com.inet.report.renderer.pdf.l;
import com.inet.report.renderer.pdf.m;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

@InternalApi
public class PDFConfig {
    private static final ConfigValue<Boolean> aUK = new ConfigValue(ConfigKey.PDF_REPLACE_NOT_EMBEDDED_FONTS);
    private static final ConfigValue<Boolean> aUL = new ConfigValue(ConfigKey.TAGGED_PDF);
    private boolean aUn = (Boolean)aUK.get();
    private boolean aUM;
    private boolean aUN;
    private boolean aUO = (Boolean)aUL.get();
    private l aUP;
    private m aUQ;

    public boolean isNoTransparency() {
        return this.aUM;
    }

    public void setPdfA(@Nullable l pdfA) {
        this.aUP = pdfA;
        if (pdfA != null) {
            this.aUn = true;
            if (pdfA == l.aWs) {
                this.aUM = true;
            }
        }
    }

    @Nullable
    public l getPdfA() {
        return this.aUP;
    }

    public void setPdfUA(@Nullable m pdfUA) {
        this.aUQ = pdfUA;
        if (pdfUA != null) {
            this.aUn = true;
            this.aUO = true;
        }
    }

    @Nullable
    public m getPdfUA() {
        return this.aUQ;
    }

    public void setLinear(boolean linear) {
        this.aUN = linear;
    }

    public boolean isLinear() {
        return this.aUN;
    }

    public boolean isSignatureEnabled() {
        return false;
    }

    public boolean isReplaceMissingChars() {
        return true;
    }

    public boolean isCompression() {
        return false;
    }

    public boolean isMapAdobeFonts() {
        return true;
    }

    public int getAsianEncodingCodePage() {
        return 932;
    }

    public void setCreateStructure(boolean setStructure) {
        this.aUO = setStructure;
    }

    public boolean isCreateStructure() {
        return this.aUO;
    }

    public boolean isReplaceNotEmbeddedFonts() {
        return this.aUn;
    }

    @Nullable
    public List<String> getListOfPreferredSerifFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_SERIF_FONT_LIST.getKey(), ConfigKey.PDF_SERIF_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @Nullable
    public List<String> getListOfPreferredSansSerifFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_SANSSERIF_FONT_LIST.getKey(), ConfigKey.PDF_SANSSERIF_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }

    @Nullable
    public List<String> getListOfPreferredMonospacedFontNames() {
        String string = ConfigurationManager.getInstance().getCurrent().get(ConfigKey.PDF_MONOSPACED_FONT_LIST.getKey(), ConfigKey.PDF_MONOSPACED_FONT_LIST.getDefault());
        String[] stringArray = (String[])new Json().fromJson(string, String[].class);
        return Arrays.asList(stringArray);
    }
}

