/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.renderer.pdf;

import com.inet.annotations.InternalApi;
import com.inet.cache.image.SerializableImage;
import com.inet.font.layout.FontLayout;
import com.inet.font.layout.FontMetricsFromLayout;
import com.inet.graphics.GraphicsBase;
import com.inet.report.renderer.pdf.b;
import com.inet.report.renderer.pdf.c;
import com.inet.report.renderer.pdf.g;
import com.inet.report.renderer.pdf.model.ab;
import com.inet.report.renderer.pdf.model.am;
import com.inet.report.renderer.pdf.model.at;
import com.inet.report.renderer.pdf.model.m;
import com.inet.report.renderer.pdf.model.s;
import com.inet.report.renderer.pdf.model.t;
import com.inet.report.renderer.pdf.model.y;
import com.inet.report.renderer.pdf.model.z;
import com.inet.report.util.UnitUtils;
import com.inet.report.util.f;
import com.inet.shared.bidi.BidiString;
import com.inet.shared.utils.BlendComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.GlyphVector;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

@InternalApi
public class GraphicsPDF
extends GraphicsBase {
    private AffineTransform aUo;
    private a aUp;
    private LinkedList<am> aUq = new LinkedList();
    private LinkedList<at> aUr = new LinkedList();
    private LinkedList<g> aUs = new LinkedList();
    private m aUg;
    private boolean aUt;
    private boolean aUu = false;
    private int aUv;
    private c aUw;
    Boolean aUx = false;
    AtomicInteger aUy = new AtomicInteger(0);

    public GraphicsPDF(am page, at stream, double x2, double y2, double w2, double h2, c canvas) {
        this.aUq.add(page);
        this.aUr.add(stream);
        this.aUw = canvas;
        this.aUg = page.GG();
        this.aUt = true;
        this.aUs.add(new g(this));
        this.aUv = stream.IH().getLength();
        this.aUp = new a(this);
        this.aUo = new AffineTransform(0.75, 0.0, 0.0, -0.75, x2, y2);
        this.getInternalTransform().setTransform(this.aUo);
        stream.cR("graphics [[[[");
        stream.IN();
        Rectangle2D.Double double_ = new Rectangle2D.Double(x2, y2 + h2, w2, -h2);
        stream.e(double_);
        stream.IL();
        stream.IM();
        stream.IN();
        if (this.aUg.HX() != null) {
            this.aUg.HX().ar(stream.IH());
        }
        this.aUu = this.aUg.HW().isNoTransparency() && this.getGraphicStates().GM().getColor().getAlpha() == 0;
    }

    private GraphicsPDF(GraphicsPDF parent) {
        this.aUg = parent.aUg;
        this.aUq = parent.aUq;
        this.aUr.addAll(parent.aUr);
        this.aUg = parent.aUg;
        this.aUt = false;
        this.aUo = parent.aUo;
        this.aUp = parent.aUp;
        this.aUx = parent.aUx;
        this.aUy = parent.aUy;
        this.aUs = new LinkedList();
        for (g g2 : parent.aUs) {
            this.aUs.add(g2.a(this));
        }
        this.getInternalTransform().setTransform(parent.getInternalTransform());
        this.setPaint(parent.getPaint());
        this.setClip(parent.getClip());
        this.setStroke(parent.getStroke());
        this.setComposite(parent.getComposite());
        this.setFont(parent.getFont());
        this.aUu = this.aUg.HW().isNoTransparency() && this.getGraphicStates().GM().getColor().getAlpha() == 0;
    }

    private static AffineTransform z(int n2, int n3, int n4, int n5) {
        return new AffineTransform(n4, 0.0f, 0.0f, -n5, n2, n3 + n5);
    }

    public static void notSupported(String string) {
        GraphicsBase.notSupported((String)string);
    }

    public am getPage() {
        return this.aUq.getLast();
    }

    public at getStream() {
        return this.aUr.getLast();
    }

    public g getGraphicStates() {
        return this.aUs.getLast();
    }

    public void dispose() {
        if (!this.aUt) {
            return;
        }
        this.aUt = false;
        this.getStream().IP();
        this.getStream().cR("]]]] graphics");
        if (this.aUg.HX() != null) {
            this.aUg.HX().as(this.getStream().IH());
        }
    }

    protected void setTransformImpl(AffineTransform tx) {
        this.getGraphicStates().GO();
    }

    protected void transformImpl(AffineTransform tx) {
        this.getGraphicStates().GO();
    }

    public void transform(AffineTransform tx) {
        if (this.getGraphicStates().GM() == this) {
            super.transform(tx);
        } else {
            this.getGraphicStates().GM().transform(tx);
        }
    }

    public void setTransform(AffineTransform tx) {
        if (this.getGraphicStates().GM() == this) {
            super.setTransform(tx);
        } else {
            this.getGraphicStates().GM().setTransform(tx);
        }
    }

    public void draw(Shape s2) {
        if (this.aUu) {
            return;
        }
        Stroke stroke = this.getStroke();
        if (stroke instanceof BasicStroke) {
            this.getStream().cR("draw " + String.valueOf(s2) + " [[");
            this.a(3, s2.getBounds(), s2);
            this.getStream().e(s2);
            this.getStream().IK();
            this.getStream().cR("]] draw");
        } else {
            this.getStream().cR("draw stroked shape [[");
            this.fill(stroke.createStrokedShape(s2));
            this.getStream().cR("]] draw stroked shape");
        }
    }

    public void fill(Shape s2) {
        if (this.aUu) {
            return;
        }
        this.getStream().cR("fill " + String.valueOf(s2) + " [[");
        this.a(1, s2.getBounds(), s2);
        boolean bl2 = this.getStream().e(s2);
        this.getStream().cf(bl2);
        this.getStream().cR("]] fill");
    }

    public void clip(Shape s2) {
        if (this.getGraphicStates().GM() == this) {
            super.clip(s2);
            this.getGraphicStates().GN();
        } else {
            this.getGraphicStates().GM().clip(s2);
        }
    }

    public void setClip(Shape clip) {
        if (this.getGraphicStates().GM() == this) {
            super.setClip(clip);
            this.getGraphicStates().GN();
        } else {
            this.getGraphicStates().GM().setClip(clip);
        }
    }

    public Stroke getStroke() {
        if (this.getGraphicStates().GM() == this) {
            return super.getStroke();
        }
        return this.getGraphicStates().GM().getStroke();
    }

    public void setStroke(Stroke s2) {
        if (this.getGraphicStates().GM() == this) {
            super.setStroke(s2);
        } else {
            this.getGraphicStates().GM().setStroke(s2);
        }
    }

    public void setComposite(Composite comp) {
        if (this.getGraphicStates().GM() == this) {
            super.setComposite(comp);
            this.getGraphicStates().setPaintChanged();
        } else {
            this.getGraphicStates().GM().setComposite(comp);
        }
    }

    public void setColor(Color c2) {
        if (this.getGraphicStates().GM() == this) {
            super.setColor(c2);
            this.getGraphicStates().setPaintChanged();
        } else {
            this.getGraphicStates().GM().setColor(c2);
        }
        this.aUu = this.aUg.HW().isNoTransparency() && c2.getAlpha() == 0;
    }

    public Color getColor() {
        if (this.getGraphicStates().GM() == this) {
            return super.getColor();
        }
        return this.getGraphicStates().GM().getColor();
    }

    public Font getFont() {
        if (this.getGraphicStates().GM() == this) {
            return super.getFont();
        }
        return this.getGraphicStates().GM().getFont();
    }

    public FontMetrics getFontMetrics() {
        if (this.getGraphicStates().GM() == this) {
            return super.getFontMetrics();
        }
        return this.getGraphicStates().GM().getFontMetrics();
    }

    protected void setStrokeChanged() {
        if (this.getGraphicStates().GM() == this) {
            super.setStrokeChanged();
            this.getGraphicStates().setStrokeChanged();
        } else {
            this.getGraphicStates().GM().setStrokeChanged();
        }
    }

    public void setFont(Font font) {
        if (this.getGraphicStates().GM() == this) {
            super.setFont(font);
        } else {
            this.getGraphicStates().GM().setFont(font);
        }
    }

    protected AffineTransform getInternalTransform() {
        this.getGraphicStates().GO();
        return super.getInternalTransform();
    }

    protected void setPaintChanged() {
        super.setPaintChanged();
        this.getGraphicStates().setPaintChanged();
    }

    public Shape getClip() {
        if (this.getGraphicStates().GM() == this) {
            return super.getClip();
        }
        return this.getGraphicStates().GM().getClip();
    }

    public Shape getRenderClip() {
        Iterator iterator = this.aUs.iterator();
        Area area = null;
        while (iterator.hasNext()) {
            Shape shape;
            g g2 = (g)iterator.next();
            if (area != null) {
                area = area.createTransformedArea(g2.GM().getTransform());
            }
            if ((shape = g2.GM().getClip()) == null) continue;
            if (area == null) {
                area = new Area(shape);
                continue;
            }
            area.intersect(new Area(shape));
        }
        return area;
    }

    private void a(int n2, Rectangle2D rectangle2D, Shape shape) {
        this.getGraphicStates().a(this.getGraphicStates().GM(), n2, rectangle2D, shape);
    }

    public void drawString(String str, int x2, int y2) {
        this.drawString(str, (float)x2, (float)y2);
    }

    public void drawString(String str, float x2, float y2) {
        if (this.aUu) {
            return;
        }
        Rectangle2D rectangle2D = this.getFont().getStringBounds(str, this.getFontRenderContext());
        rectangle2D.setRect(rectangle2D.getX() + (double)x2, rectangle2D.getY() + (double)y2, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.a(1, rectangle2D, null);
        if (BidiString.hasHindiCharacters((String)str)) {
            new TextLayout(str, this.getFont(), this.getFontRenderContext()).draw((Graphics2D)((Object)this), x2, y2);
            return;
        }
        this.getStream().IQ();
        Font font = this.getFont();
        int n2 = UnitUtils.pointsToTwips(font.getSize2D());
        s s2 = this.aUg.HT().a(font.getName(), font.getStyle(), n2, str, this.getPage());
        if (s2.Ib()) {
            this.getStream().w(0.12);
            this.getStream().ho(2);
        } else {
            this.getStream().ho(0);
        }
        str = BidiString.reorder((String)str);
        Map<TextAttribute, ?> map = font.getAttributes();
        Object obj = map.get(TextAttribute.TRACKING);
        if (obj instanceof Float && ((Float)obj).floatValue() != 0.0f) {
            this.getStream().x(((Float)obj).floatValue());
        }
        AffineTransform affineTransform = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, x2, y2);
        if (s2.Ic()) {
            affineTransform.concatenate(com.inet.report.renderer.pdf.model.a.aZT);
        }
        this.getStream().s(s2.getKey(), n2);
        this.getStream().h(affineTransform);
        this.getStream().a(str, s2);
        this.getStream().IR();
    }

    public void drawString(AttributedCharacterIterator iterator, int x2, int y2) {
        this.drawString(iterator, (float)x2, (float)y2);
    }

    public void drawString(AttributedCharacterIterator iterator, float x2, float y2) {
        GraphicsPDF.notSupported("GraphicsPDF.drawString(AttributedCharacterIterator)");
    }

    public void drawGlyphVector(GlyphVector g2, float x2, float y2) {
        if (this.aUu) {
            return;
        }
        this.fill(g2.getOutline(x2, y2));
    }

    public Graphics create() {
        return new GraphicsPDF(this);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.aUu) {
            return;
        }
        this.a(3, new Rectangle(Math.min(x1, x2), Math.min(y1, y2), Math.max(1, Math.abs(x2 - x1)), Math.max(1, Math.abs(y2 - y1))), null);
        this.getStream().d(x1, y1);
        this.getStream().e(x2, y2);
        this.getStream().IK();
    }

    public void addLayer(boolean knockout, boolean isolate, BlendComposite composite) {
        this.a(1, null, null);
        t t2 = new t(this.getPage().GG(), this.getPage().IB(), this.getStream(), new y(isolate, knockout));
        String string = this.getPage().e(t2);
        String string2 = null;
        if (composite.getMode() != BlendComposite.BlendingMode.NORMAL || composite.getMask() != null || (double)composite.getAlpha() < 1.0) {
            string2 = this.getPage().a(this.aUq.getLast().GG(), composite);
        }
        this.aUq.add(t2);
        this.getStream().cR("addLayer() [[ ");
        if (string2 != null) {
            this.getStream().di(string2);
        }
        this.getStream().dh(string);
        this.getStream().cR("]] addLayer()");
        this.aUr.add(t2.IC());
        GraphicsPDF graphicsPDF = (GraphicsPDF)((Object)this.create());
        graphicsPDF.aUx = false;
        graphicsPDF.aUs = new LinkedList();
        graphicsPDF.aUs.add(this.aUs.getLast().a(graphicsPDF));
        graphicsPDF.getInternalTransform().setTransform(new AffineTransform());
        graphicsPDF.setClip(null);
        graphicsPDF.aUs.clear();
        g g2 = new g(graphicsPDF);
        graphicsPDF.aUp = new a(graphicsPDF);
        graphicsPDF.aUs.add(g2);
        this.aUs.add(g2);
    }

    public void paintLastLayer() throws IllegalStateException {
        if (this.aUr.isEmpty() || this.aUq.isEmpty() || this.aUs.isEmpty()) {
            throw new IllegalArgumentException("No layer available.\nStream " + this.aUr.isEmpty() + "\nPage " + this.aUq.isEmpty() + "\nState " + this.aUs.isEmpty());
        }
        this.aUr.getLast().cR("Close in Layer if necessary");
        this.getStream().IP();
        this.aUq.removeLast();
        this.aUr.getLast().cR("RemoveLayer");
        this.aUr.removeLast();
        this.aUs.removeLast();
        super.setPaint(this.aUs.getLast().getPaint());
        if (this.aUr.isEmpty()) {
            throw new IllegalArgumentException("One layer to much removed!");
        }
    }

    public void fillRect(int x2, int y2, int width, int height) {
        if (this.aUu) {
            return;
        }
        this.a(1, new Rectangle(x2, y2, width, height), null);
        this.getStream().c(x2, y2, width, height);
        this.getStream().cf(false);
    }

    public void drawRect(int x2, int y2, int width, int height) {
        if (this.aUu) {
            return;
        }
        this.a(3, new Rectangle(x2, y2, width, height), null);
        this.getStream().c(x2, y2, width, height);
        this.getStream().IK();
    }

    public void fillRoundRect(int x2, int y2, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x2, y2, width, height, arcWidth, arcHeight));
    }

    public void drawRoundRect(int x2, int y2, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x2, y2, width, height, arcWidth, arcHeight));
    }

    public void drawOval(int x2, int y2, int width, int height) {
        this.draw(new Ellipse2D.Double(x2, y2, width, height));
    }

    public void fillOval(int x2, int y2, int width, int height) {
        this.fill(new Ellipse2D.Double(x2, y2, width, height));
    }

    public void drawArc(int x2, int y2, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Float(x2, y2, width, height, startAngle, arcAngle, 0));
    }

    public void fillArc(int x2, int y2, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Float(x2, y2, width, height, startAngle, arcAngle, 2));
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(xPoints[0], yPoints[0]);
        for (int i2 = 1; i2 < nPoints; ++i2) {
            generalPath.lineTo(xPoints[i2], yPoints[i2]);
        }
        this.draw(generalPath);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.draw(new Polygon(xPoints, yPoints, nPoints));
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.fill(new Polygon(xPoints, yPoints, nPoints));
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x2, int y2) {
        this.drawImage((Image)op.filter(img, null), x2, y2, null);
    }

    public boolean drawImage(Image img, int x2, int y2, ImageObserver observer) {
        return this.drawImage(img, x2, y2, img.getWidth(observer), img.getHeight(observer), observer);
    }

    public boolean drawImage(Image img, int x2, int y2, int width, int height, ImageObserver observer) {
        this.a(img, GraphicsPDF.z(x2, y2, width, height));
        return true;
    }

    public boolean drawImage(Image img, int x2, int y2, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x2, y2, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x2, int y2, int width, int height, Color bgcolor, ImageObserver observer) {
        Color color = this.getColor();
        this.setColor(bgcolor);
        this.fillRect(x2, y2, width, height);
        this.setColor(color);
        return this.drawImage(img, x2, y2, width, height, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        int n2 = sx2 - sx1;
        int n3 = sy2 - sy1;
        f.c(img);
        BufferedImage bufferedImage = f.bG(n2, n3);
        bufferedImage.createGraphics().drawImage(img, 0, 0, n2, n3, sx1, sy1, sx2, sy2, observer);
        if (bgcolor != null) {
            Color color = this.getColor();
            this.setColor(bgcolor);
            this.fillRect(dx1, dy1, dx2 - dx1, dy2 - dy1);
            this.setColor(color);
        }
        return this.drawImage(bufferedImage, dx1, dy1, dx2 - dx1, dy2 - dy1, null);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        AffineTransform affineTransform = new AffineTransform(xform);
        affineTransform.concatenate(GraphicsPDF.z(0, 0, img.getWidth(obs), img.getHeight(obs)));
        this.a(img, affineTransform);
        return true;
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        AffineTransform affineTransform = new AffineTransform(xform);
        affineTransform.concatenate(GraphicsPDF.z(0, 0, img.getWidth(), img.getHeight()));
        this.a(ab.b(img), affineTransform);
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        this.drawRenderedImage(img.createDefaultRendering(), xform);
    }

    private void a(Image image, AffineTransform affineTransform) {
        ab ab2;
        Object object;
        this.a(1, null, null);
        byte[] byArray = null;
        String string = null;
        if (image instanceof SerializableImage && (object = (SerializableImage)image).getPersistenceKey() != null) {
            string = object.getPersistenceKey().keyValue();
            byArray = object.getRawData();
        }
        if (string == null) {
            object = new b();
            ab2 = ((b)object).a(this.aUg, image, byArray, image.getWidth(null), image.getHeight(null), -1);
        } else {
            ab2 = this.aUq.getLast().GG().HV().get(string);
            if (ab2 == null) {
                object = new b();
                ab2 = ((b)object).a(this.aUg, image, byArray, image.getWidth(null), image.getHeight(null), -1);
                this.aUq.getLast().GG().HV().put(string, ab2);
            }
        }
        this.aUq.getLast().a(ab2);
        this.getStream().cR("drawImage() [[ ");
        this.getStream().IN();
        this.getStream().g(affineTransform);
        this.getStream().dh(ab2.getKey());
        this.getStream().IO();
        this.getStream().cR("]] drawImage()");
    }

    public void copyArea(int x2, int y2, int width, int height, int dx, int dy) {
        GraphicsPDF.notSupported("copyArea()");
    }

    public void rollback() {
        this.getStream().IH().setLength(this.aUv);
        this.aUt = false;
    }

    public FontMetrics getFontMetrics(Font font) {
        FontLayout fontLayout = this.aUg.HT().c(font.getName(), font.getStyle(), UnitUtils.pixelToTwips(font.getSize()), "", this.aUq.getLast());
        return new FontMetricsFromLayout(fontLayout, font);
    }

    public void annotateHighlight(Rectangle2D[] rects, String text, Color color) {
        AffineTransform affineTransform = this.getInternalTransform();
        for (int i2 = 0; i2 < rects.length; ++i2) {
            rects[i2] = affineTransform.createTransformedShape(rects[i2]).getBounds2D();
        }
        z z2 = new z(this.aUg, rects);
        z2.setText(text);
        z2.setColor(color);
        this.aUw.a(z2);
    }

    public class a {
        private GraphicsPDF aUz;
        private GraphicsPDF aUA;

        public a(GraphicsPDF graphicsPDF2) {
            this.aUz = graphicsPDF2;
            this.aUA = graphicsPDF2;
        }
    }
}

