/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.list;

import com.inet.annotations.InternalApi;
import com.inet.report.BaseUtils;
import com.inet.report.DatabaseField;
import com.inet.report.Field;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

@InternalApi
public final class DatabaseFieldList
implements Externalizable,
Cloneable {
    private boolean avO = false;
    private DatabaseField[] avP;
    private int MZ;
    private int avQ;

    public DatabaseFieldList() {
        this(10);
    }

    public DatabaseFieldList(Vector v2) {
        this(v2.size());
        v2.copyInto(this.avP);
        this.MZ = v2.size();
    }

    public DatabaseFieldList(DatabaseFieldList o2) {
        this(o2.size());
        System.arraycopy(o2.avP, 0, this.avP, 0, o2.MZ);
        this.MZ = o2.MZ;
    }

    public DatabaseFieldList(int capacity) {
        this(capacity, 0);
    }

    public DatabaseFieldList(int capacity, int capacityIncrement) {
        this.avP = new DatabaseField[capacity];
        this.avQ = capacityIncrement;
    }

    public void setAllowDuplicatedEntries(boolean allow) {
        this.avO = allow;
    }

    public final DatabaseField elementAt(int idx) {
        if (idx < this.MZ) {
            return this.avP[idx];
        }
        throw new ArrayIndexOutOfBoundsException(idx);
    }

    public final void setCapacity(int capacity) {
        if (capacity < this.MZ) {
            this.MZ = capacity;
        }
        if (capacity != this.avP.length) {
            DatabaseField[] databaseFieldArray = new DatabaseField[capacity];
            System.arraycopy(this.avP, 0, databaseFieldArray, 0, this.MZ);
            this.avP = databaseFieldArray;
        }
    }

    private final void es(int n2) {
        int n3 = this.avP.length;
        if (n2 > n3) {
            if (this.avQ > 0) {
                while ((n3 += this.avQ) < n2) {
                }
            } else {
                if (n3 == 0) {
                    n3 = 1;
                }
                while ((n3 = 2 * n3) < n2) {
                }
            }
        } else if (n3 > 100000 && n3 > 2 * n2) {
            n3 = this.avQ > 0 ? n2 + this.avQ : n2 * 2;
        }
        int n4 = n3;
        if (n4 != this.avP.length) {
            this.setCapacity(n4);
        }
    }

    public final void addElement(DatabaseField o2) {
        if (o2 == null) {
            throw new NullPointerException();
        }
        if (this.indexOf(o2) == -1 || this.avO) {
            if (this.MZ >= this.avP.length) {
                this.es(this.MZ + 1);
            }
            this.avP[this.MZ] = o2;
            ++this.MZ;
        }
    }

    public final void insertElementAt(DatabaseField o2, int index) {
        if (o2 == null) {
            throw new NullPointerException();
        }
        if (index > this.MZ) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.es(this.MZ + 1);
        System.arraycopy(this.avP, index, this.avP, index + 1, this.MZ - index);
        this.avP[index] = o2;
        ++this.MZ;
    }

    public final DatabaseField removeElementAt(int idx) {
        DatabaseField databaseField = this.avP[idx];
        if (idx < this.MZ - 1) {
            System.arraycopy(this.avP, idx + 1, this.avP, idx, this.MZ - idx - 1);
        }
        this.avP[--this.MZ] = null;
        return databaseField;
    }

    public final int size() {
        return this.MZ;
    }

    public final void setSize(int size) {
        for (int i2 = size; i2 < this.MZ; ++i2) {
            this.avP[i2] = null;
        }
        this.es(size);
        this.MZ = size;
    }

    public final void clear() {
        this.setSize(0);
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.MZ);
        for (int i2 = 0; i2 < this.MZ; ++i2) {
            out.writeObject(this.avP[i2]);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.MZ = in.readInt();
        if (this.avP.length < this.MZ) {
            this.avP = new DatabaseField[this.MZ];
        }
        for (int i2 = 0; i2 < this.MZ; ++i2) {
            this.avP[i2] = (DatabaseField)in.readObject();
        }
    }

    public final int indexOf(DatabaseField o2) {
        if (o2 == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.avP.length; ++i2) {
            if (this.avP[i2] != o2) continue;
            return i2;
        }
        return this.indexOf(o2.getName());
    }

    public final int indexOf(String fieldName) {
        if (fieldName == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.avP.length; ++i2) {
            if (!fieldName.equalsIgnoreCase(this.avP[i2] != null ? this.avP[i2].getName() : null)) continue;
            return i2;
        }
        return -1;
    }

    public final int indexOfShortName(String fieldName) {
        if (fieldName == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.avP.length; ++i2) {
            if (!fieldName.equalsIgnoreCase(this.avP[i2] != null ? this.avP[i2].getShortName() : null)) continue;
            return i2;
        }
        return -1;
    }

    public final void removeElement(DatabaseField o2) {
        int n2 = this.indexOf(o2);
        if (n2 < 0) {
            return;
        }
        this.removeElementAt(n2);
    }

    public final Vector toVector() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(this.MZ);
        for (int i2 = 0; i2 < this.MZ; ++i2) {
            vector.addElement(this.avP[i2]);
        }
        return vector;
    }

    public final boolean contains(DatabaseField o2) {
        return this.indexOf(o2) >= 0;
    }

    public final boolean contains(String fieldName) {
        return this.indexOf(fieldName) >= 0;
    }

    public final DatabaseField get(String fieldName) {
        int n2 = this.indexOf(fieldName);
        return n2 >= 0 ? this.elementAt(n2) : null;
    }

    public final DatabaseField[] toArray() {
        return this.toArray(new DatabaseField[this.MZ]);
    }

    public final List<Field> toFieldList() {
        ArrayList<Field> arrayList = new ArrayList<Field>(this.MZ);
        for (int i2 = 0; i2 < this.size(); ++i2) {
            arrayList.add(this.elementAt(i2));
        }
        return arrayList;
    }

    public final DatabaseField[] toArray(DatabaseField[] o2) {
        if (o2 == null || o2.length != this.MZ) {
            o2 = new DatabaseField[this.MZ];
        }
        System.arraycopy(this.avP, 0, o2, 0, this.MZ);
        return o2;
    }

    public final void copyInto(DatabaseField[] o2) {
        if (o2 == null || o2.length != this.MZ) {
            throw new RuntimeException();
        }
        System.arraycopy(this.avP, 0, o2, 0, this.MZ);
    }

    public final void addAll(DatabaseFieldList o2) {
        this.es(this.MZ + o2.MZ);
        for (int i2 = 0; i2 < o2.size(); ++i2) {
            this.addElement(o2.elementAt(i2));
        }
    }

    public final void addAll(DatabaseField[] o2) {
        if (o2 == null) {
            return;
        }
        this.es(this.MZ + o2.length);
        for (int i2 = 0; i2 < o2.length; ++i2) {
            this.addElement(o2[i2]);
        }
    }

    public final void setElementAt(DatabaseField o2, int index) {
        if (index >= this.MZ) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        this.avP[index] = o2;
    }

    public final DatabaseField lastElement() {
        return this.avP[this.MZ - 1];
    }

    public final Object clone() {
        DatabaseFieldList databaseFieldList = null;
        try {
            databaseFieldList = (DatabaseFieldList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException();
        }
        databaseFieldList.avP = new DatabaseField[this.avP.length];
        System.arraycopy(this.avP, 0, databaseFieldList.avP, 0, this.MZ);
        return databaseFieldList;
    }

    public final boolean isEmpty() {
        return this.MZ == 0;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        for (int i2 = 0; i2 < this.MZ; ++i2) {
            if (i2 > 0) {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(this.avP[i2]);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    public final Object getObjectAt(int i2) {
        return this.elementAt(i2);
    }

    public void log() {
        if (BaseUtils.isDebug()) {
            try {
                for (int i2 = 0; i2 < this.size(); ++i2) {
                    DatabaseField databaseField = this.elementAt(i2);
                    int n2 = databaseField.getValueType();
                    String string = databaseField.getShortName();
                    String string2 = databaseField.getName();
                    String string3 = string;
                    if (string2 != null) {
                        string3 = string2;
                    }
                    BaseUtils.debug("FieldList Column: " + i2 + " name: " + string3 + " type: " + n2);
                }
            }
            catch (Throwable throwable) {
                BaseUtils.info(throwable);
            }
        }
    }
}

