/*
 * Decompiled with CFR 0.152.
 */
package com.inet.report.cache;

import com.inet.annotations.PublicApi;
import com.inet.error.WrappedRuntimeException;
import com.inet.lib.io.ChunkedInputStream;
import com.inet.report.ReportException;
import com.inet.report.cache.Cache;
import com.inet.report.cache.ReportCacheKey;

@PublicApi
public class ReportCacheInputStream
extends ChunkedInputStream {
    private ReportCacheKey ho;
    private int page;
    private int Vq;

    public ReportCacheInputStream(ReportCacheKey key, int timeout) {
        super(ReportCacheInputStream.a(key, 1, timeout));
        this.ho = key;
        this.page = 1;
        this.Vq = timeout;
    }

    private static byte[] a(ReportCacheKey reportCacheKey, int n2, int n3) {
        try {
            return Cache.getCache().getPageAndWait(reportCacheKey, n2, n3);
        }
        catch (ReportException reportException) {
            throw new WrappedRuntimeException((Throwable)reportException);
        }
    }

    protected byte[] nextChunk() {
        try {
            if (Cache.getCache().getPageCountAndWait(this.ho, this.Vq) > this.page) {
                return ReportCacheInputStream.a(this.ho, ++this.page, this.Vq);
            }
            return null;
        }
        catch (ReportException reportException) {
            throw new WrappedRuntimeException((Throwable)reportException);
        }
    }
}

